/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.Tool;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.PaletteFactory;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.uml.diagram.common.service.AspectUnspecifiedTypeConnectionTool;
import org.eclipse.papyrus.uml.diagram.common.service.AspectUnspecifiedTypeCreationTool;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionInteractionCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.TooltipHook;
import org.eclipse.swt.widgets.Display;

public class SequencePaletteFactory
extends PaletteFactory.Adapter {
    private static final String CREATECOMBINEDFRAGMENTTOOL = "createCombinedFragmentTool";
    private static final String CREATECONSIDERIGNOREFRAGMENTTOOL = "createConsiderIgnoreFragmentTool";
    private static final String CREATEDURATIONCONSTRAINTTOOL = "createDurationConstraintTool";
    private static final String CREATEDURATIONOBSERVATIONTOOL = "createDurationObservationTool";
    private static final String CREATETIMEOBSERVATIONTOOL = "createTimeObservationTool";
    private static final String CREATEDESTRUCTIONEVENTTOOL = "createDestructionEventTool";
    private static final String CREATECOMMENTTOOL = "createCommentTool";
    private static final String CREATECONSTRAINTTOOL = "createConstraintTool";
    private static final String CREATEMESSAGESYNCTOOL = "createMessageSyncTool";
    private static final String CREATEMESSAGEASYNCTOOL = "createMessageAsyncTool";
    private static final String CREATEMESSAGEREPLYTOOL = "createMessageReplyTool";
    private static final String CREATEMESSAGECREATETOOL = "createMessageCreateTool";
    private static final String CREATEMESSAGEDELETETOOL = "createMessageDeleteTool";
    private static final String CREATEMESSAGELOSTTOOL = "createMessageLostTool";
    private static final String CREATEMESSAGEFOUNDTOOL = "createMessageFoundTool";
    private static final String CREATEGENERALORDERINGTOOL = "createGeneralOrderingTool";
    private static final String CREATEANNOTATEDLINKTOOL = "createAnnotatedLinkTool";
    private static final String CREATEGATETOOL = "createGateTool";

    public Tool createTool(String toolId) {
        if (toolId.equals(CREATECOMBINEDFRAGMENTTOOL)) {
            return this.createCombinedFragmentCreationTool();
        }
        if (toolId.equals(CREATECONSIDERIGNOREFRAGMENTTOOL)) {
            return this.createConsiderIgnoreFragmentCreationTool();
        }
        if (toolId.equals(CREATECOMMENTTOOL)) {
            return this.createCommentCreationTool();
        }
        if (toolId.equals(CREATECONSTRAINTTOOL)) {
            return this.createConstraintCreationTool();
        }
        if (toolId.equals(CREATEDURATIONOBSERVATIONTOOL)) {
            return this.createDurationObservationCreationTool();
        }
        if (toolId.equals(CREATETIMEOBSERVATIONTOOL)) {
            return this.createTimeObservationCreationTool();
        }
        if (toolId.equals(CREATEDURATIONCONSTRAINTTOOL)) {
            return this.createDurationConstraintCreationTool();
        }
        if (toolId.equals(CREATEDESTRUCTIONEVENTTOOL)) {
            return this.createDestructionEventCreationTool();
        }
        if (toolId.equals(CREATEMESSAGESYNCTOOL)) {
            return this.createMessageSyncCreationTool();
        }
        if (toolId.equals(CREATEMESSAGEASYNCTOOL)) {
            return this.createMessageAsyncCreationTool();
        }
        if (toolId.equals(CREATEMESSAGEREPLYTOOL)) {
            return this.createMessageReplyCreationTool();
        }
        if (toolId.equals(CREATEMESSAGECREATETOOL)) {
            return this.createMessageCreateCreationTool();
        }
        if (toolId.equals(CREATEMESSAGEDELETETOOL)) {
            return this.createMessageDeleteCreationTool();
        }
        if (toolId.equals(CREATEMESSAGELOSTTOOL)) {
            return this.createMessageLostCreationTool();
        }
        if (toolId.equals(CREATEMESSAGEFOUNDTOOL)) {
            return this.createMessageFoundCreationTool();
        }
        if (toolId.equals(CREATEGENERALORDERINGTOOL)) {
            return this.createGeneralOrderingCreationTool();
        }
        if (toolId.equals(CREATEANNOTATEDLINKTOOL)) {
            return this.createAnnotatedLinkCreationTool();
        }
        if (toolId.equals(CREATEGATETOOL)) {
            return this.createGateTool();
        }
        return null;
    }

    private Tool createGateTool() {
        return new CreationTool(new CreationFactory(){

            public Object getObjectType() {
                return "Gate";
            }

            public Object getNewObject() {
                return "Gate";
            }
        });
    }

    public Object getTemplate(String templateId) {
        return null;
    }

    private Tool createCombinedFragmentCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(2);
        types.add(UMLElementTypes.CombinedFragment_Shape);
        AspectUnspecifiedTypeCreationTool tool = new AspectUnspecifiedTypeCreationTool(types);
        return tool;
    }

    private Tool createConsiderIgnoreFragmentCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(2);
        types.add(UMLElementTypes.ConsiderIgnoreFragment_Shape);
        AspectUnspecifiedTypeCreationTool tool = new AspectUnspecifiedTypeCreationTool(types);
        return tool;
    }

    private Tool createCommentCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(UMLElementTypes.Comment_Shape);
        InteractionChildCreationTool tool = new InteractionChildCreationTool(types);
        return tool;
    }

    private Tool createConstraintCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(UMLElementTypes.Constraint_Shape);
        InteractionChildCreationTool tool = new InteractionChildCreationTool(types);
        return tool;
    }

    private Tool createDurationObservationCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(UMLElementTypes.DurationObservation_Shape);
        InteractionChildCreationTool tool = new InteractionChildCreationTool(types);
        return tool;
    }

    private Tool createTimeObservationCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(UMLElementTypes.TimeObservation_Shape);
        InteractionChildCreationTool tool = new InteractionChildCreationTool(types);
        return tool;
    }

    private Tool createDurationConstraintCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(2);
        types.add(UMLElementTypes.DurationConstraint_Shape);
        InteractionChildCreationTool tool = new InteractionChildCreationTool(types);
        return tool;
    }

    private Tool createDestructionEventCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(UMLElementTypes.DestructionOccurrenceSpecification_Shape);
        AspectUnspecifiedTypeCreationTool tool = new AspectUnspecifiedTypeCreationTool(types);
        return tool;
    }

    private Tool createMessageSyncCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(UMLElementTypes.Message_SynchEdge);
        MessageConnectionTool tool = new MessageConnectionTool(types);
        return tool;
    }

    private Tool createMessageAsyncCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(UMLElementTypes.Message_AsynchEdge);
        MessageConnectionTool tool = new MessageConnectionTool(types);
        return tool;
    }

    private Tool createMessageReplyCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(UMLElementTypes.Message_ReplyEdge);
        MessageConnectionTool tool = new MessageConnectionTool(types);
        return tool;
    }

    private Tool createMessageCreateCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(UMLElementTypes.Message_CreateEdge);
        MessageConnectionTool tool = new MessageConnectionTool(types);
        return tool;
    }

    private Tool createMessageDeleteCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(UMLElementTypes.Message_DeleteEdge);
        MessageConnectionTool tool = new MessageConnectionTool(types);
        return tool;
    }

    private Tool createMessageLostCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(UMLElementTypes.Message_LostEdge);
        MessageConnectionTool tool = new MessageConnectionTool(types);
        return tool;
    }

    private Tool createMessageFoundCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(UMLElementTypes.Message_FoundEdge);
        MessageConnectionTool tool = new MessageConnectionTool(types);
        return tool;
    }

    private Tool createGeneralOrderingCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(UMLElementTypes.GeneralOrdering_Edge);
        AspectUnspecifiedTypeConnectionToolEx tool = new AspectUnspecifiedTypeConnectionToolEx(types);
        return tool;
    }

    private Tool createAnnotatedLinkCreationTool() {
        AspectUnspecifiedTypeConnectionToolEx tool = new AspectUnspecifiedTypeConnectionToolEx(null){

            protected CreateConnectionRequest createTargetRequest() {
                IHintedType type = (IHintedType)UMLElementTypes.Comment_AnnotatedElementEdge;
                return new CreateConnectionViewRequest(new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)type, type.getSemanticHint(), this.getPreferencesHint()));
            }

            protected String getCommandName() {
                if (this.isInState(96)) {
                    return "annotated link end";
                }
                return "annotated link start";
            }

            protected boolean handleCreateConnection() {
                boolean handled = super.handleCreateConnection();
                this.setAvoidDeactivation(false);
                this.eraseSourceFeedback();
                this.deactivate();
                return handled;
            }
        };
        tool.setUnloadWhenFinished(true);
        return tool;
    }

    public static class AspectUnspecifiedTypeConnectionToolEx
    extends AspectUnspecifiedTypeConnectionTool {
        private EditPart source;
        private TooltipHook tooltipHook = null;

        public AspectUnspecifiedTypeConnectionToolEx(List<IElementType> elementTypes) {
            super(elementTypes);
            this.setDisabledCursor(Cursors.NO);
        }

        public void setViewer(EditPartViewer viewer) {
            super.setViewer(viewer);
            if (this.tooltipHook == null || !this.tooltipHook.isHooked(viewer)) {
                if (this.tooltipHook != null) {
                    this.tooltipHook.dispose();
                }
                this.tooltipHook = new TooltipHook(viewer);
            }
        }

        public void deactivate() {
            super.deactivate();
            if (this.tooltipHook != null) {
                this.tooltipHook.dispose();
                this.tooltipHook = null;
            }
        }

        protected void setConnectionSource(EditPart source) {
            this.source = source;
            super.setConnectionSource(source);
        }

        public void clearConnectionFeedback() {
            if (!this.isShowingSourceFeedback()) {
                return;
            }
            if (this.source != null) {
                Request req = this.getSourceRequest();
                req.setType((Object)"connection end");
                this.source.eraseSourceFeedback(req);
            }
        }
    }

    public static class InteractionChildCreationTool
    extends AspectUnspecifiedTypeCreationTool {
        public InteractionChildCreationTool(List<IElementType> elementTypes) {
            super(elementTypes);
        }

        protected boolean updateTargetUnderMouse() {
            if (this.antiScroll) {
                return super.updateTargetUnderMouse();
            }
            if (!this.isTargetLocked()) {
                EditPart editPart = null;
                if (this.getCurrentViewer() != null) {
                    editPart = this.getCurrentViewer().findObjectAtExcluding(this.getLocation(), this.getExclusionSet(), this.getTargetingConditional());
                }
                if (editPart != null) {
                    editPart = this.getInteractionEditPart(editPart);
                }
                boolean changed = this.getTargetEditPart() != editPart;
                this.setTargetEditPart(editPart);
                return changed;
            }
            return false;
        }

        private EditPart getInteractionEditPart(EditPart editPart) {
            if (editPart == null) {
                return null;
            }
            if (editPart instanceof InteractionInteractionCompartmentEditPart) {
                return editPart;
            }
            return this.getInteractionEditPart(editPart.getParent());
        }
    }

    public static class MessageConnectionTool
    extends AspectUnspecifiedTypeConnectionToolEx {
        public MessageConnectionTool(List<IElementType> elementTypes) {
            super(elementTypes);
        }

        protected Point getLocation() {
            Point mouseLocation = this.getCurrentInput().getMouseLocation();
            return mouseLocation;
        }

        protected void selectAddedObject(EditPartViewer viewer, Collection objects) {
            final ArrayList editparts = new ArrayList();
            final EditPart[] primaryEP = new EditPart[1];
            for (Object object : objects) {
                if (!(object instanceof IAdaptable)) continue;
                Object editPart = viewer.getEditPartRegistry().get(((IAdaptable)object).getAdapter(View.class));
                if (editPart instanceof IPrimaryEditPart) {
                    editparts.add(editPart);
                }
                if (!(editPart instanceof ShapeEditPart)) continue;
                primaryEP[0] = (ShapeEditPart)editPart;
            }
            if (!editparts.isEmpty()) {
                viewer.setSelection((ISelection)new StructuredSelection(editparts));
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (primaryEP[0] == null) {
                            primaryEP[0] = (EditPart)editparts.get(0);
                        }
                        if (primaryEP[0].isActive()) {
                            Request request = new Request((Object)"direct edit");
                            request.getExtendedData().put("Direct Edit After Creation", true);
                            primaryEP[0].performRequest(request);
                        }
                    }
                });
            }
        }

        @Override
        public void deactivate() {
            EditPolicy editPolicy;
            EditPart targetEditPart = this.getTargetEditPart();
            if (targetEditPart != null && (editPolicy = targetEditPart.getEditPolicy((Object)"Highlight Edit Policy")) != null) {
                editPolicy.eraseSourceFeedback(this.getTargetRequest());
            }
            super.deactivate();
        }
    }
}

