/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwStorage.HwMemory;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum WritePolicy implements Enumerator
{
    WRITE_BACK(0, "writeBack", "writeBack"),
    WRITE_THROUGH(1, "writeThrough", "writeThrough"),
    OTHER(2, "other", "other"),
    UNDEF(3, "undef", "undef");

    public static final int WRITE_BACK_VALUE = 0;
    public static final int WRITE_THROUGH_VALUE = 1;
    public static final int OTHER_VALUE = 2;
    public static final int UNDEF_VALUE = 3;
    private static final WritePolicy[] VALUES_ARRAY;
    public static final List<WritePolicy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new WritePolicy[]{WRITE_BACK, WRITE_THROUGH, OTHER, UNDEF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static WritePolicy get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            WritePolicy result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static WritePolicy getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            WritePolicy result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static WritePolicy get(int value) {
        switch (value) {
            case 0: {
                return WRITE_BACK;
            }
            case 1: {
                return WRITE_THROUGH;
            }
            case 2: {
                return OTHER;
            }
            case 3: {
                return UNDEF;
            }
        }
        return null;
    }

    private WritePolicy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

