/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE_Library.MeasurementUnits;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LengthUnitKind implements Enumerator
{
    M(0, "m", "m"),
    CM(1, "cm", "cm"),
    MM(2, "mm", "mm");

    public static final int M_VALUE = 0;
    public static final int CM_VALUE = 1;
    public static final int MM_VALUE = 2;
    private static final LengthUnitKind[] VALUES_ARRAY;
    public static final List<LengthUnitKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LengthUnitKind[]{M, CM, MM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LengthUnitKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LengthUnitKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LengthUnitKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LengthUnitKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LengthUnitKind get(int value) {
        switch (value) {
            case 0: {
                return M;
            }
            case 1: {
                return CM;
            }
            case 2: {
                return MM;
            }
        }
        return null;
    }

    private LengthUnitKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

