/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE_Library.TimeTypesLibrary;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TimeStandardKind implements Enumerator
{
    TAI(0, "TAI", "TAI"),
    UT0(1, "UT0", "UT0"),
    UT1(2, "UT1", "UT1"),
    UTC(3, "UTC", "UTC"),
    LOCAL(4, "Local", "Local"),
    TT(5, "TT", "TT"),
    TBD(6, "TBD", "TBD"),
    TCG(7, "TCG", "TCG"),
    TCB(8, "TCB", "TCB"),
    SIDEREAL(9, "Sidereal", "Sidereal"),
    GPS(10, "GPS", "GPS");

    public static final int TAI_VALUE = 0;
    public static final int UT0_VALUE = 1;
    public static final int UT1_VALUE = 2;
    public static final int UTC_VALUE = 3;
    public static final int LOCAL_VALUE = 4;
    public static final int TT_VALUE = 5;
    public static final int TBD_VALUE = 6;
    public static final int TCG_VALUE = 7;
    public static final int TCB_VALUE = 8;
    public static final int SIDEREAL_VALUE = 9;
    public static final int GPS_VALUE = 10;
    private static final TimeStandardKind[] VALUES_ARRAY;
    public static final List<TimeStandardKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TimeStandardKind[]{TAI, UT0, UT1, UTC, LOCAL, TT, TBD, TCG, TCB, SIDEREAL, GPS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TimeStandardKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeStandardKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeStandardKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeStandardKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeStandardKind get(int value) {
        switch (value) {
            case 0: {
                return TAI;
            }
            case 1: {
                return UT0;
            }
            case 2: {
                return UT1;
            }
            case 3: {
                return UTC;
            }
            case 4: {
                return LOCAL;
            }
            case 5: {
                return TT;
            }
            case 6: {
                return TBD;
            }
            case 7: {
                return TCG;
            }
            case 8: {
                return TCB;
            }
            case 9: {
                return SIDEREAL;
            }
            case 10: {
                return GPS;
            }
        }
        return null;
    }

    private TimeStandardKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

