/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.tabbedproperties.sections;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtPortSlot;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtSpecification;
import org.polarsys.chess.tabbedproperties.sections.TableCellMouseListener;

public class CHRtSpecificationProperty
extends AbstractPropertySection {
    private Table chrtTable;
    private String[] chrtTitles = new String[]{"instance", "context", "arrivalPattern", "localWCET", "rldl", "priority"};
    private ControlAdapter resizeListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            int d = 10;
            int x = ((CHRtSpecificationProperty)CHRtSpecificationProperty.this).chrtTable.getSize().x - d;
            int width = x / CHRtSpecificationProperty.this.chrtTitles.length - CHRtSpecificationProperty.this.chrtTitles.length;
            TableColumn[] columns = CHRtSpecificationProperty.this.chrtTable.getColumns();
            int i = 0;
            while (i < columns.length) {
                TableColumn tc = columns[i];
                tc.setWidth(width);
                ++i;
            }
        }
    };

    public void setInput(IWorkbenchPart part, ISelection selection) {
        StructuredSelection structSelection;
        super.setInput(part, selection);
        this.refresh();
        this.cleanPropertyTab();
        ArrayList<CHRtPortSlot> chrtList = new ArrayList<CHRtPortSlot>();
        Object obj = null;
        if (selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            obj = treeSelection.getFirstElement();
        } else if (selection instanceof StructuredSelection && (structSelection = (StructuredSelection)selection).toArray().length == 1) {
            obj = structSelection.toArray()[0];
        }
        EObject eobj = null;
        if (obj instanceof EObjectTreeElement) {
            eobj = ((EObjectTreeElement)obj).getEObject();
        } else if (obj instanceof EObject) {
            eobj = (EObject)obj;
        }
        if (eobj instanceof Slot && ((Slot)eobj).getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtPortSlot") != null) {
            Slot slot = (Slot)eobj;
            Stereotype stereo = slot.getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtPortSlot");
            CHRtPortSlot chrtSlot = (CHRtPortSlot)slot.getStereotypeApplication(stereo);
            chrtList.add(chrtSlot);
            this.initTable(chrtList);
        }
        if (eobj instanceof InstanceSpecification) {
            InstanceSpecification inst = (InstanceSpecification)eobj;
            for (Slot slot : inst.getSlots()) {
                if (slot.getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtPortSlot") == null) continue;
                Stereotype stereo = slot.getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtPortSlot");
                CHRtPortSlot chrtSlot = (CHRtPortSlot)slot.getStereotypeApplication(stereo);
                chrtList.add(chrtSlot);
            }
            if (chrtList.size() > 0) {
                this.initTable(chrtList);
            }
        }
        if (eobj instanceof Package) {
            Package pkg = (Package)eobj;
            for (PackageableElement elem : pkg.getPackagedElements()) {
                if (!(elem instanceof InstanceSpecification)) continue;
                InstanceSpecification inst = (InstanceSpecification)elem;
                for (Slot slot : inst.getSlots()) {
                    if (slot.getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtPortSlot") == null) continue;
                    Stereotype stereo = slot.getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtPortSlot");
                    CHRtPortSlot chrtSlot = (CHRtPortSlot)slot.getStereotypeApplication(stereo);
                    chrtList.add(chrtSlot);
                }
            }
            if (chrtList.size() > 0) {
                this.initTable(chrtList);
            }
        }
    }

    private void initTable(List<CHRtPortSlot> chrtSlotList) {
        this.cleanPropertyTab();
        for (CHRtPortSlot chrtSlot : chrtSlotList) {
            String instanceName = chrtSlot.getBase_Slot().getOwningInstance().getName();
            for (CHRtSpecification chrtspec : chrtSlot.getCH_RtSpecification()) {
                TableItem item = new TableItem(this.chrtTable, 0);
                InstanceSpecification inst = chrtSlot.getBase_Slot().getOwningInstance();
                Operation op = (Operation)chrtspec.getContext();
                AbstractMap.SimpleEntry<InstanceSpecification, Operation> data = new AbstractMap.SimpleEntry<InstanceSpecification, Operation>(inst, op);
                item.setData(data);
                item.setText(0, instanceName);
                if (chrtspec.getContext() != null) {
                    item.setText(1, chrtspec.getContext().getName());
                }
                if (chrtspec.getOccKind() != null) {
                    item.setText(2, chrtspec.getOccKind());
                }
                if (chrtspec.getLocalWCET() != null) {
                    item.setText(3, chrtspec.getLocalWCET());
                }
                if (chrtspec.getRlDl() != null) {
                    item.setText(4, chrtspec.getRlDl());
                }
                if (chrtspec.getRelativePriority() == null) continue;
                item.setText(5, chrtspec.getRelativePriority());
            }
        }
    }

    private void cleanPropertyTab() {
        this.chrtTable.removeAll();
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite container = this.getWidgetFactory().createComposite(parent, 0);
        GridLayout gridLayout = new GridLayout(8, true);
        container.setLayout((Layout)gridLayout);
        GridData data = new GridData(4, 4, false, false);
        this.chrtTable = new Table(container, 2816);
        this.chrtTable.setLinesVisible(true);
        this.chrtTable.setHeaderVisible(true);
        this.chrtTable.addControlListener((ControlListener)this.resizeListener);
        data = new GridData(4, 4, true, true, 8, 8);
        this.chrtTable.setLayoutData((Object)data);
        int i = 0;
        while (i < this.chrtTitles.length) {
            TableColumn column = new TableColumn(this.chrtTable, 0);
            column.setText(this.chrtTitles[i]);
            ++i;
        }
        i = 0;
        while (i < this.chrtTitles.length) {
            this.chrtTable.getColumn(i).pack();
            ++i;
        }
        this.chrtTable.addMouseListener((MouseListener)new TableCellMouseListener(this.chrtTable));
    }
}

