/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.editor.basetype.formatting2;

import com.google.inject.Inject;
import eu.fbk.tools.editor.basetype.baseType.BoundedArrayType;
import eu.fbk.tools.editor.basetype.baseType.EnumType;
import eu.fbk.tools.editor.basetype.services.BaseTypeGrammarAccess;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;

public class BaseTypeFormatter
extends AbstractFormatter2 {
    @Inject
    @Extension
    private BaseTypeGrammarAccess grammarAccess;

    protected void _format(EnumType enumType, @Extension IFormattableDocument document) {
        EList<EObject> _values = enumType.getValues();
        for (EObject eObject : _values) {
            document.format((Object)eObject);
        }
    }

    protected void _format(BoundedArrayType arrayType, @Extension IFormattableDocument document) {
        document.format((Object)arrayType.getType());
    }

    public void format(Object arrayType, IFormattableDocument document) {
        if (arrayType instanceof BoundedArrayType) {
            this._format((BoundedArrayType)arrayType, document);
            return;
        }
        if (arrayType instanceof EnumType) {
            this._format((EnumType)arrayType, document);
            return;
        }
        if (arrayType instanceof XtextResource) {
            this._format((XtextResource)arrayType, document);
            return;
        }
        if (arrayType instanceof EObject) {
            this._format((EObject)arrayType, document);
            return;
        }
        if (arrayType == null) {
            this._format(null, document);
            return;
        }
        if (arrayType != null) {
            this._format(arrayType, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(arrayType, document).toString());
    }
}

