/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.core.registries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.runtime.emf.type.core.ClientContextManager;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeUtil;
import org.eclipse.gmf.runtime.emf.type.core.IAdviceBindingDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrus.infra.types.AbstractAdviceBindingConfiguration;
import org.eclipse.papyrus.infra.types.AdviceConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.ExternallyRegisteredAdvice;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.infra.types.core.Activator;
import org.eclipse.papyrus.infra.types.core.registries.AdviceConfigurationTypeRegistry;
import org.eclipse.papyrus.infra.types.core.registries.ElementTypeConfigurationTypeRegistry;
import org.eclipse.papyrus.infra.types.core.utils.ElementTypeRegistryUtils;
import org.eclipse.papyrus.infra.types.core.utils.OrientedGraph;
import org.eclipse.papyrus.infra.types.core.utils.TypesConfigurationsCycleUtil;
import org.osgi.framework.Bundle;

public class ElementTypeSetConfigurationRegistry {
    protected static ElementTypeSetConfigurationRegistry elementTypeSetConfigurationRegistry;
    protected Map<String, Map<String, ElementTypeSetConfiguration>> elementTypeSetConfigurations = null;
    protected Map<String, OrientedGraph<String>> advicesDeps = null;
    protected ResourceSet elementTypeSetConfigurationResourceSet = null;

    public static synchronized ElementTypeSetConfigurationRegistry getInstance() {
        if (elementTypeSetConfigurationRegistry == null) {
            elementTypeSetConfigurationRegistry = new ElementTypeSetConfigurationRegistry();
            elementTypeSetConfigurationRegistry.init();
        }
        return elementTypeSetConfigurationRegistry;
    }

    protected void init() {
        this.elementTypeSetConfigurationResourceSet = null;
        this.elementTypeSetConfigurations = new HashMap<String, Map<String, ElementTypeSetConfiguration>>();
        this.advicesDeps = new HashMap<String, OrientedGraph<String>>();
        this.elementTypeSetConfigurationResourceSet = this.createResourceSet();
        Map<String, Set<ElementTypeSetConfiguration>> elementTypeSetConfigurationsToLoad = this.readElementTypeSetConfigurationModelsFromExtensionPoints();
        for (String contexId : elementTypeSetConfigurationsToLoad.keySet()) {
            this.loadElementTypeSetConfigurations(contexId, (Collection<ElementTypeSetConfiguration>)elementTypeSetConfigurationsToLoad.get(contexId));
        }
    }

    protected Map<String, Set<ElementTypeSetConfiguration>> readElementTypeSetConfigurationModels() {
        HashMap<String, Set<ElementTypeSetConfiguration>> elementTypeSetConfigurations = new HashMap<String, Set<ElementTypeSetConfiguration>>();
        return elementTypeSetConfigurations;
    }

    public synchronized void dispose() {
        if (this.elementTypeSetConfigurations == null) {
            return;
        }
        for (String contextId : this.elementTypeSetConfigurations.keySet()) {
            for (String elementTypeSetId : this.elementTypeSetConfigurations.get(contextId).keySet()) {
                this.unload(contextId, elementTypeSetId);
            }
        }
        this.elementTypeSetConfigurationResourceSet = null;
        this.elementTypeSetConfigurations = null;
        elementTypeSetConfigurationRegistry = null;
    }

    public boolean loadElementTypeSetConfiguration(String contextId, String path) {
        if (path == null) {
            Activator.log.warn("Path must not be null" + path);
            return false;
        }
        if (contextId == null) {
            Activator.log.warn("contextId must not be null" + path);
            return false;
        }
        URI localURI = URI.createPlatformResourceURI((String)path, (boolean)true);
        Resource resource = this.elementTypeSetConfigurationResourceSet.createResource(localURI);
        try {
            resource.load(null);
            EObject content = (EObject)resource.getContents().get(0);
            if (content instanceof ElementTypeSetConfiguration) {
                return this.loadElementTypeSetConfiguration(contextId, (ElementTypeSetConfiguration)content);
            }
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        return false;
    }

    public boolean loadElementTypeSetConfiguration(String clientContextID, ElementTypeSetConfiguration elementTypeSetConfiguration) {
        return this.loadElementTypeSetConfigurations(clientContextID, Collections.singleton(elementTypeSetConfiguration));
    }

    public OrientedGraph<String> getAdvicesDeps(String clientContextID) {
        OrientedGraph<String> dependencies = this.advicesDeps.get(clientContextID);
        if (dependencies == null) {
            dependencies = new OrientedGraph();
            this.advicesDeps.put(clientContextID, dependencies);
        }
        return dependencies;
    }

    protected boolean isAlreadyRegistred(String elementTypeID, IClientContext context) {
        if (ElementTypeRegistry.getInstance().getType(elementTypeID) != null) {
            if (!elementTypeID.equals("org.eclipse.gmf.runtime.emf.type.core.null") && ElementTypeRegistryUtils.getType(context, elementTypeID) == null) {
                context.bindId(elementTypeID);
                Activator.log.info(String.valueOf(elementTypeID) + " is already registred elementtype but it is not binded yet. It has been binded to Papyrus context. ");
            }
            return true;
        }
        return false;
    }

    protected boolean registerElementTypeConfiguration(ElementTypeConfiguration elementTypeConfiguration, Map<String, ElementTypeConfiguration> elementTypeConfigurationsDefinitions, IClientContext context) {
        IElementType elementType;
        String elementTypeID = elementTypeConfiguration.getIdentifier();
        if (this.isAlreadyRegistred(elementTypeID, context)) {
            return true;
        }
        if (elementTypeConfiguration instanceof SpecializationTypeConfiguration) {
            for (String specializedTypeId : ((SpecializationTypeConfiguration)elementTypeConfiguration).getSpecializedTypesID()) {
                if (this.isAlreadyRegistred(specializedTypeId, context)) continue;
                ElementTypeConfiguration specializedTypeConfiguration = elementTypeConfigurationsDefinitions.get(specializedTypeId);
                if (specializedTypeConfiguration != null) {
                    boolean registred = this.registerElementTypeConfiguration(specializedTypeConfiguration, elementTypeConfigurationsDefinitions, context);
                    if (registred) continue;
                    Activator.log.info("Failed to register " + specializedTypeId);
                    return false;
                }
                if (specializedTypeId.equals("org.eclipse.gmf.runtime.emf.type.core.null")) continue;
                Activator.log.info("Cannot find ElementTypeConfiguration for " + specializedTypeId);
                return false;
            }
        }
        if ((elementType = ElementTypeConfigurationTypeRegistry.getInstance().getElementType(elementTypeConfiguration)) != null) {
            if (elementType instanceof ISpecializationType) {
                if (ElementTypeRegistry.getInstance().register((ISpecializationType)elementType)) {
                    context.bindId(elementType.getId());
                    return true;
                }
                Activator.log.info("SpecializationType not added: " + elementType);
            } else if (elementType instanceof IMetamodelType) {
                if (ElementTypeRegistry.getInstance().register((IMetamodelType)elementType)) {
                    context.bindId(elementType.getId());
                    return true;
                }
                Activator.log.info("MetamodelType not added: " + elementType);
                ElementTypeRegistry.getInstance().register((IMetamodelType)elementType);
            }
        }
        return false;
    }

    public boolean loadElementTypeSetConfigurations(String contexId, Collection<ElementTypeSetConfiguration> elementTypeSetConfigurationsToRegister) {
        EObject element;
        TreeIterator it;
        if (contexId == null) {
            Activator.log.warn("contexId must not be null. Loading aborted. ");
            return false;
        }
        IClientContext context = ClientContextManager.getInstance().getClientContext(contexId);
        if (context == null) {
            Activator.log.warn("contexId couldn't be found. Loading aborted: " + contexId);
            return false;
        }
        HashMap<String, ElementTypeConfiguration> elementTypeConfigurationsDefinitions = new HashMap<String, ElementTypeConfiguration>();
        HashSet<ElementTypeSetConfiguration> registrableElementTypeSetConfiguration = new HashSet<ElementTypeSetConfiguration>();
        for (ElementTypeSetConfiguration elementTypeSetConfiguration : elementTypeSetConfigurationsToRegister) {
            if (elementTypeSetConfiguration == null) {
                Activator.log.warn("The collection of elementTypesconfigurations contains a null value. Loading aborted. ");
                return false;
            }
            if (this.elementTypeSetConfigurations.containsKey(elementTypeSetConfiguration.getIdentifier())) {
                Activator.log.warn("The following ElementTypesSetConfiguration has been ignored because the same ID already registreted: " + elementTypeSetConfiguration.getIdentifier());
                continue;
            }
            registrableElementTypeSetConfiguration.add(elementTypeSetConfiguration);
            for (ElementTypeConfiguration elementTypeConfiguration : elementTypeSetConfiguration.getElementTypeConfigurations()) {
                elementTypeConfigurationsDefinitions.put(elementTypeConfiguration.getIdentifier(), elementTypeConfiguration);
            }
        }
        HashSet<ElementTypeConfiguration> elementTypesToCheck = new HashSet<ElementTypeConfiguration>();
        if (this.elementTypeSetConfigurations.containsKey(contexId)) {
            for (ElementTypeSetConfiguration elementTypeSetConfiguration : this.elementTypeSetConfigurations.get(contexId).values()) {
                elementTypesToCheck.addAll((Collection<ElementTypeConfiguration>)elementTypeSetConfiguration.getElementTypeConfigurations());
            }
        }
        elementTypesToCheck.addAll(elementTypeConfigurationsDefinitions.values());
        OrientedGraph<String> elementTypesDeps = TypesConfigurationsCycleUtil.getDependenciesAmongElementTypes(elementTypesToCheck);
        Collection<Collection<Object>> cyclesElementTypes = TypesConfigurationsCycleUtil.getCyclesAmongElementTypes(elementTypesDeps.getVertices(), elementTypesDeps.getEdges());
        if (!cyclesElementTypes.isEmpty()) {
            Activator.log.warn("The ElementTypesConfiguration registration has been aborted because there is at least a cyclic-dependency in the ElementTypes definitions: " + cyclesElementTypes);
            return false;
        }
        HashSet<AdviceConfiguration> adviceToCheck = new HashSet<AdviceConfiguration>();
        if (this.elementTypeSetConfigurations.containsKey(contexId)) {
            for (ElementTypeSetConfiguration elementTypeSetConfiguration : this.elementTypeSetConfigurations.get(contexId).values()) {
                it = elementTypeSetConfiguration.eAllContents();
                while (it.hasNext()) {
                    element = (EObject)it.next();
                    if (!(element instanceof AdviceConfiguration)) continue;
                    adviceToCheck.add((AdviceConfiguration)element);
                }
            }
        }
        for (ElementTypeSetConfiguration elementTypeSetConfiguration : registrableElementTypeSetConfiguration) {
            it = elementTypeSetConfiguration.eAllContents();
            while (it.hasNext()) {
                element = (EObject)it.next();
                if (!(element instanceof AdviceConfiguration)) continue;
                adviceToCheck.add((AdviceConfiguration)element);
            }
        }
        OrientedGraph<String> deps = TypesConfigurationsCycleUtil.getDependenciesAmongAdvices(adviceToCheck);
        Collection<Collection<Object>> cyclesAdvices = TypesConfigurationsCycleUtil.getCyclesInAdvices(deps.getVertices(), deps.getEdges());
        if (!cyclesAdvices.isEmpty()) {
            Activator.log.warn("The ElementTypesConfiguration registration has been aborted because there is at least a cyclic-dependencies in the Advices definitions: " + cyclesAdvices);
            return false;
        }
        for (ElementTypeSetConfiguration elementTypeSetConfiguration : registrableElementTypeSetConfiguration) {
            if (!this.elementTypeSetConfigurations.containsKey(contexId)) {
                this.elementTypeSetConfigurations.put(contexId, new HashMap());
            }
            this.elementTypeSetConfigurations.get(contexId).put(elementTypeSetConfiguration.getIdentifier(), elementTypeSetConfiguration);
        }
        for (ElementTypeConfiguration elementTypeConfiguration : elementTypeConfigurationsDefinitions.values()) {
            this.registerElementTypeConfiguration(elementTypeConfiguration, elementTypeConfigurationsDefinitions, context);
        }
        for (ElementTypeSetConfiguration elementTypeSetConfiguration : registrableElementTypeSetConfiguration) {
            EList adviceBindingConfigurations = elementTypeSetConfiguration.getAdviceBindingsConfigurations();
            for (AbstractAdviceBindingConfiguration adviceBindingConfiguration : adviceBindingConfigurations) {
                if (adviceBindingConfiguration instanceof ExternallyRegisteredAdvice) {
                    context.bindId(adviceBindingConfiguration.getIdentifier());
                    continue;
                }
                IAdviceBindingDescriptor editHelperAdviceDecriptor = AdviceConfigurationTypeRegistry.getInstance().getEditHelperAdviceDecriptor(adviceBindingConfiguration);
                ElementTypeRegistryUtils.registerAdviceBinding(editHelperAdviceDecriptor);
                context.bindId(editHelperAdviceDecriptor.getId());
            }
        }
        this.advicesDeps.put(contexId, deps);
        return true;
    }

    public boolean unload(String contextId, String elementTypeSetId) {
        Resource resource;
        if (this.elementTypeSetConfigurations == null) {
            return false;
        }
        if (!this.elementTypeSetConfigurations.containsKey(contextId)) {
            return false;
        }
        Map<String, ElementTypeSetConfiguration> map = this.elementTypeSetConfigurations.get(contextId);
        ElementTypeSetConfiguration elementTypeSet = map.remove(elementTypeSetId);
        if (elementTypeSet == null) {
            return false;
        }
        ElementTypeRegistry registry = ElementTypeRegistry.getInstance();
        ArrayList<IElementType> elementTypes = new ArrayList<IElementType>(elementTypeSet.getElementTypeConfigurations().size());
        for (ElementTypeConfiguration elementTypeConfiguration : elementTypeSet.getElementTypeConfigurations()) {
            Object configIdentifier;
            IElementType elementType;
            if (elementTypeConfiguration == null || elementTypeConfiguration.getIdentifier() == null || (elementType = registry.getType((String)(configIdentifier = elementTypeConfiguration.getIdentifier()))) == null) continue;
            elementTypes.add(elementType);
        }
        ElementTypeUtil.deregisterElementTypes(elementTypes, (int)7);
        EList adviceBindingConfigurations = elementTypeSet.getAdviceBindingsConfigurations();
        for (AbstractAdviceBindingConfiguration adviceBindingConfiguration : adviceBindingConfigurations) {
            IAdviceBindingDescriptor advice = AdviceConfigurationTypeRegistry.getInstance().getEditHelperAdviceDecriptor(adviceBindingConfiguration);
            if (advice == null) continue;
            ElementTypeRegistryUtils.removeAdviceDescriptorFromBindings(advice);
        }
        if (this.elementTypeSetConfigurationResourceSet != null && (resource = elementTypeSet.eResource()) != null && resource.getResourceSet() == this.elementTypeSetConfigurationResourceSet) {
            resource.unload();
            this.elementTypeSetConfigurationResourceSet.getResources().remove((Object)resource);
        }
        HashSet<AdviceConfiguration> advices = new HashSet<AdviceConfiguration>();
        for (ElementTypeSetConfiguration elementTypeSetConfiguration : this.elementTypeSetConfigurations.get(contextId).values()) {
            TreeIterator it = elementTypeSetConfiguration.eAllContents();
            while (it.hasNext()) {
                EObject element = (EObject)it.next();
                if (!(element instanceof AdviceConfiguration)) continue;
                advices.add((AdviceConfiguration)element);
            }
        }
        OrientedGraph<String> deps = TypesConfigurationsCycleUtil.getDependenciesAmongAdvices(advices);
        this.advicesDeps.put(contextId, deps);
        return true;
    }

    protected void addElementTypeSetConfigurationToDefinitions(ElementTypeSetConfiguration set, String clientContextId, Map<String, Set<ElementTypeSetConfiguration>> existingDefinitions) {
        if (set.getIdentifier() == null) {
            Activator.log.warn("The following ElementTypesSetConfiguration has ill-defined ID and is therefore ignored: " + set.eResource().getURI());
        } else if (set != null) {
            if (existingDefinitions.get(clientContextId) != null && this.containsElementTypeSet(existingDefinitions.get(clientContextId), set.getIdentifier())) {
                Activator.log.warn("The following ElementTypesSetConfiguration has been ignored because the same ID already registreted: " + set.getIdentifier());
            } else {
                if (!existingDefinitions.containsKey(clientContextId)) {
                    existingDefinitions.put(clientContextId, new HashSet());
                }
                existingDefinitions.get(clientContextId).add(set);
            }
        }
    }

    protected Map<String, Set<ElementTypeSetConfiguration>> readElementTypeSetConfigurationModelsFromExtensionPoints() {
        IConfigurationElement[] elements;
        HashMap<String, Set<ElementTypeSetConfiguration>> existingDefinitions = new HashMap<String, Set<ElementTypeSetConfiguration>>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.types.core.elementTypeSetConfiguration");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ElementTypeSetConfiguration set;
            IConfigurationElement element = iConfigurationElementArray[n2];
            String modelPath = element.getAttribute("path");
            String clientContextId = element.getAttribute("clientContextID");
            String contributorID = element.getContributor().getName();
            if (Platform.inDebugMode()) {
                Activator.log.debug("[Reading extension point]");
                Activator.log.debug("-  Path to the model: " + modelPath);
                Activator.log.debug("-  ClientContext the model should be registreted to: " + clientContextId);
                Activator.log.debug("-  id of the container bundle: " + contributorID);
            }
            if ((set = this.getElementTypeSetConfiguration(modelPath, contributorID)) != null) {
                this.addElementTypeSetConfigurationToDefinitions(set, clientContextId, existingDefinitions);
            }
            ++n2;
        }
        return existingDefinitions;
    }

    protected boolean containsElementTypeSet(Set<ElementTypeSetConfiguration> elementTypeSets, String elementTypeSetConfigurationId) {
        if (elementTypeSets == null) {
            return false;
        }
        for (ElementTypeSetConfiguration elementTypeSetConfiguration : elementTypeSets) {
            if (!elementTypeSetConfiguration.getIdentifier().equals(elementTypeSetConfigurationId)) continue;
            return true;
        }
        return false;
    }

    protected ElementTypeSetConfiguration getElementTypeSetConfiguration(String modelPath, String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (Platform.isFragment((Bundle)bundle)) {
            ElementTypeSetConfiguration configuration = this.getElementTypeSetConfigurationInBundle(modelPath, bundleId);
            if (configuration == null) {
                Activator.log.warn("Cannot find resource " + modelPath + " in bundle " + bundleId);
            }
            return configuration;
        }
        Bundle[] fragments = Platform.getFragments((Bundle)bundle);
        if (fragments == null) {
            return this.getElementTypeSetConfigurationInBundle(modelPath, bundleId);
        }
        ElementTypeSetConfiguration elementTypeSetConfiguration = null;
        Bundle[] bundleArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle fragment = bundleArray[n2];
            elementTypeSetConfiguration = this.getElementTypeSetConfigurationInBundle(modelPath, fragment.getSymbolicName());
            if (elementTypeSetConfiguration != null) break;
            ++n2;
        }
        if (elementTypeSetConfiguration == null) {
            elementTypeSetConfiguration = this.getElementTypeSetConfigurationInBundle(modelPath, bundleId);
        }
        if (elementTypeSetConfiguration == null) {
            Activator.log.warn("Cannot find resource " + modelPath + " in bundle " + bundleId);
        }
        return elementTypeSetConfiguration;
    }

    protected ElementTypeSetConfiguration getElementTypeSetConfigurationInBundle(String modelPath, String bundleID) {
        String path = String.valueOf(bundleID) + '/' + modelPath;
        Resource resource = this.elementTypeSetConfigurationResourceSet.createResource(URI.createPlatformPluginURI((String)path, (boolean)true));
        try {
            resource.load(null);
        }
        catch (IOException e) {
            return null;
        }
        EObject content = (EObject)resource.getContents().get(0);
        if (content instanceof ElementTypeSetConfiguration) {
            return (ElementTypeSetConfiguration)content;
        }
        return null;
    }

    protected ResourceSet createResourceSet() {
        ResourceSetImpl set = new ResourceSetImpl();
        set.getLoadOptions().put("DEFER_ATTACHMENT", true);
        set.getLoadOptions().put("DEFER_IDREF_RESOLUTION", true);
        set.getLoadOptions().put("USE_PACKAGE_NS_URI_AS_LOCATION", Boolean.FALSE);
        return set;
    }

    public Map<String, Map<String, ElementTypeSetConfiguration>> getElementTypeSetConfigurations() {
        return this.elementTypeSetConfigurations;
    }
}

