/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;

public abstract class AbstractItemProviderAdapterFactoryRegistryTestCase
extends TestCase {
    private static final String THE_ITEM_PROVIDER_ADAPTER_FACTORY_OF_THE_PACKAGE = "The item provider adapter factory of the package ";
    private final ComposedAdapterFactory.Descriptor.Registry registry = ComposedAdapterFactory.Descriptor.Registry.INSTANCE;
    private final Collection<EPackage> exposedItemProvidersAdapterFactories = Sets.newLinkedHashSet();
    private final Collection<EPackage> nonExposedItemProvidersAdapterFactories = Sets.newLinkedHashSet();
    private EPackage basePackage;
    private final Predicate<EPackage> shouldBeExposed = new Predicate<EPackage>(){

        public boolean apply(EPackage input) {
            return AbstractItemProviderAdapterFactoryRegistryTestCase.this.exposedItemProvidersAdapterFactories.contains(input);
        }
    };
    private final Predicate<EPackage> shouldNotBeExposed = new Predicate<EPackage>(){

        public boolean apply(EPackage input) {
            return AbstractItemProviderAdapterFactoryRegistryTestCase.this.nonExposedItemProvidersAdapterFactories.contains(input);
        }
    };
    private final Function<EPackage, Collection<?>> getKey = new Function<EPackage, Collection<?>>(){

        public Collection<?> apply(EPackage from) {
            ArrayList key = Lists.newArrayList();
            key.add(from);
            key.add(IItemLabelProvider.class);
            return key;
        }
    };

    public EPackage getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(EPackage basePackage) {
        this.basePackage = basePackage;
    }

    public void setPackagesWithExposedAdapterFactory(Collection<EPackage> packages) {
        this.exposedItemProvidersAdapterFactories.addAll(packages);
    }

    public void setPackagesWithNonExposedAdapterFactory(Collection<EPackage> packages) {
        this.nonExposedItemProvidersAdapterFactories.addAll(packages);
    }

    public abstract void initPackages();

    protected void setUp() throws Exception {
        this.initPackages();
        super.setUp();
        TestCase.assertNotNull((String)"Base package should not be null.", (Object)this.basePackage);
    }

    public void testExposedAdapterFactories() {
        this.testEPackageExposed(this.basePackage);
    }

    private void testEPackageExposed(EPackage pkg) {
        boolean notExposedExpected;
        ComposedAdapterFactory.Descriptor descriptor = this.registry.getDescriptor((Collection)this.getKey.apply((Object)pkg));
        String label = String.valueOf(pkg.getName()) + " (" + pkg.getNsURI() + ") ";
        boolean exposedExpected = this.shouldBeExposed.apply((Object)pkg);
        if (exposedExpected) {
            TestCase.assertNotNull((String)(THE_ITEM_PROVIDER_ADAPTER_FACTORY_OF_THE_PACKAGE + label + "should be exposed."), (Object)descriptor);
            AdapterFactory adapterFactory = descriptor.createAdapterFactory();
            TestCase.assertNotNull((String)("Error creating while creating the item provider adapter factory of the package " + label), (Object)adapterFactory);
        }
        if (notExposedExpected = this.shouldNotBeExposed.apply((Object)pkg)) {
            TestCase.assertNull((String)(THE_ITEM_PROVIDER_ADAPTER_FACTORY_OF_THE_PACKAGE + label + "should not be exposed."), (Object)descriptor);
        }
        if (exposedExpected && notExposedExpected || !exposedExpected && !notExposedExpected) {
            TestCase.fail((String)(THE_ITEM_PROVIDER_ADAPTER_FACTORY_OF_THE_PACKAGE + label + "is not known or invalid for the current test. Please check with the team if it should be exposed or not and then complete the test."));
        }
        for (EPackage subPkg : pkg.getESubpackages()) {
            this.testEPackageExposed(subPkg);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.exposedItemProvidersAdapterFactories.clear();
        this.basePackage = null;
    }
}

