/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.core.target.DirectoryBundleContainer;
import org.eclipse.pde.internal.core.target.FeatureBundleContainer;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.ProfileBundleContainer;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.shared.target.EditDirectoryContainerPage;
import org.eclipse.pde.internal.ui.shared.target.EditFeatureContainerPage;
import org.eclipse.pde.internal.ui.shared.target.EditIUContainerPage;
import org.eclipse.pde.internal.ui.shared.target.EditProfileContainerPage;
import org.eclipse.pde.internal.ui.shared.target.IEditBundleContainerPage;
import org.eclipse.pde.internal.ui.shared.target.Messages;

public class EditBundleContainerWizard
extends Wizard {
    private ITargetDefinition fTarget;
    private ITargetLocation fContainer;
    private IEditBundleContainerPage fPage;

    public EditBundleContainerWizard(ITargetDefinition target, ITargetLocation container) {
        this.fTarget = target;
        this.fContainer = container;
        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().getSection("editBundleContainerWizard");
        if (settings == null) {
            settings = PDEPlugin.getDefault().getDialogSettings().addNewSection("editBundleContainerWizard");
        }
        this.setDialogSettings(settings);
        this.setWindowTitle(Messages.EditBundleContainerWizard_0);
    }

    public void addPages() {
        if (this.fContainer instanceof DirectoryBundleContainer) {
            this.fPage = new EditDirectoryContainerPage(this.fContainer);
        } else if (this.fContainer instanceof ProfileBundleContainer) {
            this.fPage = new EditProfileContainerPage(this.fContainer);
        } else if (this.fContainer instanceof FeatureBundleContainer) {
            this.fPage = new EditFeatureContainerPage(this.fContainer);
        } else if (this.fContainer instanceof IUBundleContainer) {
            this.fPage = new EditIUContainerPage((IUBundleContainer)this.fContainer, this.fTarget);
        }
        if (this.fPage != null) {
            this.addPage(this.fPage);
        }
    }

    public boolean performFinish() {
        if (this.fPage != null) {
            this.fPage.storeSettings();
            ITargetLocation newContainer = this.fPage.getBundleContainer();
            if (newContainer != null) {
                ITargetLocation[] containers = this.fTarget.getTargetLocations();
                ArrayList<ITargetLocation> newContainers = new ArrayList<ITargetLocation>(containers.length);
                int i = 0;
                while (i < containers.length) {
                    if (!containers[i].equals(this.fContainer)) {
                        newContainers.add(containers[i]);
                    }
                    ++i;
                }
                newContainers.add(newContainer);
                this.fTarget.setTargetLocations(newContainers.toArray(new ITargetLocation[newContainers.size()]));
            }
            return true;
        }
        return false;
    }
}

