/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import com.ibm.icu.text.MessageFormat;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.metadata.TranslationSupport;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.target.DirectoryBundleContainer;
import org.eclipse.pde.internal.core.target.FeatureBundleContainer;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.ProfileBundleContainer;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.shared.target.IUContentProvider;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class StyledBundleLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider {
    private boolean fShowVersion = true;
    private boolean fAppendResolvedVariables = false;
    private TranslationSupport fTranslations;

    public StyledBundleLabelProvider(boolean showVersion, boolean appendResolvedVariables) {
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.fShowVersion = showVersion;
        this.fAppendResolvedVariables = appendResolvedVariables;
        this.fTranslations = TranslationSupport.getInstance();
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        StyledString styledString = this.getStyledString(element);
        cell.setText(styledString.toString());
        cell.setStyleRanges(styledString.getStyleRanges());
        cell.setImage(this.getImage(element));
        super.update(cell);
    }

    private StyledString getStyledString(Object element) {
        StyledString styledString = new StyledString();
        if (element instanceof BundleInfo) {
            this.appendBundleInfo(styledString, (BundleInfo)element);
        } else if (element instanceof NameVersionDescriptor) {
            this.appendBundleInfo(styledString, new BundleInfo(((NameVersionDescriptor)element).getId(), ((NameVersionDescriptor)element).getVersion(), null, -1, false));
        } else if (element instanceof TargetBundle) {
            TargetBundle bundle = (TargetBundle)element;
            if (bundle.getStatus().isOK()) {
                this.appendBundleInfo(styledString, bundle.getBundleInfo());
            } else {
                styledString.append(bundle.getStatus().getMessage());
            }
        } else if (element instanceof IStatus) {
            styledString.append(((IStatus)element).getMessage());
        } else if (element instanceof IPath) {
            styledString.append(((IPath)element).removeFirstSegments(1).toString());
        } else if (element instanceof TargetFeature) {
            this.appendBundleInfo(styledString, new BundleInfo(((TargetFeature)element).getId(), ((TargetFeature)element).getVersion(), null, -1, false));
        } else if (element instanceof FeatureBundleContainer) {
            FeatureBundleContainer container = (FeatureBundleContainer)element;
            styledString.append(container.getFeatureId());
            String version = container.getFeatureVersion();
            if (version != null) {
                styledString.append(' ');
                styledString.append('[', StyledString.QUALIFIER_STYLER);
                styledString.append(version, StyledString.QUALIFIER_STYLER);
                styledString.append(']', StyledString.QUALIFIER_STYLER);
            }
            if (this.fAppendResolvedVariables) {
                this.appendLocation(styledString, (ITargetLocation)container, true);
            }
            this.appendLocation(styledString, (ITargetLocation)container, false);
            this.appendBundleCount(styledString, (ITargetLocation)container);
        } else if (element instanceof DirectoryBundleContainer) {
            DirectoryBundleContainer container = (DirectoryBundleContainer)element;
            try {
                styledString.append(container.getLocation(false));
            }
            catch (CoreException coreException) {}
            if (this.fAppendResolvedVariables) {
                this.appendLocation(styledString, (ITargetLocation)container, true);
            }
            this.appendBundleCount(styledString, (ITargetLocation)container);
        } else if (element instanceof ProfileBundleContainer) {
            ProfileBundleContainer container = (ProfileBundleContainer)element;
            try {
                styledString.append(container.getLocation(false));
            }
            catch (CoreException coreException) {}
            if (this.fAppendResolvedVariables) {
                this.appendLocation(styledString, (ITargetLocation)container, true);
            }
            this.appendBundleCount(styledString, (ITargetLocation)container);
        } else if (element instanceof IUBundleContainer) {
            IUBundleContainer container = (IUBundleContainer)element;
            URI[] repos = container.getRepositories();
            if (repos == null || repos.length == 0) {
                styledString.append(Messages.BundleContainerTable_8);
            } else {
                styledString.append(repos[0].toString());
            }
            this.appendBundleCount(styledString, (ITargetLocation)container);
        } else if (element instanceof IUContentProvider.IUWrapper) {
            styledString = this.getStyledString(((IUContentProvider.IUWrapper)element).getIU());
        } else if (element instanceof IInstallableUnit) {
            IInstallableUnit iu = (IInstallableUnit)element;
            String name = this.fTranslations.getIUProperty(iu, "org.eclipse.equinox.p2.name");
            if (name == null) {
                name = iu.getId();
            }
            styledString.append(name);
            styledString.append(' ');
            styledString.append(iu.getVersion().toString(), StyledString.QUALIFIER_STYLER);
        } else if (element instanceof String) {
            styledString.append((String)element);
        } else {
            styledString.append(element.toString());
        }
        return styledString;
    }

    private void appendBundleInfo(StyledString styledString, BundleInfo info) {
        String version;
        URI location;
        String name = info.getSymbolicName();
        if (name == null && (location = info.getLocation()) != null) {
            name = location.toString();
        }
        if (name != null) {
            styledString.append(name);
        }
        if (this.fShowVersion && (version = info.getVersion()) != null && !version.equals("0.0.0")) {
            styledString.append(' ');
            styledString.append('(', StyledString.QUALIFIER_STYLER);
            styledString.append(version, StyledString.QUALIFIER_STYLER);
            styledString.append(')', StyledString.QUALIFIER_STYLER);
        }
    }

    private void appendLocation(StyledString styledString, ITargetLocation container, boolean resolved) {
        try {
            String location = container.getLocation(resolved);
            styledString.append(" - ", StyledString.DECORATIONS_STYLER);
            styledString.append(location, StyledString.DECORATIONS_STYLER);
        }
        catch (CoreException coreException) {}
    }

    private void appendBundleCount(StyledString styledString, ITargetLocation container) {
        if (!container.isResolved() || !container.getStatus().isOK() && !container.getStatus().isMultiStatus() || container.getBundles() == null) {
            return;
        }
        int bundleCount = container.getBundles().length;
        String bundleCountString = Integer.toString(bundleCount);
        styledString.append(' ');
        styledString.append(MessageFormat.format((String)Messages.BundleContainerTable_10, (Object[])new Object[]{bundleCountString}), StyledString.COUNTER_STYLER);
    }

    public Image getImage(Object element) {
        block27: {
            block29: {
                int flag;
                block32: {
                    ITargetLocation container;
                    block30: {
                        IStatus status;
                        block31: {
                            block28: {
                                block26: {
                                    if (element instanceof TargetBundle) {
                                        TargetBundle bundle = (TargetBundle)element;
                                        int flag2 = 0;
                                        if (bundle.getStatus().getSeverity() == 2 || bundle.getStatus().getSeverity() == 1) {
                                            flag2 = 2;
                                        } else if (bundle.getStatus().getSeverity() == 4) {
                                            flag2 = 1;
                                        }
                                        if (bundle.getStatus().getSeverity() == 4 && bundle.getStatus().getCode() == 110) {
                                            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_FEATURE_OBJ, flag2);
                                        }
                                        if (bundle.isFragment()) {
                                            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_FRAGMENT_OBJ, flag2);
                                        }
                                        if (bundle.isSourceBundle()) {
                                            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PLUGIN_MF_OBJ, flag2);
                                        }
                                        return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PLUGIN_OBJ, flag2);
                                    }
                                    if (element instanceof BundleInfo) {
                                        return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PLUGIN_OBJ);
                                    }
                                    if (!(element instanceof NameVersionDescriptor)) break block26;
                                    if (((NameVersionDescriptor)element).getType() == "feature") {
                                        return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_FEATURE_OBJ);
                                    }
                                    if (((NameVersionDescriptor)element).getType() == "plugin") {
                                        return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PLUGIN_OBJ);
                                    }
                                    break block27;
                                }
                                if (!(element instanceof IStatus)) break block28;
                                int severity = ((IStatus)element).getSeverity();
                                if (severity == 2 || severity == 1) {
                                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                                }
                                if (severity == 4) {
                                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                                }
                                break block27;
                            }
                            if (element instanceof IPath) {
                                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                            }
                            if (element instanceof TargetFeature) {
                                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_FEATURE_OBJ);
                            }
                            if (!(element instanceof ITargetLocation)) break block29;
                            flag = 0;
                            container = (ITargetLocation)element;
                            if (!container.isResolved()) break block30;
                            status = container.getStatus();
                            if (status.getSeverity() != 2 && status.getSeverity() != 1) break block31;
                            flag = 2;
                            break block32;
                        }
                        if (status.getSeverity() != 4) break block32;
                        flag = 1;
                        break block32;
                    }
                    HashMap targetFlagMap = TargetPlatformHelper.getTargetDefinitionMap();
                    for (List targetDefinitionValues : targetFlagMap.values()) {
                        ITargetLocation[] locs;
                        if (targetDefinitionValues.size() <= 0 || (locs = ((TargetDefinition)targetDefinitionValues.get(0)).getTargetLocations()) == null) continue;
                        int i = 0;
                        while (i < locs.length) {
                            IStatus status;
                            if (container.equals(locs[i]) && (status = locs[i].getStatus()) != null) {
                                if (status.getSeverity() == 2 || status.getSeverity() == 1) {
                                    flag = 2;
                                } else if (status.getSeverity() == 4) {
                                    flag = 1;
                                }
                            }
                            ++i;
                        }
                    }
                }
                if (element instanceof FeatureBundleContainer) {
                    return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_FEATURE_OBJ, flag);
                }
                if (element instanceof DirectoryBundleContainer) {
                    ImageDescriptor image = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
                    return PDEPlugin.getDefault().getLabelProvider().get(image, flag);
                }
                if (element instanceof ProfileBundleContainer) {
                    return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PRODUCT_DEFINITION, flag);
                }
                if (element instanceof IUBundleContainer) {
                    return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_REPOSITORY_OBJ, flag);
                }
                break block27;
            }
            if (element instanceof IUContentProvider.IUWrapper) {
                return this.getImage(((IUContentProvider.IUWrapper)element).getIU());
            }
            if (element instanceof IInstallableUnit) {
                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_NOREF_FEATURE_OBJ);
            }
        }
        return null;
    }

    public String getText(Object element) {
        StyledString string = this.getStyledString(element);
        return string.getString();
    }
}

