/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.diagramsCreator.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.papyrus.infra.gmfdiag.css.CSSShapeImpl;
import org.eclipse.uml2.uml.Property;
import org.polarsys.chess.service.gui.utils.SelectionUtil;

public class ArrangeHandler
extends AbstractHandler {
    public static final String LOOP_TIMES = "loop_times";
    public static final String PROCESS_DIAGRAM = "process_diagram";

    private void resizeElement(final IGraphicalEditPart element) {
        int maxX = 0;
        int maxY = 0;
        IGraphicalEditPart compartmentEP = (IGraphicalEditPart)element.getChildren().get(1);
        List compartmentChildren = compartmentEP.getChildren();
        for (Object childEP : compartmentChildren) {
            EObject semanticElement = ((IGraphicalEditPart)childEP).resolveSemanticElement();
            if (!(semanticElement instanceof Property)) continue;
            CSSShapeImpl viewShape = (CSSShapeImpl)((IGraphicalEditPart)childEP).getNotationView();
            Bounds layout = (Bounds)viewShape.getLayoutConstraint();
            int x = layout.getX() + layout.getWidth();
            int y = layout.getY() + layout.getHeight();
            if (x > maxX) {
                maxX = x;
            }
            if (y <= maxY) continue;
            maxY = y;
        }
        final int width = maxX + 100;
        final int heigth = maxY + 100;
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)element.getNotationView());
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                CSSShapeImpl viewShape = (CSSShapeImpl)element.getNotationView();
                Bounds layout = (Bounds)viewShape.getLayoutConstraint();
                if (layout.getWidth() < width) {
                    layout.setWidth(width);
                }
                if (layout.getHeight() < heigth) {
                    layout.setHeight(heigth);
                }
            }
        });
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ArrayList<Object> selection = new ArrayList<Object>();
        GraphicalEditPart selectedEditPart = SelectionUtil.getInstance().getSelectedGraphicalObject(event);
        String processDiagram = event.getParameter(PROCESS_DIAGRAM);
        if (processDiagram != null && processDiagram.equals("false")) {
            IGraphicalEditPart elementEditPart = (IGraphicalEditPart)selectedEditPart.getChildren().get(0);
            selection.add((IGraphicalEditPart)elementEditPart.getChildren().get(1));
        } else {
            selection.add(selectedEditPart);
        }
        ArrangeRequest request = new ArrangeRequest("arrangeAllAction");
        request.setPartsToArrange(selection);
        org.eclipse.gef.commands.Command cmd = ((IGraphicalEditPart)selection.get(0)).getCommand((Request)request);
        int loopTimes = 1;
        try {
            loopTimes = Integer.parseInt(event.getParameter(LOOP_TIMES));
        }
        catch (NumberFormatException numberFormatException) {}
        if (cmd != null && cmd.canExecute()) {
            int i = 0;
            while (i < loopTimes) {
                cmd.execute();
                ++i;
            }
        }
        if (processDiagram != null && processDiagram.equals("false")) {
            this.resizeElement((IGraphicalEditPart)selectedEditPart.getChildren().get(0));
        }
        return null;
    }
}

