/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.properties.observable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.command.TableCommands;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.AxisConfigurationUtils;
import org.eclipse.papyrus.infra.ui.emf.databinding.EMFObservableList;

public abstract class AbstractPasteObjectPostActionsObservableValue
extends EMFObservableList {
    private Table table;
    private boolean isEditingColumn;
    private EObject editedObject;

    public AbstractPasteObjectPostActionsObservableValue(EditingDomain domain, Table table, boolean isEditingColumn) {
        super(Collections.EMPTY_LIST, domain, (EObject)table, (EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getIPasteConfiguration_PostActions());
        this.table = table;
        this.isEditingColumn = isEditingColumn;
        this.updateList();
    }

    protected void updateList() {
        IObservableList list = EMFProperties.list((EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getIPasteConfiguration_PostActions()).observe((Object)this.getEditedEObject());
        this.wrappedList = new LinkedList(list);
        this.concreteList = list;
    }

    protected Table getTable() {
        return this.table;
    }

    protected EObject getEditedEObject() {
        IAxisConfiguration editedConfiguration = AxisConfigurationUtils.getIAxisConfigurationUsedInTable((Table)this.getTable(), (EClass)NattableaxisconfigurationPackage.eINSTANCE.getPasteEObjectConfiguration(), (boolean)this.isEditingColumn);
        this.editedObject = editedConfiguration;
        return this.editedObject;
    }

    public Command getAddAllCommand(Collection<?> values) {
        PasteEObjectConfiguration editedEObject = (PasteEObjectConfiguration)this.getEditedEObject();
        if (editedEObject == null) {
            editedEObject = NattableaxisconfigurationFactory.eINSTANCE.createPasteEObjectConfiguration();
        }
        ArrayList newValues = new ArrayList(this.wrappedList);
        newValues.addAll(values);
        ICommand cmd = TableCommands.getSetIAxisConfigurationValueCommand((Table)this.getTable(), (IAxisConfiguration)editedEObject, (EStructuralFeature)this.feature, newValues, (boolean)this.isEditingColumn);
        return new GMFtoEMFCommandWrapper(cmd);
    }

    public Command getAddAllCommand(int index, Collection<?> values) {
        PasteEObjectConfiguration editedEObject = (PasteEObjectConfiguration)this.getEditedEObject();
        if (editedEObject == null) {
            editedEObject = NattableaxisconfigurationFactory.eINSTANCE.createPasteEObjectConfiguration();
        }
        ArrayList newValues = new ArrayList(this.wrappedList);
        newValues.addAll(index, values);
        ICommand cmd = TableCommands.getSetIAxisConfigurationValueCommand((Table)this.getTable(), (IAxisConfiguration)editedEObject, (EStructuralFeature)this.feature, newValues, (boolean)this.isEditingColumn);
        return new GMFtoEMFCommandWrapper(cmd);
    }

    public Command getAddCommand(int index, Object value) {
        PasteEObjectConfiguration editedEObject = (PasteEObjectConfiguration)this.getEditedEObject();
        if (editedEObject == null) {
            editedEObject = NattableaxisconfigurationFactory.eINSTANCE.createPasteEObjectConfiguration();
        }
        ArrayList<String> newValues = new ArrayList<String>(this.wrappedList);
        newValues.add((String)value);
        ICommand cmd = TableCommands.getSetIAxisConfigurationValueCommand((Table)this.getTable(), (IAxisConfiguration)editedEObject, (EStructuralFeature)this.feature, newValues, (boolean)this.isEditingColumn);
        return new GMFtoEMFCommandWrapper(cmd);
    }

    public List<Command> getMoveCommands(int oldIndex, int newIndex) {
        LinkedList<Command> commands = new LinkedList<Command>();
        PasteEObjectConfiguration editedEObject = (PasteEObjectConfiguration)this.getEditedEObject();
        if (editedEObject == null) {
            editedEObject = NattableaxisconfigurationFactory.eINSTANCE.createPasteEObjectConfiguration();
        }
        ArrayList<String> newValues = new ArrayList<String>(this.wrappedList);
        Object value = this.get(oldIndex);
        newValues.remove(value);
        newValues.add(newIndex, (String)value);
        ICommand cmd = TableCommands.getSetIAxisConfigurationValueCommand((Table)this.getTable(), (IAxisConfiguration)editedEObject, (EStructuralFeature)this.feature, newValues, (boolean)this.isEditingColumn);
        commands.add((Command)new GMFtoEMFCommandWrapper(cmd));
        return commands;
    }

    public Command getRetainAllCommand(Collection<?> values) {
        return super.getRetainAllCommand(values);
    }

    public Command getAddCommand(Object value) {
        PasteEObjectConfiguration editedEObject = (PasteEObjectConfiguration)this.getEditedEObject();
        if (editedEObject == null) {
            editedEObject = NattableaxisconfigurationFactory.eINSTANCE.createPasteEObjectConfiguration();
        }
        ArrayList<String> newValues = new ArrayList<String>(this.wrappedList);
        newValues.add((String)value);
        ICommand cmd = TableCommands.getSetIAxisConfigurationValueCommand((Table)this.getTable(), (IAxisConfiguration)editedEObject, (EStructuralFeature)this.feature, newValues, (boolean)this.isEditingColumn);
        return new GMFtoEMFCommandWrapper(cmd);
    }

    public Command getRemoveAllCommand(Collection<?> values) {
        PasteEObjectConfiguration editedEObject;
        CompoundCommand cc = new CompoundCommand("Edit list");
        if (this.feature instanceof EReference && ((EReference)this.feature).isContainment() && values != null) {
            for (Object o : values) {
                if (!(o instanceof EObject)) continue;
                this.addDestroyCommand((Command)cc, (EObject)o);
            }
        }
        if ((editedEObject = (PasteEObjectConfiguration)this.getEditedEObject()) == null) {
            editedEObject = NattableaxisconfigurationFactory.eINSTANCE.createPasteEObjectConfiguration();
        }
        ArrayList newValues = new ArrayList(this.wrappedList);
        newValues.removeAll(values);
        ICommand cmd = TableCommands.getSetIAxisConfigurationValueCommand((Table)this.getTable(), (IAxisConfiguration)editedEObject, (EStructuralFeature)this.feature, newValues, (boolean)this.isEditingColumn);
        return new GMFtoEMFCommandWrapper(cmd);
    }

    public Command getSetCommand(int index, Object value) {
        PasteEObjectConfiguration editedEObject = (PasteEObjectConfiguration)this.getEditedEObject();
        if (editedEObject == null) {
            editedEObject = NattableaxisconfigurationFactory.eINSTANCE.createPasteEObjectConfiguration();
        }
        ArrayList<String> newValues = new ArrayList<String>(this.wrappedList);
        newValues.add(index, (String)value);
        ICommand cmd = TableCommands.getSetIAxisConfigurationValueCommand((Table)this.getTable(), (IAxisConfiguration)editedEObject, (EStructuralFeature)this.feature, newValues, (boolean)this.isEditingColumn);
        return new GMFtoEMFCommandWrapper(cmd);
    }

    public Command getRemoveCommand(Object value) {
        PasteEObjectConfiguration editedEObject = (PasteEObjectConfiguration)this.getEditedEObject();
        if (editedEObject != null && !this.editingDomain.isReadOnly(editedEObject.eResource())) {
            Command cmd = RemoveCommand.create((EditingDomain)this.editingDomain, (Object)editedEObject, (Object)this.feature, (Object)value);
            if (value instanceof EObject && this.feature instanceof EReference && ((EReference)this.feature).isContainment()) {
                this.addDestroyCommand(cmd, (EObject)value);
            }
            return cmd;
        }
        return IdentityCommand.INSTANCE;
    }
}

