/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.internal.ui.actions.EditingDomainAction;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;

public class ChangePassiveUpdateAction
extends EditingDomainAction {
    public static final String ID = "change-passiveupdate";
    private static final String TITLE = Messages.getString("ChangePassiveUpdateAction.1");
    private CDOSession session;
    private IListener passiveUpdateListener = new IListener(){

        public void notifyEvent(IEvent event) {
            if (ChangePassiveUpdateAction.this.session != null && event instanceof CDOCommonSession.Options.PassiveUpdateEvent) {
                ChangePassiveUpdateAction.this.setChecked(ChangePassiveUpdateAction.this.session.options().isPassiveUpdateEnabled());
            }
        }
    };

    public ChangePassiveUpdateAction() {
        super(TITLE);
        this.setId(ID);
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        if (this.session != null) {
            this.session.options().setPassiveUpdateEnabled(!this.session.options().isPassiveUpdateEnabled());
        }
        this.update();
    }

    public void update() {
        super.update();
        this.setChecked(this.session != null ? this.session.options().isPassiveUpdateEnabled() : false);
    }

    public void setSession(CDOSession session) {
        if (this.session != null) {
            session.options().removeListener(this.passiveUpdateListener);
        }
        this.session = session;
        if (this.session != null) {
            session.options().addListener(this.passiveUpdateListener);
        }
    }
}

