/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.m2m.ui;

import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.uml2.uml.Operation;
import org.osgi.framework.Bundle;
import org.polarsys.chess.core.Activator;
import org.polarsys.chess.core.util.AnalysisResultData;
import org.polarsys.chess.core.util.HWAnalysisResultData;
import org.polarsys.chess.core.util.uml.UMLUtils;

public class SchedResultDialog
extends Dialog {
    private Shell shell;
    private String result;
    private List<HWAnalysisResultData> hwResults;
    private List<AnalysisResultData> analysisResData;

    public SchedResultDialog(Shell parentShell, String result, List<AnalysisResultData> analysisResData, List<HWAnalysisResultData> hwResults) {
        super(parentShell);
        this.shell = parentShell;
        this.result = result;
        this.hwResults = hwResults;
        this.analysisResData = analysisResData;
        Image image = null;
        URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("/resources/CHESSicon.gif"), null);
        try {
            url = FileLocator.toFileURL((URL)url);
            image = Activator.getImageDescriptor((String)url.toString()).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Dialog.setDefaultImage(image);
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        layout.marginBottom = 5;
        layout.marginTop = 5;
        parent.setLayout((Layout)layout);
        Display display = this.shell.getDisplay();
        Color green = display.getSystemColor(5);
        Color red = display.getSystemColor(3);
        Label resultLabel = new Label(parent, 0);
        resultLabel.setFont(new Font((Device)display, "Tahoma", 14, 1));
        if (this.result != null) {
            resultLabel.setText(this.result);
        }
        Table cpuTable = new Table(parent, 2064);
        cpuTable.setLinesVisible(true);
        cpuTable.setHeaderVisible(true);
        GridData data = new GridData(4, 1, true, false, 1, 1);
        cpuTable.setLayoutData((Object)data);
        String[] cpuTitles = new String[]{"HW Instance", "Utilization", "Result"};
        int i = 0;
        while (i < cpuTitles.length) {
            TableColumn column = new TableColumn(cpuTable, 0);
            column.setText(cpuTitles[i]);
            ++i;
        }
        for (HWAnalysisResultData hwRes : this.hwResults) {
            String utilValue;
            String utilization = hwRes.hw_utilization;
            if (utilization == null || (utilValue = UMLUtils.getValue((String)utilization, (String)"value")) == null || utilValue.length() <= 0) continue;
            TableItem item = new TableItem(cpuTable, 0);
            item.setText(0, hwRes.hw_instance);
            if (utilValue == null || utilValue.isEmpty()) continue;
            item.setText(1, String.valueOf(utilValue) + "%");
            if (Float.parseFloat(utilValue) <= 100.0f) {
                item.setText(2, "OK");
                item.setForeground(2, green);
                continue;
            }
            item.setText(2, "NOT OK: utilization over 100%");
            item.setForeground(2, red);
        }
        i = 0;
        while (i < cpuTitles.length) {
            cpuTable.getColumn(i).pack();
            ++i;
        }
        Table slotTable = new Table(parent, 2064);
        slotTable.setLinesVisible(true);
        slotTable.setHeaderVisible(true);
        data = new GridData(4, 1, true, false, 1, 1);
        slotTable.setLayoutData((Object)data);
        String[] slotTitles = new String[]{"SW Instance", "Operation", "Response Time", "Deadline", "Result"};
        int i2 = 0;
        while (i2 < slotTitles.length) {
            TableColumn column = new TableColumn(slotTable, 0);
            column.setText(slotTitles[i2]);
            ++i2;
        }
        for (AnalysisResultData resDataElem : this.analysisResData) {
            int i3 = 0;
            String theSwInstance = resDataElem.instance;
            TableItem item = new TableItem(slotTable, 0);
            item.setText(i3, theSwInstance);
            Operation theOperation = resDataElem.ctxOP;
            String theOperationName = theOperation.getName();
            item.setText(++i3, theOperationName);
            String theRespTime = resDataElem.respT;
            item.setText(++i3, theRespTime);
            String theDeadline = resDataElem.rldl;
            item.setText(++i3, theDeadline);
            ++i3;
            String theResult = this.convertToOkNok(resDataElem.isSched);
            if (theResult.equalsIgnoreCase("OK")) {
                item.setForeground(i3, green);
            } else {
                item.setForeground(i3, red);
            }
            item.setText(i3, theResult);
            ++i3;
        }
        i = 0;
        while (i < slotTitles.length) {
            slotTable.getColumn(i).pack();
            ++i;
        }
        return super.createDialogArea(parent);
    }

    private String convertToOkNok(String isSched) {
        String result = "NOT OK";
        if (isSched.equalsIgnoreCase("YES")) {
            result = "OK";
        }
        return result;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Schedulability Analysis Report");
        shell.setSize(650, 350);
        Monitor primary = shell.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shell.setLocation(x, y);
    }

    protected boolean isResizable() {
        return true;
    }
}

