/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.nebula.richtext;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.CellDisplayConversionUtils;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.AbstractCellPainter;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.richtext.RichTextPainter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class RichTextCellPainter
extends AbstractCellPainter {
    protected RichTextPainter richTextPainter;

    public RichTextCellPainter() {
        this(true);
    }

    public RichTextCellPainter(boolean wordWrap) {
        this.richTextPainter = new RichTextPainter(wordWrap);
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        IStyle cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
        this.setupGCFromConfig(gc, cellStyle);
        String htmlText = CellDisplayConversionUtils.convertDataType((ILayerCell)cell, (IConfigRegistry)configRegistry);
        Rectangle painterBounds = new Rectangle(bounds.x, bounds.y - this.richTextPainter.getParagraphSpace(), bounds.width, bounds.height);
        this.richTextPainter.paintHTML(htmlText, gc, painterBounds);
    }

    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry));
        String htmlText = CellDisplayConversionUtils.convertDataType((ILayerCell)cell, (IConfigRegistry)configRegistry);
        this.richTextPainter.preCalculate(htmlText, gc, new Rectangle(0, 0, 0, cell.getBounds().height), false);
        return this.richTextPainter.getPreferredSize().x;
    }

    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry));
        String htmlText = CellDisplayConversionUtils.convertDataType((ILayerCell)cell, (IConfigRegistry)configRegistry);
        this.richTextPainter.preCalculate(htmlText, gc, new Rectangle(0, 0, cell.getBounds().width, 0), true);
        return this.richTextPainter.getPreferredSize().y - 2 * this.richTextPainter.getParagraphSpace();
    }

    public void setupGCFromConfig(GC gc, IStyle cellStyle) {
        Color fg = (Color)cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR);
        Color bg = (Color)cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
        Font font = (Font)cellStyle.getAttributeValue(CellStyleAttributes.FONT);
        gc.setAntialias(-1);
        gc.setTextAntialias(-1);
        gc.setFont(font);
        gc.setForeground(fg != null ? fg : GUIHelper.COLOR_LIST_FOREGROUND);
        gc.setBackground(bg != null ? bg : GUIHelper.COLOR_LIST_BACKGROUND);
    }
}

