/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.contractEditor.core;

import eu.fbk.eclipse.standardtools.contractEditor.core.IContractEditorService;
import eu.fbk.eclipse.standardtools.xtextService.ui.utils.XTextEditorViewer_formalProperty;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.osgi.framework.Bundle;

public class ContractEditorServiceImpl
implements IContractEditorService {
    static String PLUGIN_ID = "eu.fbk.eclipse.standardtools.contractEditor.core";
    private static ContractEditorServiceImpl fInstance = null;
    private XTextEditorViewer_formalProperty xTextEditorViewer_assume;
    private XTextEditorViewer_formalProperty xTextEditorViewer_guarantee;
    private Label contractLabel;
    private Text newContractLabel;
    private CCombo contractList;
    private Label contractListLabel;
    private Button addGuarantee;
    private Button addContract;
    private Button addAssumption;
    private Button browseGuarantee;
    private Button browseAssumption;
    private Text contractText;
    private Label assumeQualifiedNameLabel;
    private Label guaranteeQualifiedNameLabel;
    private IWorkbenchPage page;
    int numCols;
    int entireSpace;
    int halfSpace;
    int largeSpace;
    int smallSpace;

    public ContractEditorServiceImpl() {
        this.entireSpace = this.numCols = 4;
        this.halfSpace = this.numCols / 2;
        this.largeSpace = 3;
        this.smallSpace = this.numCols - this.largeSpace;
    }

    public static ContractEditorServiceImpl getInstance() {
        if (fInstance == null) {
            fInstance = new ContractEditorServiceImpl();
        }
        return fInstance;
    }

    @Override
    public void showAssumeRuntimeErrors(Object contract, Resource resource) throws IOException {
        this.xTextEditorViewer_assume.showRuntimeErrors(this.getAssumeEditorText(), contract, resource);
    }

    @Override
    public void showGuaranteeRuntimeErrors(Object contract, Resource resource) throws IOException {
        this.xTextEditorViewer_guarantee.showRuntimeErrors(this.getGuaranteeEditorText(), contract, resource);
    }

    private void enableBrowseButtons() {
        this.browseAssumption.setEnabled(true);
        this.browseGuarantee.setEnabled(true);
    }

    @Override
    public String getSelectedContractNameLabel() {
        int selIndex = this.contractList.getSelectionIndex();
        if (selIndex != -1) {
            return this.contractList.getItem(this.contractList.getSelectionIndex());
        }
        return null;
    }

    private void excludeControl(Control control, boolean exclude) {
        GridData gd = (GridData)control.getLayoutData();
        gd.exclude = exclude;
        control.setVisible(!exclude);
        control.requestLayout();
    }

    @Override
    public void setContractList(String[] contractListArr) {
        int prevSelContractIndex = this.contractList.getSelectionIndex();
        String prevSelContract = null;
        if (prevSelContractIndex != -1) {
            prevSelContract = this.contractList.getItem(prevSelContractIndex);
        }
        this.contractList.setItems(contractListArr);
        this.excludeControl((Control)this.contractList, false);
        this.excludeControl((Control)this.contractListLabel, false);
        this.excludeControl((Control)this.addContract, false);
        this.excludeControl((Control)this.newContractLabel, false);
        this.contractList.update();
        if (prevSelContract != null) {
            this.contractList.select(this.contractList.indexOf(prevSelContract));
        }
    }

    @Override
    public void disableFormalPropertiesButtons() {
        this.browseAssumption.setEnabled(false);
        this.browseGuarantee.setEnabled(false);
    }

    @Override
    public void disableAddAssumptionButton() {
        this.addAssumption.setEnabled(false);
    }

    @Override
    public void disableAddGuaranteeButton() {
        this.addGuarantee.setEnabled(false);
    }

    @Override
    public void setSelectedContractNameLabel(String contractLabelText, String contractName) {
        if (contractName != null) {
            this.contractLabel.setText(contractLabelText);
            this.contractText.setText(contractName);
            this.enableBrowseButtons();
        }
    }

    @Override
    public void prepareEmptyContractEditorView() {
        if (!this.contractLabel.isDisposed() && !this.contractText.isDisposed()) {
            this.contractLabel.setText("Selected Contract");
            this.contractText.setText("no Contract selected");
        }
        if (!(this.addAssumption.isDisposed() || this.addGuarantee.isDisposed() || this.browseAssumption.isDisposed() || this.browseGuarantee.isDisposed())) {
            this.addAssumption.setEnabled(false);
            this.addGuarantee.setEnabled(false);
            this.browseAssumption.setEnabled(false);
            this.browseGuarantee.setEnabled(false);
        }
        if (!this.contractList.isDisposed() && !this.contractListLabel.isDisposed()) {
            this.contractList.removeAll();
            this.excludeControl((Control)this.contractList, true);
            this.excludeControl((Control)this.contractListLabel, true);
            this.excludeControl((Control)this.addContract, true);
            this.excludeControl((Control)this.newContractLabel, true);
        }
        this.xTextEditorViewer_assume.cleanEditor();
        this.xTextEditorViewer_guarantee.cleanEditor();
    }

    @Override
    public void createGUI(Composite parent, IWorkbenchPage page) {
        GridData gd;
        this.page = page;
        Object layoutData = parent.getLayoutData();
        if (layoutData != null && layoutData instanceof GridData) {
            gd = (GridData)layoutData;
            gd.grabExcessVerticalSpace = true;
            gd.verticalAlignment = 4;
        }
        Composite mainComposite = new Composite(parent, 4);
        GridLayout gridLayout = new GridLayout(this.numCols, true);
        mainComposite.setLayout((Layout)gridLayout);
        mainComposite.setBackgroundMode(2);
        mainComposite.setBackground(Display.getCurrent().getSystemColor(1));
        this.contractText = new Text(mainComposite, 4);
        this.contractText.setText("no Contract selected");
        this.contractText.setEditable(false);
        this.contractText.setLayoutData((Object)this.createGridData(this.largeSpace));
        this.contractLabel = new Label(mainComposite, 0);
        this.contractLabel.setText("Selected Contract");
        this.contractLabel.setLayoutData((Object)this.createGridData(this.smallSpace));
        this.contractLabel.setBackground(Display.getCurrent().getSystemColor(1));
        this.contractList = new CCombo(mainComposite, 2056);
        this.contractList.setVisible(false);
        this.contractList.setLayoutData((Object)this.createGridData(this.largeSpace));
        this.contractListLabel = new Label(mainComposite, 0);
        this.contractListLabel.setText("Contract List");
        this.contractListLabel.setVisible(false);
        this.contractListLabel.setLayoutData((Object)this.createGridData(this.smallSpace));
        this.newContractLabel = new Text(mainComposite, 2048);
        this.newContractLabel.setLayoutData((Object)this.createGridData(this.halfSpace));
        this.newContractLabel.setText("new contract's name");
        this.newContractLabel.setVisible(false);
        this.addContract = new Button(mainComposite, 0);
        this.addContract.setLayoutData((Object)this.createGridData(this.smallSpace));
        this.addContract.setText("Add Contract");
        this.addContract.setVisible(false);
        Composite assume_Composite = new Composite(mainComposite, 0);
        assume_Composite.setLayout((Layout)new GridLayout(4, false));
        assume_Composite.setLayoutData((Object)this.createGridData(this.halfSpace));
        Label assumeLabel = new Label(assume_Composite, 0);
        assumeLabel.setText("Assume");
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        URL urlCreatePropertyImage = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/editor.gif"), null);
        Image createPropertyImage = ImageDescriptor.createFromURL((URL)urlCreatePropertyImage).createImage();
        this.addAssumption = new Button(assume_Composite, 0);
        this.addAssumption.setImage(createPropertyImage);
        URL urlBrowsePropertyImage = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/elipses.gif"), null);
        Image browsePropertyImage = ImageDescriptor.createFromURL((URL)urlBrowsePropertyImage).createImage();
        this.browseAssumption = new Button(assume_Composite, 0);
        this.browseAssumption.setImage(browsePropertyImage);
        this.assumeQualifiedNameLabel = new Label(assume_Composite, 0);
        this.assumeQualifiedNameLabel.setText("");
        this.assumeQualifiedNameLabel.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        gd = new GridData(4, 4, true, true);
        Composite guarantee_Composite = new Composite(mainComposite, 4);
        guarantee_Composite.setLayout((Layout)new GridLayout(4, false));
        guarantee_Composite.setLayoutData((Object)this.createGridData(this.halfSpace));
        Label guaranteeLabel = new Label(guarantee_Composite, 0);
        guaranteeLabel.setText("Guarantee");
        this.addGuarantee = new Button(guarantee_Composite, 0);
        this.addGuarantee.setImage(createPropertyImage);
        this.browseGuarantee = new Button(guarantee_Composite, 0);
        this.browseGuarantee.setImage(browsePropertyImage);
        this.guaranteeQualifiedNameLabel = new Label(guarantee_Composite, 0);
        this.guaranteeQualifiedNameLabel.setText("");
        this.guaranteeQualifiedNameLabel.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        this.initEditors(mainComposite);
    }

    @Override
    public String getNewContractName() {
        return this.newContractLabel.getText();
    }

    private GridData createGridData(int numUsedCols) {
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = numUsedCols;
        return gd;
    }

    @Override
    public void assignListeners(SelectionListener contractListListener, Listener addAssumptionListener, Listener browseAssumptionListener, Listener addGuaranteeListener, Listener browseGuaranteeListener, ISelectionListener listener, ISelectionChangedListener assumeEditorListener, ISelectionChangedListener guaranteeEditorListener, Listener addContractListener) {
        this.contractList.addSelectionListener(contractListListener);
        this.addAssumption.addListener(13, addAssumptionListener);
        this.browseAssumption.addListener(13, browseAssumptionListener);
        this.addGuarantee.addListener(13, addGuaranteeListener);
        this.browseGuarantee.addListener(13, browseGuaranteeListener);
        this.addContract.addListener(13, addContractListener);
        this.xTextEditorViewer_assume.assignPostTextChangedListener(assumeEditorListener);
        this.xTextEditorViewer_guarantee.assignPostTextChangedListener(guaranteeEditorListener);
        if (listener != null) {
            this.page.addSelectionListener(listener);
        }
    }

    private void initEditors(Composite topComposite) {
        this.xTextEditorViewer_assume = new XTextEditorViewer_formalProperty(topComposite, 2);
        this.xTextEditorViewer_guarantee = new XTextEditorViewer_formalProperty(topComposite, 2);
    }

    @Override
    public void setAssumeEditorText(String text) {
        if (text != null) {
            this.xTextEditorViewer_assume.setEditorText(text);
            this.addAssumption.setEnabled(false);
        } else {
            this.xTextEditorViewer_assume.setEditorText("");
            this.addAssumption.setEnabled(true);
        }
    }

    @Override
    public void setAssumeQualifiedNameLabel(String qualifiedName) {
        if (qualifiedName != null) {
            this.assumeQualifiedNameLabel.setText(String.valueOf(qualifiedName) + " ");
            this.assumeQualifiedNameLabel.setToolTipText(String.valueOf(qualifiedName) + " ");
        } else {
            this.assumeQualifiedNameLabel.setText("");
            this.assumeQualifiedNameLabel.setToolTipText("");
        }
        this.assumeQualifiedNameLabel.getParent().layout();
    }

    @Override
    public void setGuaranteeEditorText(String text) {
        if (text != null) {
            this.xTextEditorViewer_guarantee.setEditorText(text);
            this.addGuarantee.setEnabled(false);
        } else {
            this.xTextEditorViewer_guarantee.setEditorText("");
            this.addGuarantee.setEnabled(true);
        }
    }

    @Override
    public void setGuaranteeQualifiedNameLabel(String qualifiedName) {
        if (qualifiedName != null) {
            this.guaranteeQualifiedNameLabel.setText(String.valueOf(qualifiedName) + " ");
            this.guaranteeQualifiedNameLabel.setToolTipText(String.valueOf(qualifiedName) + " ");
        } else {
            this.guaranteeQualifiedNameLabel.setText("");
            this.guaranteeQualifiedNameLabel.setToolTipText("");
        }
        this.guaranteeQualifiedNameLabel.getParent().layout();
    }

    @Override
    public String getAssumeEditorText() {
        return this.xTextEditorViewer_assume.getEditorText();
    }

    @Override
    public String getGuaranteeEditorText() {
        return this.xTextEditorViewer_guarantee.getEditorText();
    }

    @Override
    public boolean isAssumeEditorEditable() {
        return this.xTextEditorViewer_assume.isEditorEditable();
    }

    @Override
    public boolean isGuaranteeEditorEditable() {
        return this.xTextEditorViewer_guarantee.isEditorEditable();
    }
}

