/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.core.resource;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.dawn.gmf.util.DawnDiagramUpdater;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.internal.explorer.checkouts.CDOCheckoutViewProvider;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.cdo.view.CDOViewSet;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.papyrus.cdo.core.resource.CDOAwareProxyModificationTrackingAdapter;
import org.eclipse.papyrus.cdo.core.resource.CDOAwareTransactionalEditingDomain;
import org.eclipse.papyrus.cdo.core.resource.PapyrusCDOResourceFactory;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.core.controlmode.CDOControlModeParticipant;
import org.eclipse.papyrus.cdo.internal.core.controlmode.CDOProxyManager;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.services.resourceloading.OnDemandLoadingModelSet;

public class CDOAwareModelSet
extends OnDemandLoadingModelSet {
    private static final Set<CDOState> DIRTY_STATES = EnumSet.of(CDOState.NEW, CDOState.DIRTY, CDOState.CONFLICT, CDOState.INVALID_CONFLICT);
    private final ThreadLocal<Boolean> inGetResource = new ThreadLocal();
    private final CDOProxyManager proxyManager = new CDOProxyManager((ResourceSet)this);
    private final PapyrusCDOResourceFactory resourceFactory = new PapyrusCDOResourceFactory(this);
    private CDOCheckout checkout;
    private CDOView view;
    private IListener invalidationListener;

    public CDOAwareModelSet() {
        this.resources = new SafeResourceList();
        Map map = this.getResourceFactoryRegistry().getProtocolToFactoryMap();
        map.put("cdo", this.resourceFactory);
        map.put("cdo.checkout", this.resourceFactory);
    }

    protected Adapter createModificationTrackingAdapter() {
        return new CDOAwareProxyModificationTrackingAdapter();
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        return CDOUtils.isCDOURI(uri) ? this.getCDOObject(uri, loadOnDemand) : super.getEObject(uri, loadOnDemand);
    }

    protected EObject getCDOObject(URI uri, boolean loadOnDemand) {
        EObject result = null;
        result = CDOProxyManager.isCDOProxyURI(uri) ? this.proxyManager.getProxy(uri) : super.getEObject(uri, loadOnDemand);
        return result;
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        Boolean oldValue = this.inGetResource.get();
        this.inGetResource.set(Boolean.TRUE);
        try {
            Resource resource = super.getResource(uri, loadOnDemand);
            return resource;
        }
        finally {
            this.inGetResource.set(oldValue);
        }
    }

    boolean isInGetResource() {
        return this.inGetResource.get() == Boolean.TRUE;
    }

    public Resource createResource(URI uri, String contentType) {
        Resource resource = super.createResource(uri, contentType);
        this.initTransaction(resource);
        return resource;
    }

    protected void demandLoad(Resource resource) throws IOException {
        URI uri = resource.getURI();
        if (CDOUtils.isCDOURI(uri)) {
            resource.load(null);
            this.resourceLoadedHook(resource);
        } else {
            super.demandLoad(resource);
        }
        this.initTransaction(resource);
    }

    protected Resource setResourceOptions(Resource r) {
        if (r instanceof CDOResource) {
            return r;
        }
        return super.setResourceOptions(r);
    }

    protected void resourceLoadedHook(Resource resource) {
        for (Diagram next : Iterables.filter((Iterable)resource.getContents(), Diagram.class)) {
            DawnDiagramUpdater.initializeElement((Diagram)next);
        }
    }

    public CDOView getCDOView() {
        return this.view;
    }

    public void createModels(URI newURI) {
        super.createModels(newURI);
    }

    public void loadModels(URI uri) throws ModelMultiException {
        super.loadModels(uri);
        block5: for (CDOResource next : Iterables.filter((Iterable)this.getResources(), CDOResource.class)) {
            switch (next.cdoState()) {
                case NEW: 
                case DIRTY: {
                    try {
                        ((CDOTransaction)this.getCDOView()).commit((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CommitException e) {
                        Activator.log.error("Commit implicitly created resources failed.", (Throwable)e);
                    }
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
        }
    }

    protected void initTransaction(Resource resource) {
        if (resource instanceof CDOResource) {
            CDOResource cdoResource = (CDOResource)resource;
            this.view = cdoResource.cdoView();
            if (this.view != null) {
                this.view.addListener(this.getInvalidationListener());
                this.checkout = CDOExplorerUtil.getCheckout((Object)this.view);
            }
        }
    }

    public void unload() {
        boolean logError = true;
        try {
            boolean bl = logError = this.view == null || !this.view.isClosed();
            if (this.view != null && !this.view.isClosed()) {
                CDOUtils.unload(this.view);
            }
        }
        finally {
            block15: {
                try {
                    try {
                        super.unload();
                    }
                    catch (Exception ex) {
                        if (logError) {
                            Activator.log.error((Throwable)ex);
                        }
                        LifecycleUtil.deactivate((Object)this.view);
                        CDOCheckoutViewProvider.disposeResourceSet((ResourceSet)this);
                        this.eAdapters().clear();
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    LifecycleUtil.deactivate((Object)this.view);
                    CDOCheckoutViewProvider.disposeResourceSet((ResourceSet)this);
                    this.eAdapters().clear();
                    throw throwable;
                }
                LifecycleUtil.deactivate((Object)this.view);
                CDOCheckoutViewProvider.disposeResourceSet((ResourceSet)this);
                this.eAdapters().clear();
            }
        }
    }

    protected final IListener getInvalidationListener() {
        if (this.invalidationListener == null) {
            this.invalidationListener = this.createInvalidationListener();
        }
        return this.invalidationListener;
    }

    protected IListener createInvalidationListener() {
        return new IListener(){

            public void notifyEvent(IEvent event) {
                TransactionalEditingDomain domain;
                if (event instanceof CDOViewInvalidationEvent && (domain = CDOAwareModelSet.this.getTransactionalEditingDomain()) instanceof CDOAwareTransactionalEditingDomain) {
                    ((CDOAwareTransactionalEditingDomain)domain).fireResourceSetChanged((CDOViewInvalidationEvent)event);
                }
            }
        };
    }

    public boolean isUserModelResource(URI uri) {
        return super.isUserModelResource(uri) || CDOUtils.isCDOURI(uri);
    }

    public EList<Adapter> eAdapters() {
        if (this.eAdapters == null) {
            this.eAdapters = new BasicNotifierImpl.EAdapterList<Adapter>((Notifier)this){
                private static final long serialVersionUID = 1L;

                public Adapter remove(int index) {
                    Adapter toRemove = (Adapter)this.primitiveGet(index);
                    if (toRemove instanceof CDOViewSet && !CDOAwareModelSet.this.canDisconnectCDOViewSet()) {
                        return null;
                    }
                    return (Adapter)super.remove(index);
                }

                public void clear() {
                    if (!CDOAwareModelSet.this.canDisconnectCDOViewSet()) {
                        Adapter viewSetAdapter = this.getViewSetAdapter();
                        if (viewSetAdapter != null) {
                            this.retainAll(Collections.singleton(viewSetAdapter));
                        } else {
                            super.clear();
                        }
                    } else {
                        super.clear();
                    }
                }

                private Adapter getViewSetAdapter() {
                    return (Adapter)Iterables.find((Iterable)((Object)this), (Predicate)Predicates.instanceOf(CDOViewSet.class), null);
                }
            };
        }
        return this.eAdapters;
    }

    private boolean canDisconnectCDOViewSet() {
        CDOView view = this.getCDOView();
        return (view == null || view.isClosed()) && this.getResources().isEmpty();
    }

    boolean isDirty(Resource resource) {
        return resource instanceof CDOResource && DIRTY_STATES.contains(((CDOResource)resource).cdoState());
    }

    protected void cleanModelSet() {
        Set toDelete = this.getResourcesToDeleteOnSave();
        Iterator iter = this.getResources().iterator();
        while (iter.hasNext()) {
            Resource next = (Resource)iter.next();
            if (!toDelete.contains(next.getURI()) || next instanceof CDOResource && !FSMUtil.isClean((CDOObject)((CDOResource)next)) && !FSMUtil.isTransient((CDOObject)((CDOResource)next))) continue;
            iter.remove();
        }
    }

    protected void handleResourcesToDelete() {
        int initialCount = this.getResourcesToDeleteOnSave().size();
        super.handleResourcesToDelete();
        CDOView view = this.getCDOView();
        if (view instanceof CDOTransaction && this.getResourcesToDeleteOnSave().size() < initialCount) {
            try {
                ((CDOTransaction)view).commit();
            }
            catch (CommitException e) {
                Activator.log.error("Failed to commit resource deletions.", (Throwable)e);
            }
        }
    }

    protected boolean validateDeleteResource(URI uri) {
        boolean result = true;
        Resource resource = this.getResource(uri, false);
        if (resource != null && this.isDirty(resource)) {
            result = false;
            Activator.log.warn("Attempt to delete a dirty CDO resource: " + uri);
        }
        return result;
    }

    protected boolean deleteResource(URI uri) {
        Resource res = this.getResource(uri, false);
        boolean result = res instanceof CDOResource;
        if (!result) {
            result = super.deleteResource(uri);
        } else {
            try {
                res.delete(null);
                if (res.getResourceSet() != null) {
                    res.unload();
                    res.getResourceSet().getResources().remove((Object)res);
                }
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return result;
    }

    public void save(IProgressMonitor monitor) throws IOException {
        ImmutableList updates;
        CDOView view = this.getCDOView();
        CDOTransaction transaction = null;
        if (view instanceof CDOTransaction && view.isDirty()) {
            transaction = (CDOTransaction)view;
            updates = ImmutableList.builder().addAll(transaction.getNewObjects().values()).addAll(transaction.getDirtyObjects().values()).build();
        } else {
            updates = Collections.emptyList();
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(updates.isEmpty() ? 1 : 2));
        super.save((IProgressMonitor)sub.newChild(1));
        if (!updates.isEmpty()) {
            CDOControlModeParticipant control = new CDOControlModeParticipant();
            CDOControlModeParticipant.IUpdate run = CDOControlModeParticipant.IUpdate.EMPTY;
            for (CDOObject next : updates) {
                EObject object;
                if (next instanceof CDOResourceNode || (object = CDOUtil.getEObject((EObject)next)) == null) continue;
                for (EReference xref : object.eClass().getEAllReferences()) {
                    if (!xref.isChangeable() || xref.isDerived() || xref.isTransient()) continue;
                    run = run.chain(control.getProxyCrossReferencesUpdate(object, xref));
                }
            }
            if (!run.isEmpty()) {
                run.apply();
                try {
                    transaction.commit((IProgressMonitor)sub.newChild(1));
                }
                catch (CommitException e) {
                    Activator.log.error("Follow-up commit after save failed.", (Throwable)e);
                }
            } else {
                sub.done();
            }
        }
    }

    private class SafeResourceList
    extends ResourceSetImpl.ResourcesEList<Resource> {
        private static final long serialVersionUID = 1L;

        private SafeResourceList() {
            super((ResourceSetImpl)CDOAwareModelSet.this);
        }

        public boolean remove(Object object) {
            boolean result;
            boolean bl = result = !(object instanceof CDOResource) || !CDOAwareModelSet.this.isDirty((Resource)((CDOResource)object));
            if (result) {
                result = super.remove(object);
            }
            return result;
        }
    }
}

