/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableListIterator;
import java.util.Collection;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.cdo.CDOLock;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.dawn.spi.DawnState;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewSet;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.internal.cdo.object.CDOObjectWrapperBase;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.LifecycleEvent;
import org.eclipse.papyrus.cdo.core.resource.CDOAwareTransactionalEditingDomain;
import org.eclipse.papyrus.cdo.core.util.CDOFunctions;
import org.eclipse.papyrus.cdo.internal.core.Activator;

public class CDOUtils {
    private static final Set<String> CDO_URI_SCHEMES = ImmutableSet.of((Object)"cdo", (Object)"dawn", (Object)"cdo.checkout");
    private static Executor broadcastExecutor = new DirectExecutor();
    private static final Predicate<Object> IS_LEGACY_WRAPPER = Predicates.instanceOf(CDOObjectWrapperBase.class);

    private CDOUtils() {
    }

    public static <T> T adapt(Object object, Class<? extends T> type) {
        Object result = CDOUtils.tryCast(object, type);
        if (result == null) {
            EObject eObject;
            if (object instanceof IAdaptable) {
                result = type.cast(((IAdaptable)object).getAdapter(type));
            }
            if (result == null && type == CDOObject.class && (eObject = CDOUtils.adapt(object, EObject.class)) != null) {
                result = type.cast(CDOUtils.getCDOObject(eObject));
            }
            if (result == null && object instanceof Notifier) {
                result = Iterables.getFirst((Iterable)Iterables.filter((Iterable)((Notifier)object).eAdapters(), type), null);
            }
        }
        return result;
    }

    public static <T> T tryCast(Object object, Class<? extends T> type) {
        T result = null;
        if (type.isInstance(object)) {
            result = type.cast(object);
        }
        return result;
    }

    public static boolean isCDOURI(URI uri) {
        return CDO_URI_SCHEMES.contains(uri.scheme());
    }

    public static boolean isCDOEditingDomain(EditingDomain domain) {
        return domain instanceof CDOAwareTransactionalEditingDomain;
    }

    public static ResourceSet getResourceSet(Notifier notifier) {
        ResourceSet result = null;
        if (notifier instanceof CDOViewSet) {
            result = ((CDOViewSet)notifier).getResourceSet();
        } else if (notifier instanceof ResourceSet) {
            result = (ResourceSet)notifier;
        } else if (notifier instanceof Resource) {
            result = ((Resource)notifier).getResourceSet();
        } else if (notifier instanceof CDOResourceNode) {
            CDOView view = ((CDOResourceNode)notifier).cdoView();
            if (view != null) {
                result = view.getResourceSet();
            }
        } else if (notifier instanceof EObject) {
            result = CDOUtils.getResourceSet((Notifier)((EObject)notifier).eResource());
        }
        return result;
    }

    public static boolean isCDOObject(EObject object) {
        ResourceSet resourceSet = CDOUtils.getResourceSet((Notifier)object);
        return resourceSet != null && CDOUtil.getViewSet((Notifier)resourceSet) != null;
    }

    public static CDOObject getCDOObject(EObject object) {
        CDOObject result = null;
        if (CDOUtils.isCDOObject(object)) {
            result = CDOUtil.getCDOObject((EObject)object);
        }
        return result;
    }

    public static CDOID getCDOID(EObject object) {
        CDOObject cdo = CDOUtils.getCDOObject(object);
        return cdo == null ? CDOIDUtil.createExternal((String)EcoreUtil.getURI((EObject)object).toString()) : cdo.cdoID();
    }

    public static CDOView getView(ResourceSet resourceSet) {
        CDOView[] views;
        CDOView result = null;
        CDOViewSet viewSet = CDOUtil.getViewSet((Notifier)resourceSet);
        if (viewSet != null && (views = viewSet.getViews()).length > 0) {
            result = views[0];
        }
        return result;
    }

    public static CDOView getView(EObject object) {
        CDOObject cdo = CDOUtils.getCDOObject(object);
        return cdo == null ? null : cdo.cdoView();
    }

    public static boolean isLockable(CDOObject object) {
        CDOView view = object.cdoView();
        return view != null && !view.isClosed() && object.cdoLockState() != null;
    }

    public static boolean isLocked(CDOObject object, boolean remotely) {
        CDOLock lock;
        CDOLock cDOLock = lock = CDOUtils.isLockable(object) ? object.cdoWriteLock() : null;
        return lock != null && (remotely ? lock.isLockedByOthers() : lock.isLocked());
    }

    public static void lock(CDOObject object) {
        object.cdoWriteLock().lock();
    }

    public static void unlock(CDOObject object) {
        object.cdoWriteLock().unlock();
    }

    public static DawnState computeState(EObject object) {
        DawnState result = DawnState.CLEAN;
        CDOObject cdo = CDOUtils.getCDOObject(object);
        if (cdo != null) {
            if (cdo.cdoConflict()) {
                result = DawnState.CONFLICT;
            } else if (CDOUtils.isLocked(cdo, true)) {
                result = DawnState.LOCKED_REMOTELY;
            } else if (CDOUtils.isLocked(cdo, false)) {
                result = DawnState.LOCKED_LOCALLY;
            }
        }
        return result;
    }

    public static boolean isReadOnly(CDOObject object) {
        boolean result = CDOUtils.isLocked(object, true);
        if (!result) {
            result = !object.cdoPermission().isWritable();
        }
        return result;
    }

    public static Iterable<EObject> getEObjects(Iterable<? extends CDOObject> cdoObjects) {
        return Iterables.transform(cdoObjects, CDOFunctions.getEObject());
    }

    public static Iterable<EStructuralFeature.Setting> crossReference(EObject object) {
        Collection result;
        ECrossReferenceAdapter adapter = CDOUtils.adapt(object, ECrossReferenceAdapter.class);
        if (adapter != null) {
            result = adapter.getInverseReferences(object);
        } else {
            ResourceSet rset;
            EObject tree = EcoreUtil.getRootContainer((EObject)object);
            Resource resource = tree.eResource();
            ResourceSet resourceSet = rset = resource == null ? null : resource.getResourceSet();
            result = rset != null ? EcoreUtil.UsageCrossReferencer.find((EObject)object, (ResourceSet)rset) : (resource != null ? EcoreUtil.UsageCrossReferencer.find((EObject)object, (Resource)resource) : EcoreUtil.UsageCrossReferencer.find((EObject)object, (EObject)tree));
        }
        return result;
    }

    public static <E> EContentsEList.FeatureListIterator<E> iterator(EObject object, EStructuralFeature feature, boolean resolve) {
        UnmodifiableListIterator result;
        Object value = object.eGet(feature, resolve);
        if (value instanceof InternalEList) {
            InternalEList list = (InternalEList)value;
            ListIterator delegate = resolve ? list.listIterator() : list.basicListIterator();
            class NonEmpty
            extends UnmodifiableListIterator<E>
            implements EContentsEList.FeatureListIterator<E> {
                private final /* synthetic */ EStructuralFeature val$feature;
                private final /* synthetic */ ListIterator val$delegate;

                NonEmpty(EStructuralFeature eStructuralFeature, ListIterator listIterator) {
                    this.val$feature = eStructuralFeature;
                    this.val$delegate = listIterator;
                }

                public EStructuralFeature feature() {
                    return this.val$feature;
                }

                public boolean hasNext() {
                    return this.val$delegate.hasNext();
                }

                public E next() {
                    return this.val$delegate.next();
                }

                public int nextIndex() {
                    return this.val$delegate.nextIndex();
                }

                public boolean hasPrevious() {
                    return this.val$delegate.hasPrevious();
                }

                public E previous() {
                    return this.val$delegate.previous();
                }

                public int previousIndex() {
                    return this.val$delegate.previousIndex();
                }
            }
            result = new NonEmpty(feature, delegate);
        } else if (value == null) {
            class Empty
            extends UnmodifiableListIterator<E>
            implements EContentsEList.FeatureListIterator<E> {
                private final /* synthetic */ EStructuralFeature val$feature;

                Empty(EStructuralFeature eStructuralFeature) {
                    this.val$feature = eStructuralFeature;
                }

                public EStructuralFeature feature() {
                    return this.val$feature;
                }

                public boolean hasNext() {
                    return false;
                }

                public E next() {
                    throw new NoSuchElementException();
                }

                public int nextIndex() {
                    return -1;
                }

                public boolean hasPrevious() {
                    return false;
                }

                public E previous() {
                    throw new NoSuchElementException();
                }

                public int previousIndex() {
                    return -2;
                }
            }
            result = new Empty(feature);
        } else {
            Object onlyValue = value;
            class Singleton
            extends UnmodifiableListIterator<E>
            implements EContentsEList.FeatureListIterator<E> {
                private int index = -1;
                private final /* synthetic */ EStructuralFeature val$feature;
                private final /* synthetic */ Object val$onlyValue;

                Singleton(EStructuralFeature eStructuralFeature, Object object) {
                    this.val$feature = eStructuralFeature;
                    this.val$onlyValue = object;
                }

                public EStructuralFeature feature() {
                    return this.val$feature;
                }

                public boolean hasNext() {
                    return this.index < 0;
                }

                public E next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    ++this.index;
                    return this.val$onlyValue;
                }

                public int nextIndex() {
                    return this.index;
                }

                public boolean hasPrevious() {
                    return this.index == 0;
                }

                public E previous() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    --this.index;
                    return this.val$onlyValue;
                }

                public int previousIndex() {
                    return this.index - 1;
                }
            }
            result = new Singleton(feature, onlyValue);
        }
        return result;
    }

    public static void notify(Runnable broadcastCommand) {
        broadcastExecutor.execute(broadcastCommand);
    }

    public static void notify(final TransactionalEditingDomain domain, final Runnable broadcastCommand) {
        broadcastExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    domain.runExclusive(broadcastCommand);
                }
                catch (Exception e) {
                    Activator.log.error("Exception in execution of notification broadcast.", (Throwable)e);
                }
            }
        });
    }

    public static void setBroadcastExecutor(Executor executor) {
        broadcastExecutor = executor == null ? new DirectExecutor() : executor;
    }

    public static boolean removeListenerFromDeactivatedLifecycle(IListener listener, IEvent possibleDeactivation) {
        boolean result = false;
        if (possibleDeactivation instanceof LifecycleEvent) {
            switch (((LifecycleEvent)possibleDeactivation).getKind()) {
                case DEACTIVATED: {
                    possibleDeactivation.getSource().removeListener(listener);
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    public static void unload(CDOObject cdoObject) {
        Adapter legacyWrapper;
        EList adapters;
        EObject eObject = CDOUtil.getEObject((EObject)cdoObject);
        if (!(eObject == null || (adapters = eObject.eAdapters()).isEmpty() || (legacyWrapper = (Adapter)Iterables.find((Iterable)eObject.eAdapters(), IS_LEGACY_WRAPPER, null)) != null && adapters.size() <= 1)) {
            adapters.clear();
            if (legacyWrapper != null) {
                adapters.add(0, (Object)legacyWrapper);
            }
        }
    }

    public static void unload(CDOView cdoView) {
        if (cdoView instanceof InternalCDOView) {
            for (CDOObject next : ((InternalCDOView)cdoView).getObjectsList()) {
                if (next instanceof CDOResourceNode) continue;
                CDOUtils.unload(next);
            }
        }
    }

    private static final class DirectExecutor
    implements Executor {
        private DirectExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }
}

