/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core.resource;

import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.cdo.internal.core.Activator;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.AbstractSashModelProvider;

public class CDOSashModelProvider
extends AbstractSashModelProvider {
    private static final IPath SASH_MODEL_STORAGE_ROOT = Activator.getDefault().getStateLocation().append("sashidx");
    private IPath indexFolder;

    public void initialize(ModelSet modelSet) {
        super.initialize(modelSet);
        CDOCheckout checkout = CDOExplorerUtil.getCheckout((Object)modelSet);
        if (checkout != null) {
            this.initialize(checkout);
        } else {
            this.indexFolder = SASH_MODEL_STORAGE_ROOT;
        }
    }

    public CDOSashModelProvider initialize(CDOCheckout checkout) {
        this.indexFolder = SASH_MODEL_STORAGE_ROOT.append(checkout.getView().getSession().getRepositoryInfo().getUUID());
        return this;
    }

    public URI getSashModelURI(URI userModelURI) {
        URI uriWithoutExtension = userModelURI.trimFileExtension();
        IPath stateLocation = this.indexFolder.append(CDOURIUtil.extractResourcePath((URI)uriWithoutExtension));
        return URI.createFileURI((String)stateLocation.toString()).appendFileExtension("sash");
    }
}

