/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import java.lang.ref.WeakReference;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.internal.mapmode.IMapModeHolder;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;

public class SiriusWrapLabel
extends Figure
implements PositionConstants {
    private static final String _ellipse = "...";
    private static final Dimension EMPTY_DIMENSION = new Dimension(0, 0);
    private static final Map mapModeConstantsMap = new WeakHashMap();
    private static int FLAG_SELECTED = MAX_FLAG << 1;
    private static int FLAG_HASFOCUS = MAX_FLAG << 2;
    private static int FLAG_UNDERLINED = MAX_FLAG << 3;
    private static int FLAG_STRIKEDTHROUGH = MAX_FLAG << 4;
    private static int FLAG_WRAP = MAX_FLAG << 5;
    private static int FLAG_TEXT_ALIGN = MAX_FLAG << 6;
    private static int FLAG_WRAP_ALIGN = MAX_FLAG << 9;
    private static int FLAG_ICON_ALIGN = MAX_FLAG << 12;
    private static int FLAG_LABEL_ALIGN = MAX_FLAG << 15;
    private static int FLAG_TEXT_PLACEMENT = MAX_FLAG << 18;
    private MapModeConstants mapModeConstants;
    private String text;
    private String subStringText;
    private Dimension textSize;
    private Dimension ellipseTextSize;
    private Point textLocation;
    private int cachedPrefSizeHint_width;
    private int cachedPrefSizeHint_height;
    private Point iconLocation;
    private IconInfo iconInfo;
    private int cachedTextSizeHint_width;
    private int cachedTextSizeHint_height;

    public SiriusWrapLabel() {
        this.text = "";
        this.setAlignmentFlags(2, FLAG_TEXT_ALIGN);
        this.setAlignmentFlags(2, FLAG_ICON_ALIGN);
        this.setAlignmentFlags(2, FLAG_LABEL_ALIGN);
        this.setAlignmentFlags(1, FLAG_WRAP_ALIGN);
        this.setPlacementFlags(16, FLAG_TEXT_PLACEMENT);
    }

    public SiriusWrapLabel(String s) {
        this.text = s != null ? s : "";
    }

    public SiriusWrapLabel(Image i) {
        this.text = "";
        this.iconInfo = new SingleIconInfo(i);
    }

    public SiriusWrapLabel(String s, Image i) {
        this.text = s != null ? s : "";
        this.iconInfo = new SingleIconInfo(i);
    }

    private IMapMode getFigureMapMode() {
        return (IMapMode)this.getMapModeConstants().mapModeRef.get();
    }

    private MapModeConstants getMapModeConstants() {
        if (this.mapModeConstants == null) {
            IMapMode mapMode = MapModeUtil.getMapMode((IFigure)this);
            while (mapMode instanceof IMapModeHolder) {
                mapMode = ((IMapModeHolder)mapMode).getMapMode();
            }
            this.mapModeConstants = (MapModeConstants)mapModeConstantsMap.get(mapMode);
            if (this.mapModeConstants == null) {
                this.mapModeConstants = new MapModeConstants(mapMode);
                mapModeConstantsMap.put(mapMode, this.mapModeConstants);
            }
        }
        return this.mapModeConstants;
    }

    private void alignOnHeight(Point loc, Dimension size, int alignment) {
        switch (alignment) {
            case 8: {
                loc.y = this.getInsets().top;
                break;
            }
            case 32: {
                loc.y = this.bounds.height - size.height - this.getInsets().bottom;
                break;
            }
            default: {
                loc.y = (this.bounds.height - size.height) / 2;
            }
        }
    }

    private void alignOnWidth(Point loc, Dimension size, int alignment) {
        switch (alignment) {
            case 1: {
                loc.x = this.getInsets().left;
                break;
            }
            case 4: {
                loc.x = this.bounds.width - size.width - this.getInsets().right;
                break;
            }
            default: {
                loc.x = (this.bounds.width - size.width) / 2;
            }
        }
    }

    private void calculateAlignment(Dimension iconSize, int textPlacement) {
        switch (textPlacement) {
            case 8: 
            case 16: {
                this.alignOnHeight(this.textLocation, this.getTextSize(), this.getTextAlignment());
                this.alignOnHeight(this.getIconLocation(), iconSize, this.getIconAlignment());
                break;
            }
            case 1: 
            case 4: {
                this.alignOnWidth(this.textLocation, this.getSubStringTextSize(), this.getTextAlignment());
                this.alignOnWidth(this.getIconLocation(), iconSize, this.getIconAlignment());
                break;
            }
        }
    }

    protected Dimension calculateLabelSize(Dimension txtSize) {
        Dimension iconSize = this.getTotalIconSize();
        boolean isEmpty = iconSize.width == 0 && iconSize.height == 0;
        int len = this.getText().length();
        if (len == 0 && isEmpty) {
            return new Dimension(txtSize.width, txtSize.height);
        }
        int gap = len == 0 || isEmpty ? 0 : this.getIconTextGap();
        int placement = this.getTextPlacement();
        if (placement == 8 || placement == 16) {
            return new Dimension(iconSize.width + gap + txtSize.width, Math.max(iconSize.height, txtSize.height));
        }
        return new Dimension(Math.max(iconSize.width, txtSize.width), iconSize.height + gap + txtSize.height);
    }

    private void calculateLocations() {
        this.textLocation = new Point();
        this.iconLocation = new Point();
        Dimension iconSize = this.getTotalIconSize();
        int textPlacement = this.getTextPlacement();
        this.calculatePlacement(iconSize, textPlacement);
        this.calculateAlignment(iconSize, textPlacement);
        Rectangle r = this.getBounds();
        Dimension ps = this.getPreferredSize(r.width, r.height);
        int w = r.width - ps.width + (this.getTextSize().width - this.getSubStringTextSize().width);
        int h = r.height - ps.height;
        if (w == 0 && h == 0) {
            return;
        }
        Dimension offset = new Dimension(w, h);
        switch (this.getLabelAlignment()) {
            case 1: {
                offset.scale(0.0);
                break;
            }
            case 4: {
                offset.scale(1.0);
                break;
            }
            case 8: {
                offset.height = 0;
                offset.scale(0.5);
                break;
            }
            case 32: {
                offset.height *= 2;
                offset.scale(0.5);
                break;
            }
            default: {
                offset.scale(0.5);
            }
        }
        switch (textPlacement) {
            case 8: 
            case 16: {
                offset.height = 0;
                break;
            }
            case 1: 
            case 4: {
                offset.width = 0;
                break;
            }
        }
        this.textLocation.translate(offset);
        this.iconLocation.translate(offset);
    }

    private void calculatePlacement(Dimension iconSize, int textPlacement) {
        int gap = this.getText().length() == 0 || iconSize.width == 0 && iconSize.height == 0 ? 0 : this.getIconTextGap();
        Insets insets = this.getInsets();
        switch (textPlacement) {
            case 16: {
                this.iconLocation.x = insets.left;
                this.textLocation.x = iconSize.width + gap + insets.left;
                break;
            }
            case 8: {
                this.textLocation.x = insets.left;
                this.iconLocation.x = this.getSubStringTextSize().width + gap + insets.left;
                break;
            }
            case 1: {
                this.textLocation.y = insets.top;
                this.iconLocation.y = this.getTextSize().height + gap + insets.top;
                break;
            }
            case 4: {
                this.textLocation.y = iconSize.height + gap + insets.top;
                this.iconLocation.y = insets.top;
            }
        }
    }

    protected Dimension calculateSubStringTextSize() {
        Font f = this.getFont();
        return this.getTextExtents(this.getSubStringText(), f, this.getFigureMapMode().DPtoLP(FigureUtilities.getFontMetrics((Font)f).getHeight()));
    }

    protected Dimension calculateTextSize(int wHint, int hHint) {
        Font f = this.getFont();
        return this.getTextExtents(this.getWrappedText(wHint, hHint), f, this.getFigureMapMode().DPtoLP(FigureUtilities.getFontMetrics((Font)f).getHeight()));
    }

    private void clearLocations() {
        this.textLocation = null;
        this.iconLocation = null;
    }

    public Image getIcon() {
        return this.getIcon(0);
    }

    public Image getIcon(int index) {
        if (this.iconInfo == null) {
            return null;
        }
        return this.iconInfo.getIcon(index);
    }

    protected boolean hasIcons() {
        return this.getNumberofIcons() > 0;
    }

    public int getIconAlignment() {
        return this.getAlignment(FLAG_ICON_ALIGN);
    }

    public Rectangle getIconBounds() {
        return new Rectangle(this.getBounds().getLocation().translate(this.getIconLocation()), this.getTotalIconSize());
    }

    protected Point getIconLocation() {
        if (this.iconLocation == null) {
            this.calculateLocations();
        }
        return this.iconLocation;
    }

    public int getIconTextGap() {
        return this.getMapModeConstants().nDPtoLP_3;
    }

    public Dimension getMinimumSize(int w, int h) {
        if (this.minSize != null) {
            return this.minSize;
        }
        this.minSize = new Dimension();
        LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager != null) {
            this.minSize.setSize(layoutManager.getMinimumSize((IFigure)this, w, h));
        }
        Font f = this.getFont();
        Dimension d = this.getEllipseTextSize().getIntersected(this.getTextExtents(this.getText(), f, this.getFigureMapMode().DPtoLP(FigureUtilities.getFontMetrics((Font)f).getHeight())));
        Dimension labelSize = this.calculateLabelSize(d);
        Insets insets = this.getInsets();
        labelSize.expand(insets.getWidth(), insets.getHeight());
        this.minSize.union(labelSize);
        return this.minSize;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.prefSize == null || wHint != this.cachedPrefSizeHint_width || hHint != this.cachedPrefSizeHint_height) {
            this.prefSize = this.calculateLabelSize(this.getTextSize(wHint, hHint));
            Insets insets = this.getInsets();
            this.prefSize.expand(insets.getWidth(), insets.getHeight());
            LayoutManager layoutManager = this.getLayoutManager();
            if (layoutManager != null) {
                this.prefSize.union(layoutManager.getPreferredSize((IFigure)this, wHint, hHint));
            }
            this.prefSize.union(this.getMinimumSize(wHint, hHint));
            this.cachedPrefSizeHint_width = wHint;
            this.cachedPrefSizeHint_height = hHint;
        }
        return this.prefSize;
    }

    public Dimension getMaximumSize() {
        return this.prefSize;
    }

    public String getSubStringText() {
        if (this.subStringText != null) {
            return this.subStringText;
        }
        String theText = this.getText();
        int textLen = theText.length();
        if (textLen == 0) {
            this.subStringText = "";
            return "";
        }
        Dimension size = this.getSize();
        Dimension shrink = this.getPreferredSize(size.width, size.height).getShrinked(size);
        Dimension effectiveSize = this.getTextSize().getExpanded(-shrink.width, -shrink.height);
        if (effectiveSize.height == 0) {
            this.subStringText = "";
            return "";
        }
        Font f = this.getFont();
        FontMetrics metrics = FigureUtilities.getFontMetrics((Font)f);
        IMapMode mm = this.getFigureMapMode();
        int fontHeight = mm.DPtoLP(metrics.getHeight());
        int charAverageWidth = mm.DPtoLP(metrics.getAverageCharWidth());
        int maxLines = (int)((double)effectiveSize.height / (double)fontHeight);
        if (maxLines == 0) {
            this.subStringText = "";
            return "";
        }
        StringBuffer accumlatedText = new StringBuffer();
        StringBuffer remainingText = new StringBuffer(theText);
        int effectiveSizeWidth = effectiveSize.width;
        int widthHint = Math.max(effectiveSizeWidth - this.getEllipseTextSize().width, 0);
        int i = 0;
        int j = 0;
        while (remainingText.length() > 0 && j++ < maxLines) {
            i = this.getLineWrapPosition(remainingText.toString(), f, effectiveSizeWidth, fontHeight);
            if (accumlatedText.length() > 0) {
                accumlatedText.append('\n');
            }
            if (i == 0 || remainingText.length() > i && j == maxLines) {
                i = this.getLargestSubstringConfinedTo(remainingText.toString(), f, widthHint, fontHeight, charAverageWidth);
                accumlatedText.append(remainingText.substring(0, i));
                accumlatedText.append(this.getEllipse());
            } else {
                accumlatedText.append(remainingText.substring(0, i));
            }
            remainingText.delete(0, i);
        }
        this.subStringText = accumlatedText.toString();
        return this.subStringText;
    }

    private String getWrappedText(int wHint, int hHint) {
        String theText = this.getText();
        if (wHint == -1 || theText.length() == 0 || !this.isTextWrapped()) {
            return theText;
        }
        Dimension iconSize = this.getTotalIconSize();
        if (iconSize.width != 0 || iconSize.height != 0) {
            switch (this.getTextPlacement()) {
                case 8: 
                case 16: {
                    wHint -= iconSize.width + this.getIconTextGap();
                    break;
                }
                case 1: 
                case 4: {
                    if (hHint == -1) break;
                    hHint -= iconSize.height + this.getIconTextGap();
                    break;
                }
            }
        }
        if (hHint == 0 || wHint == 0) {
            return "";
        }
        Font f = this.getFont();
        int fontHeight = this.getFigureMapMode().DPtoLP(FigureUtilities.getFontMetrics((Font)f).getHeight());
        int maxLines = Integer.MAX_VALUE;
        if (hHint != -1 && (maxLines = (int)((double)hHint / (double)fontHeight)) == 0) {
            return "";
        }
        StringBuffer accumlatedText = new StringBuffer();
        StringBuffer remainingText = new StringBuffer(theText);
        int i = 0;
        int j = 0;
        while (remainingText.length() > 0 && j++ < maxLines) {
            i = this.getLineWrapPosition(remainingText.toString(), f, wHint, fontHeight);
            if (i == 0) break;
            if (accumlatedText.length() > 0) {
                accumlatedText.append('\n');
            }
            accumlatedText.append(remainingText.substring(0, i));
            remainingText.delete(0, i);
        }
        return accumlatedText.toString();
    }

    protected Dimension getSubStringTextSize() {
        return this.calculateSubStringTextSize();
    }

    private Dimension getEllipseTextSize() {
        if (this.ellipseTextSize == null) {
            this.ellipseTextSize = this.getMapModeConstants().getEllipseTextSize(this.getFont());
        }
        return this.ellipseTextSize;
    }

    public String getText() {
        return this.text;
    }

    public int getTextAlignment() {
        return this.getAlignment(FLAG_TEXT_ALIGN);
    }

    private int getLabelAlignment() {
        return this.getAlignment(FLAG_LABEL_ALIGN);
    }

    public Rectangle getTextBounds() {
        return new Rectangle(this.getBounds().getLocation().translate(this.getTextLocation()), this.getTextSize());
    }

    protected Point getTextLocation() {
        if (this.textLocation != null) {
            return this.textLocation;
        }
        this.calculateLocations();
        return this.textLocation;
    }

    public int getTextPlacement() {
        return this.getPlacement(FLAG_TEXT_PLACEMENT);
    }

    protected Dimension getTextSize(int wHint, int hHint) {
        if (this.textSize == null || wHint != this.cachedTextSizeHint_width || hHint != this.cachedTextSizeHint_height) {
            this.textSize = this.calculateTextSize(wHint, hHint);
            this.cachedTextSizeHint_width = wHint;
            this.cachedTextSizeHint_height = hHint;
        }
        return this.textSize;
    }

    private final Dimension getTextSize() {
        Rectangle r = this.getBounds();
        return this.getTextSize(r.width, r.height);
    }

    public void invalidate() {
        this.prefSize = null;
        this.minSize = null;
        this.clearLocations();
        this.ellipseTextSize = null;
        this.textSize = null;
        this.subStringText = null;
        if (this.iconInfo != null) {
            this.iconInfo.invalidate();
        }
        super.invalidate();
    }

    public boolean isTextTruncated() {
        return !this.getSubStringTextSize().equals((Object)this.getTextSize());
    }

    public void paintFigure(Graphics graphics) {
        String subString;
        if (this.isSelected()) {
            graphics.pushState();
            graphics.setBackgroundColor(ColorConstants.menuBackgroundSelected);
            graphics.fillRectangle(this.getSelectionRectangle());
            graphics.popState();
            graphics.setForegroundColor(ColorConstants.white);
        }
        if (this.hasFocus()) {
            graphics.pushState();
            graphics.setXORMode(true);
            graphics.setForegroundColor(ColorConstants.menuBackgroundSelected);
            graphics.setBackgroundColor(ColorConstants.white);
            graphics.drawFocus(this.getSelectionRectangle().resize(-1, -1));
            graphics.popState();
        }
        if (this.isOpaque()) {
            super.paintFigure(graphics);
        }
        Rectangle figBounds = this.getBounds();
        graphics.translate(figBounds.x, figBounds.y);
        if (this.hasIcons()) {
            this.paintIcons(graphics);
        }
        if ((subString = this.getSubStringText()).length() > 0) {
            if (!this.isEnabled()) {
                graphics.translate(1, 1);
                graphics.setForegroundColor(ColorConstants.buttonLightest);
                this.paintText(graphics, subString);
                graphics.translate(-1, -1);
                graphics.setForegroundColor(ColorConstants.buttonDarker);
            } else {
                this.paintText(graphics, subString);
            }
        }
        graphics.translate(-figBounds.x, -figBounds.y);
    }

    private void paintText(Graphics graphics, String subString) {
        StringTokenizer tokenizer = new StringTokenizer(subString, "\n");
        Font f = this.getFont();
        FontMetrics fontMetrics = FigureUtilities.getFontMetrics((Font)f);
        int fontHeight = this.getFigureMapMode().DPtoLP(fontMetrics.getHeight());
        int fontHeightHalf = fontHeight / 2;
        int textWidth = this.getTextExtents((String)subString, (Font)f, (int)fontHeight).width;
        Point p = this.getTextLocation();
        int y = p.y;
        int x = p.x;
        int wrapAlignment = this.getTextWrapAlignment();
        boolean isUnderlined = this.isTextUnderlined();
        boolean isStrikedThrough = this.isTextStrikedThrough();
        Rectangle clipRect = new Rectangle();
        graphics.getClip(clipRect);
        int clipRectTopRight_x = clipRect.getTopRight().x;
        while (tokenizer.hasMoreTokens()) {
            x = p.x;
            String token = tokenizer.nextToken();
            int tokenWidth = this.getTextExtents((String)token, (Font)f, (int)fontHeight).width;
            switch (wrapAlignment) {
                case 2: {
                    x += (textWidth - tokenWidth) / 2;
                    break;
                }
                case 4: {
                    x += textWidth - tokenWidth;
                    break;
                }
            }
            if (tokenWidth + x <= clipRectTopRight_x) {
                Rectangle newClipRect = new Rectangle(clipRect);
                newClipRect.width += tokenWidth / token.length() / 2;
                graphics.setClip(newClipRect);
            }
            graphics.drawText(token, x, y);
            graphics.setClip(clipRect);
            y += fontHeight;
            if (isUnderlined) {
                graphics.setLineWidth(1);
                graphics.drawLine(x, y - 1, x + tokenWidth, y - 1);
            }
            if (!isStrikedThrough) continue;
            graphics.setLineWidth(1);
            graphics.drawLine(x, y - fontHeightHalf - 1, x + tokenWidth, y - fontHeightHalf - 1);
        }
    }

    private void paintIcons(Graphics graphics) {
        Point p = Point.SINGLETON;
        p.setLocation(this.getIconLocation());
        int num = this.getNumberofIcons();
        int i = 0;
        while (i < num) {
            Image icon = this.getIcon(i);
            if (icon != null) {
                graphics.drawImage(icon, p);
                p.x += this.getIconSize((int)i).width;
            }
            ++i;
        }
    }

    public void setIcon(Image image) {
        this.setIcon(image, 0);
    }

    public void setIcon(Image image, int index) {
        if (this.iconInfo == null) {
            if (index == 0) {
                this.iconInfo = this.getMapModeConstants().getSingleIconInfo(image);
            } else {
                this.iconInfo = new MultiIconInfo();
                this.iconInfo.setIcon(image, index);
            }
            this.revalidate();
            this.repaint();
        } else if (this.iconInfo.getIcon(index) != image) {
            if (this.iconInfo.getMaxIcons() == 1) {
                if (index == 0) {
                    this.iconInfo = this.getMapModeConstants().getSingleIconInfo(image);
                    this.revalidate();
                    this.repaint();
                    return;
                }
                IconInfo oldIconInfo = this.iconInfo;
                this.iconInfo = new MultiIconInfo();
                this.iconInfo.setIcon(oldIconInfo.getIcon(0), 0);
            }
            this.iconInfo.setIcon(image, index);
            this.revalidate();
            this.repaint();
        }
    }

    public void setIconAlignment(int align) {
        if (this.getIconAlignment() == align) {
            return;
        }
        this.setAlignmentFlags(align, FLAG_ICON_ALIGN);
        this.clearLocations();
        this.repaint();
    }

    protected Dimension getIconSize(int index) {
        if (this.iconInfo == null) {
            return EMPTY_DIMENSION;
        }
        return this.iconInfo.getIconSize(this.getFigureMapMode(), index);
    }

    protected int getNumberofIcons() {
        if (this.iconInfo == null) {
            return 0;
        }
        return this.iconInfo.getNumberofIcons();
    }

    protected Dimension getTotalIconSize() {
        if (this.iconInfo == null) {
            return EMPTY_DIMENSION;
        }
        return this.iconInfo.getTotalIconSize(this.getFigureMapMode());
    }

    public void setLabelAlignment(int align) {
        if (this.getLabelAlignment() == align) {
            return;
        }
        this.setAlignmentFlags(align, FLAG_LABEL_ALIGN);
        this.clearLocations();
        this.repaint();
    }

    protected String getEllipse() {
        return _ellipse;
    }

    public void setText(String s) {
        if (s == null) {
            s = "";
        }
        if (this.text.equals(s)) {
            return;
        }
        this.text = s;
        this.revalidate();
        this.repaint();
    }

    public void setTextAlignment(int align) {
        if (this.getTextAlignment() == align) {
            return;
        }
        this.setAlignmentFlags(align, FLAG_TEXT_ALIGN);
        this.clearLocations();
        this.repaint();
    }

    public void setTextPlacement(int where) {
        if (this.getTextPlacement() == where) {
            return;
        }
        this.setPlacementFlags(where, FLAG_TEXT_PLACEMENT);
        this.revalidate();
        this.repaint();
    }

    public void setTextUnderline(boolean b) {
        if (this.isTextUnderlined() == b) {
            return;
        }
        this.setFlag(FLAG_UNDERLINED, b);
        this.repaint();
    }

    public boolean isTextUnderlined() {
        return (this.flags & FLAG_UNDERLINED) != 0;
    }

    public void setTextStrikeThrough(boolean b) {
        if (this.isTextStrikedThrough() == b) {
            return;
        }
        this.setFlag(FLAG_STRIKEDTHROUGH, b);
        this.repaint();
    }

    public boolean isTextStrikedThrough() {
        return (this.flags & FLAG_STRIKEDTHROUGH) != 0;
    }

    public void setTextWrap(boolean b) {
        if (this.isTextWrapped() == b) {
            return;
        }
        this.setFlag(FLAG_WRAP, b);
        this.revalidate();
        this.repaint();
    }

    public boolean isTextWrapped() {
        return (this.flags & FLAG_WRAP) != 0;
    }

    public void setTextWrapWidth(int i) {
    }

    public void setTextWrapAlignment(int i) {
        if (this.getTextWrapAlignment() == i) {
            return;
        }
        this.setAlignmentFlags(i, FLAG_WRAP_ALIGN);
        this.repaint();
    }

    public int getTextWrapAlignment() {
        return this.getAlignment(FLAG_WRAP_ALIGN);
    }

    private void setPlacementFlags(int align, int flagOffset) {
        this.flags &= ~(7 * flagOffset);
        switch (align) {
            case 16: {
                this.flags |= 1 * flagOffset;
                break;
            }
            case 8: {
                this.flags |= 2 * flagOffset;
                break;
            }
            case 1: {
                this.flags |= 3 * flagOffset;
                break;
            }
            case 4: {
                this.flags |= 4 * flagOffset;
                break;
            }
        }
    }

    private int getPlacement(int flagOffset) {
        int wrapValue = this.flags & 7 * flagOffset;
        if (wrapValue == 1 * flagOffset) {
            return 16;
        }
        if (wrapValue == 2 * flagOffset) {
            return 8;
        }
        if (wrapValue == 3 * flagOffset) {
            return 1;
        }
        if (wrapValue == 4 * flagOffset) {
            return 4;
        }
        return 16;
    }

    private void setAlignmentFlags(int align, int flagOffset) {
        this.flags &= ~(7 * flagOffset);
        switch (align) {
            case 2: {
                this.flags |= 1 * flagOffset;
                break;
            }
            case 8: {
                this.flags |= 2 * flagOffset;
                break;
            }
            case 1: {
                this.flags |= 3 * flagOffset;
                break;
            }
            case 4: {
                this.flags |= 4 * flagOffset;
                break;
            }
            case 32: {
                this.flags |= 5 * flagOffset;
                break;
            }
        }
    }

    private int getAlignment(int flagOffset) {
        int wrapValue = this.flags & 7 * flagOffset;
        if (wrapValue == 1 * flagOffset) {
            return 2;
        }
        if (wrapValue == 2 * flagOffset) {
            return 8;
        }
        if (wrapValue == 3 * flagOffset) {
            return 1;
        }
        if (wrapValue == 4 * flagOffset) {
            return 4;
        }
        if (wrapValue == 5 * flagOffset) {
            return 32;
        }
        return 2;
    }

    public void setSelected(boolean b) {
        if (this.isSelected() == b) {
            return;
        }
        this.setFlag(FLAG_SELECTED, b);
        this.repaint();
    }

    public boolean isSelected() {
        return (this.flags & FLAG_SELECTED) != 0;
    }

    public void setFocus(boolean b) {
        if (this.hasFocus() == b) {
            return;
        }
        this.setFlag(FLAG_HASFOCUS, b);
        this.repaint();
    }

    public boolean hasFocus() {
        return (this.flags & FLAG_HASFOCUS) != 0;
    }

    private Rectangle getSelectionRectangle() {
        Rectangle figBounds = this.getTextBounds();
        int expansion = this.getMapModeConstants().nDPtoLP_2;
        figBounds.resize(expansion, expansion);
        this.translateToParent((Translatable)figBounds);
        figBounds.intersect(this.getBounds());
        return figBounds;
    }

    private int getLineWrapPosition(String s, Font f, int w, int fontHeight) {
        if (this.getTextExtents((String)s, (Font)f, (int)fontHeight).width <= w) {
            return s.length();
        }
        BreakIterator iter = BreakIterator.getLineInstance();
        iter.setText(s);
        int start = iter.first();
        int end = iter.next();
        if (this.getTextExtents((String)s.substring((int)start, (int)end), (Font)f, (int)fontHeight).width > w) {
            iter = BreakIterator.getCharacterInstance();
            iter.setText(s);
            start = iter.first();
        }
        while ((end = iter.next()) != -1 && this.getTextExtents((String)s.substring((int)start, (int)end), (Font)f, (int)fontHeight).width <= w) {
        }
        return end == -1 ? iter.last() : iter.previous();
    }

    private int getLargestSubstringConfinedTo(String s, Font f, int w, int fontHeight, int charAverageWidth) {
        float avg = charAverageWidth;
        int min = 0;
        int max = s.length() + 1;
        int guess = 0;
        int guessSize = 0;
        while (max - min > 1) {
            if ((guess += (int)((float)(w - guessSize) / avg)) >= max) {
                guess = max - 1;
            }
            if (guess <= min) {
                guess = min + 1;
            }
            if ((guessSize = this.getTextExtents((String)s.substring((int)0, (int)guess), (Font)f, (int)fontHeight).width) < w) {
                min = guess;
                continue;
            }
            max = guess;
        }
        return min;
    }

    private Dimension getTextExtents(String s, Font f, int fontHeight) {
        if (s.length() == 0) {
            return this.getMapModeConstants().dimension_nDPtoLP_0;
        }
        Dimension d = FigureUtilities.getTextExtents((String)s, (Font)f);
        IMapMode mapMode = this.getFigureMapMode();
        d.width = mapMode.DPtoLP(d.width);
        d.height = fontHeight * new StringTokenizer(s, "\n").countTokens();
        return d;
    }

    public int getLabelAlignment2() {
        return this.getLabelAlignment();
    }

    public boolean containsPoint(int x, int y) {
        if (this.isVisible()) {
            return super.containsPoint(x, y);
        }
        return false;
    }

    private static abstract class IconInfo {
        private IconInfo() {
        }

        public abstract Image getIcon(int var1);

        public abstract Dimension getIconSize(IMapMode var1, int var2);

        public abstract int getNumberofIcons();

        public abstract Dimension getTotalIconSize(IMapMode var1);

        public abstract void invalidate();

        public abstract void setIcon(Image var1, int var2);

        public abstract int getMaxIcons();
    }

    private static class MapModeConstants {
        private static final int MAX_IMAGE_INFO = 12;
        public final WeakReference mapModeRef;
        public final int nDPtoLP_3;
        public final int nDPtoLP_2;
        public final int nDPtoLP_0;
        public final Dimension dimension_nDPtoLP_0;
        public final WeakHashMap fontToEllipseTextSize = new WeakHashMap();
        public final SingleIconInfo[] singleIconInfos = new SingleIconInfo[12];

        public MapModeConstants(IMapMode mapMode) {
            this.mapModeRef = new WeakReference<IMapMode>(mapMode);
            this.nDPtoLP_2 = mapMode.DPtoLP(2);
            this.nDPtoLP_3 = mapMode.DPtoLP(3);
            this.nDPtoLP_0 = mapMode.DPtoLP(0);
            this.dimension_nDPtoLP_0 = new Dimension(this.nDPtoLP_0, this.nDPtoLP_0);
        }

        public Dimension getEllipseTextSize(Font f) {
            Dimension d = (Dimension)this.fontToEllipseTextSize.get(f);
            if (d == null) {
                d = FigureUtilities.getTextExtents((String)SiriusWrapLabel._ellipse, (Font)f);
                d.height = FigureUtilities.getFontMetrics((Font)f).getHeight();
                IMapMode mapMode = (IMapMode)this.mapModeRef.get();
                if (mapMode != null) {
                    d = new Dimension(mapMode.DPtoLP(d.width), mapMode.DPtoLP(d.height));
                }
                this.fontToEllipseTextSize.put(f, d);
            }
            return d;
        }

        public SingleIconInfo getSingleIconInfo(Image image) {
            SingleIconInfo info;
            if (image == null) {
                return SingleIconInfo.NULL_INFO;
            }
            int i = 0;
            while (i < 12) {
                info = this.singleIconInfos[i];
                if (info == null) {
                    this.singleIconInfos[i] = info = new SingleIconInfo(image);
                    return info;
                }
                if (info.icon == image) {
                    return info;
                }
                ++i;
            }
            int index = SingleIconInfo.count % 12;
            this.singleIconInfos[index] = info = new SingleIconInfo(image);
            return info;
        }
    }

    private static class MultiIconInfo
    extends IconInfo {
        private ArrayList icons = new ArrayList(2);
        private Dimension totalIconSize;

        @Override
        public int getMaxIcons() {
            return -1;
        }

        @Override
        public Image getIcon(int i) {
            if (i >= this.icons.size()) {
                return null;
            }
            return (Image)this.icons.get(i);
        }

        @Override
        public void setIcon(Image icon, int i) {
            int size = this.icons.size();
            if (i >= size) {
                int j = size;
                while (j < i) {
                    this.icons.add(null);
                    ++j;
                }
                this.icons.add(icon);
                this.icons.trimToSize();
            } else {
                this.icons.set(i, icon);
            }
        }

        @Override
        public Dimension getIconSize(IMapMode mapMode, int i) {
            Image img = this.getIcon(i);
            if (img != null && !img.isDisposed()) {
                org.eclipse.swt.graphics.Rectangle imgBounds = img.getBounds();
                return new Dimension(mapMode.DPtoLP(imgBounds.width), mapMode.DPtoLP(imgBounds.height));
            }
            return EMPTY_DIMENSION;
        }

        @Override
        public int getNumberofIcons() {
            return this.icons.size();
        }

        @Override
        public Dimension getTotalIconSize(IMapMode mapMode) {
            if (this.totalIconSize != null) {
                return this.totalIconSize;
            }
            int iconNum = this.getNumberofIcons();
            if (iconNum == 0) {
                this.totalIconSize = EMPTY_DIMENSION;
                return this.totalIconSize;
            }
            this.totalIconSize = new Dimension();
            int i = 0;
            while (i < iconNum) {
                Dimension iconSize = this.getIconSize(mapMode, i);
                this.totalIconSize.width += iconSize.width;
                if (iconSize.height > this.totalIconSize.height) {
                    this.totalIconSize.height = iconSize.height;
                }
                ++i;
            }
            return this.totalIconSize;
        }

        @Override
        public void invalidate() {
            this.totalIconSize = null;
        }
    }

    private static class SingleIconInfo
    extends IconInfo {
        static int count;
        public static final SingleIconInfo NULL_INFO;
        final Image icon;
        private Dimension totalIconSize;

        static {
            NULL_INFO = new SingleIconInfo(){

                @Override
                public int getNumberofIcons() {
                    return 0;
                }
            };
        }

        private SingleIconInfo() {
            this.icon = null;
        }

        public SingleIconInfo(Image icon) {
            this.icon = icon;
            ++count;
        }

        @Override
        public final int getMaxIcons() {
            return 1;
        }

        @Override
        public Image getIcon(int i) {
            if (i == 0) {
                return this.icon;
            }
            if (i > 0) {
                return null;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void setIcon(Image img, int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Dimension getIconSize(IMapMode mapMode, int i) {
            if (i == 0) {
                return this.getTotalIconSize(mapMode);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getNumberofIcons() {
            return 1;
        }

        @Override
        public Dimension getTotalIconSize(IMapMode mapMode) {
            if (this.totalIconSize != null) {
                return this.totalIconSize;
            }
            if (this.icon != null && !this.icon.isDisposed()) {
                org.eclipse.swt.graphics.Rectangle imgBounds = this.icon.getBounds();
                this.totalIconSize = new Dimension(mapMode.DPtoLP(imgBounds.width), mapMode.DPtoLP(imgBounds.height));
            } else {
                this.totalIconSize = EMPTY_DIMENSION;
            }
            return this.totalIconSize;
        }

        @Override
        public void invalidate() {
            this.totalIconSize = null;
        }
    }
}

