/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.fla.faultTreeGenerator.handlers;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JFileChooser;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.etl.EtlModule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.Bundle;

public class Transformation {
    private ExecutionEvent event;
    private Object result;

    public Transformation(ExecutionEvent event) {
        this.event = event;
    }

    public IPath execute(JFileChooser chooser) {
        Bundle bundle = Platform.getBundle((String)"org.polarsys.chess.fla.faultTreeGenerator");
        String pathETLFile = "";
        Path pathETL = new Path("epsilon/FLA2FTA.etl");
        URL ETLURL = FileLocator.find((Bundle)bundle, (IPath)pathETL, null);
        try {
            pathETLFile = FileLocator.toFileURL((URL)ETLURL).getPath();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)this.event);
        }
        catch (ExecutionException e1) {
            e1.printStackTrace();
        }
        EtlModule module = new EtlModule();
        try {
            module.parse(new File(pathETLFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IPath pat = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        String name = chooser.getSelectedFile().getName();
        if (name.contains(".flamm")) {
            String pathFlamm = chooser.getSelectedFile().getAbsolutePath();
            String flaName = chooser.getSelectedFile().getName();
            String flaName2 = flaName.replaceAll(".flamm", "");
            String pathFta = chooser.getCurrentDirectory().getAbsolutePath();
            String pathFLAMMFile = "";
            String pathEMFTAMMFile = "";
            Path pathFLAMM = new Path("models/flamm.ecore");
            Path pathEMFTAMM = new Path("models/emfta.ecore");
            URL fLAMMURL = FileLocator.find((Bundle)bundle, (IPath)pathFLAMM, null);
            URL eMFTAURL = FileLocator.find((Bundle)bundle, (IPath)pathEMFTAMM, null);
            try {
                pathFLAMMFile = FileLocator.toFileURL((URL)fLAMMURL).getPath();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                pathEMFTAMMFile = FileLocator.toFileURL((URL)eMFTAURL).getPath();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            EmfModel flammModel = this.setEmfModel("flamm", true, false, pathFLAMMFile, pathFlamm);
            EmfModel emftaModel = this.setEmfModel("emfta", false, true, pathEMFTAMMFile, String.valueOf(pathFta) + "/" + flaName2 + ".emfta");
            module.getDeclaredPre();
            module.getTransformationRules();
            module.getDeclaredPost();
            module.getContext().getModelRepository().addModel((IModel)flammModel);
            module.getContext().getModelRepository().addModel((IModel)emftaModel);
            try {
                this.result = module.execute();
            }
            catch (EolRuntimeException e) {
                e.printStackTrace();
            }
            Path ipathFta = new Path(pathFta);
            String pathStr = String.valueOf(ipathFta.removeFirstSegments(pat.segmentCount()).toOSString()) + "/" + flaName2 + ".emfta";
            Path pathReturn = new Path(pathStr);
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject projectos = iProjectArray[n2];
                try {
                    projectos.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            System.out.println("Transformation process finsihed.");
            flammModel.dispose();
            emftaModel.dispose();
            module.getContext().getModelRepository().dispose();
            return pathReturn;
        }
        MessageDialog.openError(null, (String)"Error in process", (String)"The selected file is not the result of a Failure Logic Analysis. Please select a proper one.");
        return null;
    }

    private EmfModel setEmfModel(String name, Boolean readOnLoad, Boolean storeOnDisposal, String metamodel, String model) {
        EmfModel emfModel = new EmfModel();
        emfModel.setName(name);
        emfModel.setModelFile(model);
        emfModel.setMetamodelFile(metamodel);
        emfModel.setReadOnLoad(readOnLoad.booleanValue());
        emfModel.setStoredOnDisposal(storeOnDisposal.booleanValue());
        emfModel.setCachingEnabled(true);
        emfModel.setExpand(true);
        try {
            emfModel.load();
        }
        catch (EolModelLoadingException e) {
            e.printStackTrace();
        }
        return emfModel;
    }
}

