/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.logger;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;

class PluginLogListener
implements ILogListener {
    private ILog log;
    private Logger logger;

    PluginLogListener(ILog log, Logger logger) {
        this.log = log;
        this.logger = logger;
        log.addLogListener((ILogListener)this);
    }

    void dispose() {
        if (this.log != null) {
            this.log.removeLogListener((ILogListener)this);
            this.log = null;
            this.logger = null;
        }
    }

    public void logging(IStatus status, String plugin) {
        if (this.logger == null || status == null) {
            return;
        }
        int severity = status.getSeverity();
        Level level = Level.DEBUG;
        if (severity == 4) {
            level = Level.ERROR;
        } else if (severity == 2) {
            level = Level.WARN;
        } else if (severity == 1) {
            level = Level.INFO;
        } else if (severity == 8) {
            level = Level.FATAL;
        }
        plugin = PluginLogListener.formatText(plugin);
        String statusPlugin = PluginLogListener.formatText(status.getPlugin());
        String statusMessage = PluginLogListener.formatText(status.getMessage());
        StringBuffer message = new StringBuffer();
        if (plugin != null) {
            message.append(plugin);
            message.append(" - ");
        }
        if (!(statusPlugin == null || plugin != null && statusPlugin.equals(plugin))) {
            message.append(statusPlugin);
            message.append(" - ");
        }
        message.append(status.getCode());
        if (statusMessage != null) {
            message.append(" - ");
            message.append(statusMessage);
        }
        this.logger.log((Priority)level, (Object)message.toString(), status.getException());
    }

    private static String formatText(String text) {
        if (text != null && (text = text.trim()).length() == 0) {
            return null;
        }
        return text;
    }
}

