/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.paramArchConfigurator.commands;

import eu.fbk.eclipse.standardtools.ExecOcraCommands.ui.services.OCRAExecService;
import eu.fbk.eclipse.standardtools.ModelTranslatorToOcra.ui.services.OSSTranslatorServiceUI;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.ui.commands.AbstractJobCommand;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageCommunicationDialog;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.MessageTimeModelDialog;
import eu.fbk.eclipse.standardtools.utils.ui.utils.CommandBuilder;
import eu.fbk.eclipse.standardtools.utils.ui.utils.OCRADirectoryUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Package;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.paramArchConfigurator.ui.wizard.InstantiateArchWizard;
import org.polarsys.chess.service.core.model.ChessSystemModel;
import org.polarsys.chess.service.gui.utils.SelectionUtil;

public class InstantiateArchitectureViaWizard
extends AbstractJobCommand {
    Shell shell;
    private static final Logger logger = Logger.getLogger(InstantiateArchitectureViaWizard.class);
    private SelectionUtil selectionUtil = SelectionUtil.getInstance();
    private OSSTranslatorServiceUI ocraTranslatorService = OSSTranslatorServiceUI.getInstance((AbstractSystemModel)ChessSystemModel.getInstance());
    private OCRADirectoryUtil ocraDirectoryUtil = OCRADirectoryUtil.getInstance();

    public InstantiateArchitectureViaWizard() {
        super("Instantiate Parameterized Architecture");
    }

    public void execPreJobOperations(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        int timeSpecification = MessageTimeModelDialog.openQuestion((boolean)false);
        boolean isAsyncCommunication = !MessageCommunicationDialog.openQuestion((boolean)false);
        Class umlSelectedComponent = this.selectionUtil.getUmlComponentFromSelectedObject(event);
        File ossFile = this.exportArchitectureAsOssFile(timeSpecification, isAsyncCommunication, event, monitor);
        if (ossFile != null) {
            this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            InstantiateArchWizard myWizard = new InstantiateArchWizard(ossFile, (EObject)umlSelectedComponent, timeSpecification, monitor);
            WizardDialog wizardDialog = new WizardDialog(this.shell, (IWizard)myWizard);
            wizardDialog.setHelpAvailable(false);
            if (wizardDialog.open() == 0) {
                logger.debug((Object)"Ok pressed");
                boolean importArch = myWizard.importArch();
                File paramsListFile = myWizard.getParamsListFile();
                logger.debug((Object)("paramsListFile: " + paramsListFile));
                if (importArch) {
                    File finalOssFile = myWizard.getOSSFile();
                    Package selectedPackage = myWizard.getSelectedPackage();
                    boolean createNestedPackage = myWizard.createNestedPackage();
                    String nestedPackageName = myWizard.getNestedPackageName();
                    this.preparePackage(umlSelectedComponent, selectedPackage, createNestedPackage, nestedPackageName, paramsListFile);
                    this.executeOSSimport(selectedPackage, createNestedPackage, nestedPackageName, finalOssFile);
                    this.storeInstantiationInfo(umlSelectedComponent, selectedPackage, nestedPackageName, paramsListFile);
                } else {
                    this.storeInstantiationInfo(umlSelectedComponent, null, null, paramsListFile);
                }
            } else {
                logger.debug((Object)"Cancel pressed");
            }
        }
    }

    private boolean preparePackage(final Class umlSelectedComponent, final Package selectedPackage, final boolean createNestedPackage, final String nestedPackageName, final File paramListFile) {
        Resource modelRes = SelectionUtil.getInstance().getSelectedModelResource();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Resource)modelRes);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                Package updSelectedPackage = createNestedPackage ? EntityUtil.getInstance().createPackage(selectedPackage, nestedPackageName) : selectedPackage;
                try {
                    EntityUtil.getInstance().createComment(updSelectedPackage, "Architecture created instantiating the parameterized architecture with root component " + umlSelectedComponent.getQualifiedName() + " using the following parameters values: \n" + InstantiateArchitectureViaWizard.readFile(paramListFile.getPath(), Charset.forName("UTF-8")));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        return true;
    }

    static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    private void storeInstantiationInfo(final Class umlSelectedComponent, final Package selectedPackage, final String nestedPackageName, final File paramsListFile) {
        Resource modelRes = SelectionUtil.getInstance().getSelectedModelResource();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Resource)modelRes);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                Class instantiatedRootComponent = null;
                if (selectedPackage != null) {
                    Package nestedPackage = nestedPackageName != null ? selectedPackage.getNestedPackage(nestedPackageName) : selectedPackage;
                    logger.debug((Object)("selectedPackage: " + nestedPackage));
                    instantiatedRootComponent = (Class)nestedPackage.getOwnedMember(umlSelectedComponent.getName());
                    logger.debug((Object)("instantiatedRootComponent: " + instantiatedRootComponent));
                }
                try {
                    ArrayList params = OCRAExecService.getInstance((AbstractSystemModel)ChessSystemModel.getInstance()).parseParametersFileAsArray(paramsListFile);
                    EntityUtil.getInstance().createInstantiatedArchitecture(umlSelectedComponent, instantiatedRootComponent, params);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void execJobCommand(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
    }

    private boolean executeOSSimport(final Package selectedPackage, final boolean createNestedPackage, final String nestedPackageName, final File ossFile) {
        Resource modelRes = SelectionUtil.getInstance().getSelectedModelResource();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Resource)modelRes);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                Package updSelectedPackage = createNestedPackage ? selectedPackage.getNestedPackage(nestedPackageName) : selectedPackage;
                try {
                    InstantiateArchitectureViaWizard.this.executeOSSImportCommand(updSelectedPackage, ossFile);
                }
                catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                    e.printStackTrace();
                }
            }
        });
        return true;
    }

    private void executeOSSImportCommand(Package selectedPackage, File file) throws NotDefinedException, ExecutionException, NotEnabledException, NotHandledException {
        String ID_COMMAND = "org.polarsys.chess.OSSImporter.commands.AddOSSFile";
        String ID_PARAMETER_PACKAGE_URI = "packageURI";
        String ID_PARAMETER_OSS_FILE_PATH = "ossFilePath";
        String packageURIFragment = selectedPackage.eResource().getURIFragment((EObject)selectedPackage);
        logger.debug((Object)("selectedPackage: " + selectedPackage));
        logger.debug((Object)("packageURI: " + packageURIFragment));
        CommandBuilder checkContractImplementation = CommandBuilder.build((String)ID_COMMAND);
        checkContractImplementation.setParameter(ID_PARAMETER_PACKAGE_URI, packageURIFragment);
        checkContractImplementation.setParameter(ID_PARAMETER_OSS_FILE_PATH, file.getPath());
        checkContractImplementation.execute();
    }

    private File exportArchitectureAsOssFile(int timeSpecification, boolean isAsyncCommunication, ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        String ossFilepath = this.ocraDirectoryUtil.getOSSDirPath();
        boolean showPopups = false;
        boolean usexTextValidation = true;
        Class umlSelectedComponent = this.selectionUtil.getUmlComponentFromSelectedObject(event);
        Resource umlSelectedResource = umlSelectedComponent.eResource();
        return this.ocraTranslatorService.exportRootComponentToOssFile((Object)umlSelectedComponent, umlSelectedResource, timeSpecification, isAsyncCommunication, usexTextValidation, showPopups, ossFilepath, monitor);
    }

    public void execPostJobOperations(ExecutionEvent event, NullProgressMonitor nullProgressMonitor) throws Exception {
    }
}

