/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.paramArchConfigurator.ui.dialog;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.chess.paramArchConfigurator.ui.dialog.ConfigParameter;

public class ConfigureArchitectureDialog
extends Dialog {
    ArrayList<ConfigParameter> configParams = new ArrayList();
    private boolean goAhead = false;

    public ConfigureArchitectureDialog(Shell parentShell, ArrayList<ConfigParameter> configParams) {
        super(parentShell);
        this.setShellStyle(48);
        this.configParams = configParams;
    }

    protected void okPressed() {
        this.goAhead = true;
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.getShell().setText("Configure Instantiated Architecture");
        ScrolledComposite sc = new ScrolledComposite(container, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite containerConfigParams = new Composite((Composite)sc, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        gl.makeColumnsEqualWidth = true;
        gl.verticalSpacing = 10;
        containerConfigParams.setLayout((Layout)gl);
        GridData gdName = new GridData(4, 0x1000000, true, true, 2, 1);
        GridData gdValue = new GridData(4, 0x1000000, true, true, 1, 1);
        for (ConfigParameter configParam : this.configParams) {
            Label paramNameLabel = new Label(containerConfigParams, 32);
            paramNameLabel.setAlignment(131072);
            paramNameLabel.setText(String.valueOf(configParam.getFullName()) + ": " + configParam.getType().name());
            paramNameLabel.setToolTipText("Name of the parameter and its type");
            paramNameLabel.setLayoutData((Object)gdName);
            if (configParam.getPermittedValues() == null) {
                Text paramLabelText = new Text(containerConfigParams, 32);
                paramLabelText.setToolTipText("Value of the parameter");
                paramLabelText.setLayoutData((Object)gdValue);
                VerifyListener verListener = configParam.getVerifyListener();
                if (verListener == null) continue;
                paramLabelText.addVerifyListener(verListener);
                continue;
            }
            Combo paramCombo = new Combo(containerConfigParams, 8);
            paramCombo.setLayoutData((Object)gdValue);
            paramCombo.add("");
            String[] stringArray = configParam.getPermittedValues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                paramCombo.add(value);
                ++n2;
            }
        }
        sc.setContent((Control)containerConfigParams);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(containerConfigParams.computeSize(-1, -1));
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(350, 520);
    }

    public boolean goAhead() {
        return this.goAhead;
    }
}

