/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.policy.listener;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.viewpoints.policy.Activator;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.listener.IPolicyCheckerListener;

public class PolicyCheckerNotifier {
    private static PolicyCheckerNotifier notifier;
    private static List<IPolicyCheckerListener> listeners;

    public static synchronized PolicyCheckerNotifier getInstance() {
        if (notifier == null) {
            notifier = new PolicyCheckerNotifier();
            listeners = new ArrayList<IPolicyCheckerListener>();
            notifier.init();
        }
        return notifier;
    }

    public void clearListeners() {
        listeners.clear();
    }

    public void fire(PolicyChecker policyChecker) {
        for (IPolicyCheckerListener policyCheckerListener : listeners) {
            policyCheckerListener.policyCheckerChanged(policyChecker);
        }
    }

    void init() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.viewpoints.policy.policycheckerlistener");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                Object listenerClass = configurationElement.createExecutableExtension("listenerClass");
                if (listenerClass instanceof IPolicyCheckerListener) {
                    listeners.add((IPolicyCheckerListener)listenerClass);
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            ++n2;
        }
    }
}

