/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardTools.KratosExecService.ui.services;

import eu.fbk.eclipse.standardTools.KratosExecService.ui.dialogs.KratosParametersDialog;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.core.utils.FileSystemUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.CommandBuilder;
import eu.fbk.eclipse.standardtools.xtextService.core.utils.OssToSmvExpressionConverter;
import eu.fbk.tools.Request;
import java.io.File;
import java.util.List;
import org.eclipse.swt.widgets.Display;

public class KratosExecService {
    private static KratosExecService kratosService;
    private AbstractSystemModel abstractSystemModel;
    private KratosParametersDialog dialog;

    public static KratosExecService getInstance(AbstractSystemModel abstractSystemModel) {
        if (kratosService == null) {
            kratosService = new KratosExecService(abstractSystemModel);
        }
        return kratosService;
    }

    public KratosExecService(AbstractSystemModel abstractSystemModel) {
        this.abstractSystemModel = abstractSystemModel;
    }

    public boolean executeModelChecking(String inputK2FilePath, String modelWithPropertyFilePath, String propertyFilePath, String resultFilePath, boolean isProgrExec, boolean internalExecution, String[] expression, final List<?> contextList) throws Exception {
        String property = null;
        if (!isProgrExec) {
            Display defaultDisplay = Display.getDefault();
            defaultDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    KratosExecService.this.dialog = new KratosParametersDialog(KratosExecService.this.abstractSystemModel, contextList);
                    KratosExecService.this.dialog.open();
                }
            });
            if (this.dialog.goAhead()) {
                property = this.dialog.getProperty();
                if (expression != null) {
                    expression[0] = property;
                }
            }
        }
        if (property != null) {
            this.createPropertyFile(propertyFilePath, property);
            if (this.injectPropertyIntoK2Model(inputK2FilePath, propertyFilePath, null, modelWithPropertyFilePath, true)) {
                return this.checkSwModel(modelWithPropertyFilePath, null, resultFilePath, internalExecution);
            }
        }
        return false;
    }

    private void createPropertyFile(String propertyFilePath, String property) throws Exception {
        System.out.println("oss property: " + property);
        String k2Property = new OssToSmvExpressionConverter(OssToSmvExpressionConverter.OutputLanguage.KRATOS).doGenerate(property);
        System.out.println("k2 property: " + k2Property);
        String fileContent = "SPEC = " + k2Property;
        FileSystemUtil.writeFile((File)new File(propertyFilePath), (String)fileContent);
    }

    public boolean checkSwModel(String softwareModel, String asyncExecution, String result, boolean internalExecution) {
        Request request = null;
        try {
            CommandBuilder extender = CommandBuilder.build((String)"eu.fbk.tools.adapter.ui.commands.software.CheckSwModelCommand");
            extender.setParameter("software_model", softwareModel);
            extender.setParameter("async_execution", asyncExecution);
            extender.setParameter("result_file", result);
            extender.setParameter("internal_execution", String.valueOf(internalExecution));
            Object objectResult = extender.execute();
            if (objectResult != null && objectResult instanceof Request) {
                request = (Request)objectResult;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (request == null) {
            return false;
        }
        if (!internalExecution) {
            return true;
        }
        return request.getResultStatus() == Request.ResultStatus.available;
    }

    public boolean injectPropertyIntoK2Model(String modelFilePath, String propertyFilePath, String asyncExecution, String result, boolean internalExecution) {
        Request request = null;
        try {
            CommandBuilder extender = CommandBuilder.build((String)"eu.fbk.tools.adapter.ui.commands.software.InjectPropertyIntoSwModelCommand");
            extender.setParameter("software_model", modelFilePath);
            extender.setParameter("software_property", propertyFilePath);
            extender.setParameter("async_execution", asyncExecution);
            extender.setParameter("result_file", result);
            extender.setParameter("internal_execution", String.valueOf(internalExecution));
            Object objectResult = extender.execute();
            if (objectResult != null && objectResult instanceof Request) {
                request = (Request)objectResult;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (request == null) {
            return false;
        }
        if (!internalExecution) {
            return true;
        }
        return request.getResultStatus() == Request.ResultStatus.available;
    }
}

