/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.StateMachineTranslatorToCleanC.core.services;

import eu.fbk.eclipse.standardtools.StateMachineTranslatorToCleanC.core.stateMachineModelTranslator.StateMachineModelToCleanCModelTranslator;
import eu.fbk.eclipse.standardtools.StateMachineTranslatorToCleanC.core.utils.CleanCModelUtil;
import eu.fbk.eclipse.standardtools.utils.core.exceptions.NoComponentException;
import eu.fbk.eclipse.standardtools.utils.core.exceptions.NoStateMachineException;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractStateMachineModel;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import java.io.File;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class CleanCTranslatorServiceAPI {
    private static final Logger logger = Logger.getLogger(CleanCTranslatorServiceAPI.class);
    private StateMachineModelToCleanCModelTranslator stateMachineModelToCleanCModelTranslator;
    private CleanCModelUtil cleanCModelUtil = CleanCModelUtil.getInstance();
    private AbstractStateMachineModel abstractStateMachineModel;
    private AbstractSystemModel abstractSystemModel;
    private static CleanCTranslatorServiceAPI cleanCTranslatorService;

    public static CleanCTranslatorServiceAPI getInstance(AbstractSystemModel abstractSystemModel, AbstractStateMachineModel abstractStateMachineModel) {
        if (cleanCTranslatorService == null) {
            cleanCTranslatorService = new CleanCTranslatorServiceAPI(abstractSystemModel, abstractStateMachineModel);
        }
        return cleanCTranslatorService;
    }

    public CleanCTranslatorServiceAPI(AbstractSystemModel abstractSystemModel, AbstractStateMachineModel abstractStateMachineModel) {
        this.abstractStateMachineModel = abstractStateMachineModel;
        this.abstractSystemModel = abstractSystemModel;
        this.stateMachineModelToCleanCModelTranslator = StateMachineModelToCleanCModelTranslator.getInstance(abstractStateMachineModel);
    }

    public void exportAllNominalStateMachinesOfTheModel(Object model, String selectedDirectory, String fileName, IProgressMonitor monitor) throws Exception {
        Set stateMachines = this.abstractStateMachineModel.getAllStateMachinesFromModel(model);
        logger.debug((Object)("stateMachines.size: " + stateMachines.size()));
        for (Object stateMachine : stateMachines) {
            cleanCTranslatorService.exportStateMachineToCleanCFile(stateMachine, selectedDirectory, null, monitor);
        }
    }

    public void exportNominalStateMachines(Object umlSelectedComponent, String selectedDirectory, String fileName, IProgressMonitor monitor) throws Exception {
        Set stateMachines = this.abstractStateMachineModel.getNominalStateMachinesIncludingFromSubComponents(umlSelectedComponent);
        for (Object stateMachine : stateMachines) {
            cleanCTranslatorService.exportStateMachineToCleanCFile(stateMachine, selectedDirectory, null, monitor);
        }
    }

    public File exportStateMachineOfComponentToCleanCFile(Object umlSelectedComponent, boolean showPopups, String selectedDirectory, IProgressMonitor monitor) throws Exception {
        if (umlSelectedComponent == null) {
            throw new NoComponentException();
        }
        File cleanCFile = null;
        Object stateMachine = this.abstractStateMachineModel.getFirstNominalStateMachine(umlSelectedComponent);
        if (stateMachine != null) {
            cleanCFile = cleanCTranslatorService.exportStateMachineToCleanCFile(stateMachine, selectedDirectory, this.abstractSystemModel.getComponentName(umlSelectedComponent), monitor);
            return cleanCFile;
        }
        throw new NoStateMachineException();
    }

    public HashMap<String, String> exportAllStateMachinesToCleanCFiles(Object umlSelectedComponent, String selectedDirectory, IProgressMonitor monitor) throws Exception {
        if (umlSelectedComponent == null) {
            throw new NoComponentException();
        }
        HashMap<String, String> mapCleanCFile_ComponentName = new HashMap<String, String>();
        Set stateMachines = this.abstractStateMachineModel.getNominalStateMachinesIncludingFromSubComponents(umlSelectedComponent);
        if (stateMachines != null && stateMachines.size() > 0) {
            for (Object stateMachine : stateMachines) {
                String componentName = this.abstractSystemModel.getComponentName(this.abstractStateMachineModel.getStateMachineOwner(stateMachine));
                logger.debug((Object)"exportStateMachineToCleanCFile");
                File cleanCFile = cleanCTranslatorService.exportStateMachineToCleanCFile(stateMachine, selectedDirectory, componentName, monitor);
                logger.debug((Object)"exportStateMachineToCleanCFile done");
                mapCleanCFile_ComponentName.put(cleanCFile.getPath(), componentName);
            }
        } else {
            throw new NoStateMachineException();
        }
        logger.debug((Object)"exportCleanC exportStateMachineToCleanCFile done");
        return mapCleanCFile_ComponentName;
    }

    private File exportStateMachineToCleanCFile(Object umlSelectedStateMachine, String selectedDirectory, String fileName, IProgressMonitor monitor) throws Exception {
        Object cleanCModel = this.stateMachineModelToCleanCModelTranslator.exportStateMachineAsCleanCProgram(umlSelectedStateMachine, monitor);
        if (fileName == null) {
            fileName = this.stateMachineModelToCleanCModelTranslator.getFileName(umlSelectedStateMachine);
        }
        File cleanCFile = this.exportCleanCModelToCleanCFile(cleanCModel, selectedDirectory, fileName, monitor);
        return cleanCFile;
    }

    private File exportCleanCModelToCleanCFile(Object cleanCModel, String selectedDirectory, String fileName, IProgressMonitor monitor) throws Exception {
        return this.cleanCModelUtil.generateCleanCFileFromCleanCModel(selectedDirectory, fileName, cleanCModel, monitor);
    }
}

