/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.hierarchicalContractView.core.treeproviders;

import eu.fbk.eclipse.standardtools.hierarchicalContractView.core.treeElements.ComponentNode;
import eu.fbk.eclipse.standardtools.hierarchicalContractView.core.treeElements.ContractNode;
import eu.fbk.eclipse.standardtools.hierarchicalContractView.core.treeElements.ITreeNode;
import eu.fbk.eclipse.standardtools.hierarchicalContractView.core.treeElements.SystemNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TreeColumn;

public class TreeSorter
extends ViewerComparator {
    private TreeViewer treeviewer;
    private final ViewerComparator elementsorter = new ViewerComparator();
    private int sortcolumn;
    private boolean reversesort;

    public TreeSorter(TreeViewer treeviewer) {
        this.treeviewer = treeviewer;
    }

    public void addColumn(final TreeColumn column, final int columnidx) {
        column.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeSorter.this.toggleSortColumn(columnidx);
                TreeSorter.this.setSortColumnAndDirection(column, TreeSorter.this.isReverseSort() ? 1024 : 128);
                TreeSorter.this.treeviewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void setSortColumnAndDirection(TreeColumn sortColumn, int direction) {
        sortColumn.getParent().setSortColumn(sortColumn);
        sortColumn.getParent().setSortDirection(direction);
    }

    public int getSortColumn() {
        return this.sortcolumn;
    }

    public boolean isReverseSort() {
        return this.reversesort;
    }

    public void toggleSortColumn(int column) {
        if (this.sortcolumn == column) {
            this.reversesort = !this.reversesort;
        } else {
            this.reversesort = false;
            this.sortcolumn = column;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        ITreeNode node1 = (ITreeNode)e1;
        ITreeNode node2 = (ITreeNode)e2;
        int res = 0;
        if (node1 instanceof ContractNode && node2 instanceof ContractNode) {
            res = node1.getName().compareTo(node2.getName());
        }
        if (node1 instanceof ComponentNode && node2 instanceof ComponentNode) {
            res = node1.getName().compareTo(node2.getName());
        }
        if (node1 instanceof ComponentNode && node2 instanceof ContractNode) {
            res = -1;
        }
        if (node1 instanceof ContractNode && node2 instanceof ComponentNode) {
            res = 1;
        }
        if (res == 0) {
            res = this.elementsorter.compare(viewer, e1, e2);
        } else {
            int n = res = this.isReverseSort() ? -res : res;
        }
        if (node1 instanceof SystemNode && node2 instanceof SystemNode) {
            res = node1.getName().compareTo(node2.getName());
        }
        return res;
    }
}

