/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.providers;

import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.CopyToClipboardCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.action.global.GlobalActionId;
import org.eclipse.gmf.runtime.common.ui.services.action.global.IGlobalActionContext;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.AWTClipboardHelper;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.providers.ImageSupportGlobalActionHandler;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.ui.properties.actions.PropertyPageViewAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.commands.wrappers.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.uml.diagram.common.helper.CleanDiagramHelper;
import org.eclipse.papyrus.uml.diagram.common.service.PasteCommandService;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class PapyrusDiagramGlobalActionHandler
extends ImageSupportGlobalActionHandler {
    public boolean canHandle(IGlobalActionContext cntxt) {
        IWorkbenchPart part = cntxt.getActivePart();
        if (!((part = (IWorkbenchPart)part.getAdapter(IDiagramWorkbenchPart.class)) instanceof IDiagramWorkbenchPart)) {
            return false;
        }
        if (!(cntxt.getSelection() instanceof IStructuredSelection)) {
            return false;
        }
        String actionId = cntxt.getActionId();
        if (actionId.equals(GlobalActionId.COPY)) {
            return this.canCopy(cntxt);
        }
        if (actionId.equals(GlobalActionId.CUT)) {
            return this.canCut(cntxt);
        }
        if (actionId.equals(GlobalActionId.PASTE)) {
            return this.canPaste(cntxt);
        }
        return false;
    }

    protected boolean canPaste(IGlobalActionContext cntxt) {
        Object[] objectsArray = ((IStructuredSelection)cntxt.getSelection()).toArray();
        if (objectsArray.length > 0 && objectsArray[0] instanceof GraphicalEditPart) {
            ICommand pastecommand = PasteCommandService.getInstance().getPasteViewCommand((GraphicalEditPart)objectsArray[0], Toolkit.getDefaultToolkit().getSystemClipboard(), ((GraphicalEditPart)objectsArray[0]).getEditingDomain().getClipboard());
            return pastecommand.canExecute();
        }
        if (!AWTClipboardHelper.getInstance().isImageCopySupported()) {
            return super.canPaste(cntxt);
        }
        return AWTClipboardHelper.getInstance().hasCustomData();
    }

    public ICommand getCommand(IGlobalActionContext cntxt) {
        IWorkbenchPart part = cntxt.getActivePart();
        if (!((part = (IWorkbenchPart)part.getAdapter(IDiagramWorkbenchPart.class)) instanceof IDiagramWorkbenchPart)) {
            return null;
        }
        IDiagramWorkbenchPart diagramPart = (IDiagramWorkbenchPart)part;
        ICommand command = null;
        String actionId = cntxt.getActionId();
        if (actionId.equals(GlobalActionId.DELETE)) {
            CompoundCommand deleteCC = this.getDeleteCommand(diagramPart, cntxt);
            if (deleteCC != null && deleteCC.canExecute()) {
                command = new CommandProxy((org.eclipse.gef.commands.Command)deleteCC);
            }
        } else if (actionId.equals(GlobalActionId.COPY)) {
            command = this.getCopyCommand(cntxt, diagramPart, false);
        } else if (actionId.equals(GlobalActionId.CUT)) {
            command = this.getCutCommand(cntxt, diagramPart);
        } else if (actionId.equals(GlobalActionId.PASTE)) {
            Object[] objectsArray = ((IStructuredSelection)cntxt.getSelection()).toArray();
            if (objectsArray.length > 0 && objectsArray[0] instanceof GraphicalEditPart) {
                ICommand pastecommand = PasteCommandService.getInstance().getPasteViewCommand((GraphicalEditPart)objectsArray[0], Toolkit.getDefaultToolkit().getSystemClipboard(), ((GraphicalEditPart)objectsArray[0]).getEditingDomain().getClipboard());
                if (pastecommand.canExecute()) {
                    ((GraphicalEditPart)objectsArray[0]).getEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(pastecommand));
                    RootEditPart topEditPart = ((GraphicalEditPart)objectsArray[0]).getRoot();
                    if (topEditPart.getChildren().get(0) instanceof DiagramEditPart) {
                        CleanDiagramHelper.getInstance().run((DiagramEditPart)topEditPart.getChildren().get(0));
                    }
                }
                return null;
            }
        } else if (actionId.equals(GlobalActionId.SAVE)) {
            part.getSite().getPage().saveEditor((IEditorPart)diagramPart, false);
        } else if (actionId.equals(GlobalActionId.PROPERTIES)) {
            new PropertyPageViewAction().run();
        }
        return command;
    }

    protected ICommand getCopyCommand(IGlobalActionContext cntxt, IDiagramWorkbenchPart diagramPart, boolean isUndoable) {
        Object[] objectsArray = ((IStructuredSelection)cntxt.getSelection()).toArray();
        CompositeCommand compositeCommand = new CompositeCommand(GlobalActionId.COPY);
        if (objectsArray.length > 0 && objectsArray[0] instanceof GraphicalEditPart) {
            compositeCommand.add((IUndoableOperation)new EMFtoGMFCommandWrapper(CopyToClipboardCommand.create((EditingDomain)((GraphicalEditPart)objectsArray[0]).getEditingDomain(), (Collection)this.getNotation(((IStructuredSelection)cntxt.getSelection()).toList()))));
        }
        if (objectsArray.length > 0 && objectsArray[0] instanceof ConnectionEditPart) {
            compositeCommand.add((IUndoableOperation)new EMFtoGMFCommandWrapper(CopyToClipboardCommand.create((EditingDomain)((ConnectionEditPart)objectsArray[0]).getEditingDomain(), (Collection)this.getNotation(((IStructuredSelection)cntxt.getSelection()).toList()))));
        }
        compositeCommand.add((IUndoableOperation)super.getCopyCommand(cntxt, diagramPart, isUndoable));
        return compositeCommand;
    }

    protected ICommand getCutCommand(IGlobalActionContext cntxt, IDiagramWorkbenchPart diagramPart) {
        ICommand cutCommand;
        Object[] objectsArray = ((IStructuredSelection)cntxt.getSelection()).toArray();
        CompositeCommand compositeCommand = new CompositeCommand(GlobalActionId.CUT);
        if (objectsArray.length > 0 && objectsArray[0] instanceof GraphicalEditPart) {
            compositeCommand.add((IUndoableOperation)new EMFtoGMFCommandWrapper(CopyToClipboardCommand.create((EditingDomain)((GraphicalEditPart)objectsArray[0]).getEditingDomain(), (Collection)this.getNotation(((IStructuredSelection)cntxt.getSelection()).toList()))));
        }
        if (objectsArray.length > 0 && objectsArray[0] instanceof ConnectionEditPart) {
            compositeCommand.add((IUndoableOperation)new EMFtoGMFCommandWrapper(CopyToClipboardCommand.create((EditingDomain)((ConnectionEditPart)objectsArray[0]).getEditingDomain(), (Collection)this.getNotation(((IStructuredSelection)cntxt.getSelection()).toList()))));
        }
        if ((cutCommand = super.getCutCommand(cntxt, diagramPart)) != null) {
            compositeCommand.add((IUndoableOperation)cutCommand);
        }
        return compositeCommand;
    }

    private CompoundCommand getDeleteCommand(IDiagramWorkbenchPart part, IGlobalActionContext cntxt) {
        GroupRequest deleteReq = new GroupRequest((Object)"delete");
        CompoundCommand deleteCC = new CompoundCommand(cntxt.getLabel());
        TransactionalEditingDomain editingDomain = this.getEditingDomain(part);
        if (editingDomain == null) {
            return deleteCC;
        }
        CompositeTransactionalCommand compositeCommand = new CompositeTransactionalCommand(editingDomain, cntxt.getLabel());
        Object[] objects = ((IStructuredSelection)cntxt.getSelection()).toArray();
        int i = 0;
        while (i < objects.length) {
            EditPart editPart = (EditPart)objects[i];
            org.eclipse.gef.commands.Command command = editPart.getCommand((Request)deleteReq);
            if (command != null) {
                compositeCommand.compose((IUndoableOperation)new CommandProxy(command));
            }
            ++i;
        }
        if (!compositeCommand.isEmpty()) {
            deleteCC.add((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)compositeCommand));
        }
        return deleteCC;
    }

    private TransactionalEditingDomain getEditingDomain(IDiagramWorkbenchPart part) {
        EditingDomain domain;
        TransactionalEditingDomain result = null;
        IEditingDomainProvider provider = (IEditingDomainProvider)part.getAdapter(IEditingDomainProvider.class);
        if (provider != null && (domain = provider.getEditingDomain()) != null && domain instanceof TransactionalEditingDomain) {
            result = (TransactionalEditingDomain)domain;
        }
        return result;
    }

    protected List getNotation(List editPartList) {
        ArrayList<Object> notationList = new ArrayList<Object>();
        for (Object object : editPartList) {
            if (!(object instanceof EditPart)) continue;
            notationList.add(((EditPart)object).getModel());
        }
        return notationList;
    }
}

