/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.diagram.ui.docGenerators;

import eu.fbk.eclipse.standardtools.diagram.ContainerDescriptor;
import eu.fbk.eclipse.standardtools.diagram.svg.SVGBasicObject;
import eu.fbk.eclipse.standardtools.diagram.svg.SVGComponent;
import eu.fbk.eclipse.standardtools.diagram.svg.SVGConnection;
import eu.fbk.eclipse.standardtools.diagram.svg.SVGInputConnector_circle;
import eu.fbk.eclipse.standardtools.diagram.svg.SVGInputConnector_square;
import eu.fbk.eclipse.standardtools.diagram.svg.SVGOutputConnector_circle;
import eu.fbk.eclipse.standardtools.diagram.svg.SVGOutputConnector_square;
import eu.fbk.eclipse.standardtools.diagram.ui.layout.EOrientation;
import eu.fbk.eclipse.standardtools.diagram.ui.model.AbstractInternalBlockDiagramModel;
import java.awt.Dimension;
import java.awt.Point;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.apache.fop.svg.PDFTranscoder;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InternalBlockDiagramGeneratorService {
    private static final Logger logger = Logger.getLogger(InternalBlockDiagramGeneratorService.class);
    private static InternalBlockDiagramGeneratorService diagramGeneratorService;
    AbstractInternalBlockDiagramModel graphicalModel;
    private boolean createRootComponent = true;
    private boolean showConnections = true;
    private boolean showPortLabels = true;
    private boolean automaticLabelLayout = true;
    private int component_border = 0;
    private int connector_border = 0;
    private int diagram_border = 30;
    private boolean drawPortsAsCircle = false;
    private int xTranslation = 0;
    private int yTranslation = 0;
    private int maxWidth = 0;
    private int maxHeight = 0;

    public static InternalBlockDiagramGeneratorService getInstance(AbstractInternalBlockDiagramModel graphicalModel) {
        if (diagramGeneratorService == null) {
            diagramGeneratorService = new InternalBlockDiagramGeneratorService(graphicalModel);
        }
        return diagramGeneratorService;
    }

    public InternalBlockDiagramGeneratorService(AbstractInternalBlockDiagramModel graphicalModel) {
        this.graphicalModel = graphicalModel;
    }

    public void createDiagramFile(String saveFilePath, Object component, IProgressMonitor monitor) {
        monitor.beginTask("Creating Diagram File", 1);
        this.maxWidth = 0;
        this.maxHeight = 0;
        Document docDiagram = this.createDocumentDiagram(component);
        this.createImageFileFromDocumentDiagram(saveFilePath, docDiagram);
        monitor.done();
    }

    protected ContainerDescriptor createDiagramDescriptorWithImageFileUrl(String diagramName, String saveFilePath) {
        ContainerDescriptor diagramDescriptor = new ContainerDescriptor();
        diagramDescriptor.name = diagramName;
        return diagramDescriptor;
    }

    public String getImageName(Object graphicalComponent) {
        return this.graphicalModel.getGraphicalComponentName(graphicalComponent);
    }

    public void setParametersBeforeDiagramGenerator(boolean showPortLabels, boolean automaticLabelLayout) {
        this.showPortLabels = showPortLabels;
        this.automaticLabelLayout = automaticLabelLayout;
    }

    private void createImageFileFromDocumentDiagram(String saveFilePath, Document doc) {
        try {
            TranscoderInput input = new TranscoderInput(doc);
            if (saveFilePath.endsWith("svg")) {
                SVGTranscoder transcoder = new SVGTranscoder();
                FileWriter ostream = new FileWriter(saveFilePath);
                TranscoderOutput output = new TranscoderOutput((Writer)ostream);
                transcoder.transcode(input, output);
                ((Writer)ostream).flush();
                ((Writer)ostream).close();
            } else if (saveFilePath.endsWith("png")) {
                PNGTranscoder transcoder = new PNGTranscoder();
                FileOutputStream ostream = new FileOutputStream(saveFilePath);
                TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
                transcoder.transcode(input, output);
                ostream.flush();
                ostream.close();
            } else if (saveFilePath.endsWith("pdf")) {
                PDFTranscoder transcoder = new PDFTranscoder();
                FileOutputStream ostream = new FileOutputStream(saveFilePath);
                TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
                transcoder.transcode(input, output);
                ostream.flush();
                ostream.close();
            } else {
                logger.error((Object)"Unsupported image format");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private Document createDocumentDiagram(Object component) {
        Document docDiagram = this.createDocument("svg");
        Element svgRoot = this.createDocumentElement(docDiagram);
        Point diagramPoint = this.graphicalModel.getDiagramPoint(component);
        this.xTranslation = -diagramPoint.x + this.diagram_border;
        this.yTranslation = -diagramPoint.y;
        this.createSVGComponents(docDiagram, svgRoot, component);
        if (this.showConnections) {
            this.createSVGConnections(docDiagram, svgRoot, component);
        }
        this.createSVGPorts(docDiagram, svgRoot, component, component, true);
        svgRoot.setAttributeNS(null, "width", String.valueOf(this.maxWidth + 100));
        svgRoot.setAttributeNS(null, "height", String.valueOf(this.maxHeight + 100));
        return docDiagram;
    }

    private Document createDocument(String qualifiedName) {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        Document doc = impl.createDocument("http://www.w3.org/2000/svg", qualifiedName, null);
        return doc;
    }

    private Element createDocumentElement(Document doc) {
        Element svgRoot = doc.getDocumentElement();
        return svgRoot;
    }

    private void createSVGConnections(Document doc, Element svgRootElement, Object parentComponent) {
        for (Object channel : this.graphicalModel.getPortChannels(parentComponent)) {
            Object sourcePort = this.graphicalModel.getChannelSourcePort(channel);
            Point sourcePoint = this.getLayoutPortPosition(sourcePort, this.portBelongsToComponent(sourcePort, parentComponent));
            Object targetPort = this.graphicalModel.getChannelTargetPort(channel);
            Point targetPoint = this.getLayoutPortPosition(targetPort, this.portBelongsToComponent(targetPort, parentComponent));
            List<Point> connectionPoints = this.getConnectionPoints(channel);
            SVGConnection svgConnection = new SVGConnection(doc, this.graphicalModel.getChannelName(channel), (int)sourcePoint.getX(), (int)sourcePoint.getY());
            for (Point connectionPoint : connectionPoints) {
                svgConnection.addPoint((int)connectionPoint.getX(), (int)connectionPoint.getY());
                this.computeDiagramBoundaries(connectionPoint.x, connectionPoint.y);
            }
            svgConnection.addPoint((int)targetPoint.getX(), (int)targetPoint.getY());
            svgRootElement.appendChild(svgConnection.getElement());
        }
    }

    private Point translateConnection(Point connectionPoint) {
        connectionPoint.x = (int)((double)this.xTranslation + connectionPoint.getX());
        connectionPoint.y = (int)((double)this.yTranslation + connectionPoint.getY());
        return connectionPoint;
    }

    private void createSVGPorts(Document doc, Element svgRootElement, Object parentComponent, Object selectedComponent, boolean isRootLevel) {
        for (Object port : this.graphicalModel.getGraphicalPorts(parentComponent)) {
            SVGBasicObject svgPort;
            if (!this.graphicalModel.isGraphicalPort(port)) continue;
            Point portPoint = this.getLayoutPortPosition(port, isRootLevel);
            Dimension portDimention = this.graphicalModel.getGraphicalPortDimension(port);
            if (this.graphicalModel.isGraphicalInputPort(port)) {
                svgPort = isRootLevel ? this.createOutputPort(doc, port, portPoint, portDimention) : this.createInputPort(doc, port, portPoint, portDimention);
            } else {
                if (!this.graphicalModel.isGraphicalOutputPort(port)) continue;
                svgPort = isRootLevel ? this.createInputPort(doc, port, portPoint, portDimention) : this.createOutputPort(doc, port, portPoint, portDimention);
            }
            svgRootElement.appendChild(svgPort.getElement());
            if (!this.showPortLabels) continue;
            Point labelPoint = this.getPortLabelPosition(port, isRootLevel, selectedComponent);
            svgPort.setLabelAlignement(this.getPortLabelAlignment(port, isRootLevel, selectedComponent));
            svgPort.setLabelX((int)labelPoint.getX());
            svgPort.setLabelY((int)labelPoint.getY());
            svgPort.setLabelStyle(this.getPortLabelStyle(port, selectedComponent));
            svgPort.setLabelTransform(this.getPortLabelTransform(port, selectedComponent));
            svgRootElement.appendChild(svgPort.getLabelElement());
        }
        if (isRootLevel) {
            for (Object component : this.graphicalModel.getGraphicalSubComponents(parentComponent)) {
                this.createSVGPorts(doc, svgRootElement, component, selectedComponent, false);
            }
        }
    }

    private void createSVGComponents(Document doc, Element svgRootElement, Object parentComponent) {
        if (this.createRootComponent) {
            this.createRootComponent(doc, svgRootElement, parentComponent);
        }
        for (Object component : this.graphicalModel.getGraphicalSubComponents(parentComponent)) {
            Point point = this.getComponentPoint(component, false);
            Dimension dimension = this.getComponentDimension(component);
            this.computeDiagramBoundaries(point.x + dimension.width, point.y + dimension.height);
            SVGComponent svgComponent = new SVGComponent(doc, this.graphicalModel.getGraphicalComponentName(component), (int)point.getX(), (int)point.getY(), (int)dimension.getWidth(), (int)dimension.getHeight());
            svgRootElement.appendChild(svgComponent.getElement());
            svgRootElement.appendChild(svgComponent.getLabelElement());
        }
    }

    private void createRootComponent(Document doc, Element svgRootElement, Object component) {
        Point point = this.getComponentPoint(component, true);
        Dimension dimension = this.getComponentDimension(component);
        this.computeDiagramBoundaries(point.x + dimension.width, point.y + dimension.height);
        SVGComponent svgComponent = new SVGComponent(doc, this.graphicalModel.getGraphicalComponentName(component), (int)point.getX(), (int)point.getY(), (int)dimension.getWidth(), (int)dimension.getHeight());
        svgRootElement.appendChild(svgComponent.getElement());
        svgRootElement.appendChild(svgComponent.getLabelElement());
    }

    private String getPortLabelAlignment(Object port, boolean isRootLevel, Object selectedComponent) {
        String alignement = "start";
        if (isRootLevel) {
            if (this.automaticLabelLayout) {
                alignement = this.isOnLeftSideOfConnection(port, selectedComponent) ? "end" : (this.isOnRightSideOfConnection(port, selectedComponent) ? "start" : "start");
            }
        } else {
            EOrientation orientation = this.graphicalModel.getGraphicalPortOffsetOrientation(port);
            boolean belongsToSelectedComponent = this.portBelongsToComponent(port, selectedComponent);
            if (orientation != null) {
                if (this.isEastOriented(orientation)) {
                    alignement = "start";
                    if (this.automaticLabelLayout && !belongsToSelectedComponent) {
                        alignement = "end";
                    }
                } else if (this.isWestOriented(orientation)) {
                    alignement = "end";
                    if (this.automaticLabelLayout && !belongsToSelectedComponent) {
                        alignement = "start";
                    }
                } else if (this.isNorthOriented(orientation)) {
                    alignement = "start";
                } else if (this.isSouthOriented(orientation)) {
                    alignement = "start";
                    if (this.automaticLabelLayout && !belongsToSelectedComponent) {
                        alignement = "end";
                    }
                }
            } else {
                alignement = "start";
                if (this.automaticLabelLayout && !belongsToSelectedComponent) {
                    alignement = "end";
                }
            }
        }
        return alignement;
    }

    private String getPortLabelStyle(Object port, Object selectedComponent) {
        EOrientation orientation = this.graphicalModel.getGraphicalPortOffsetOrientation(port);
        boolean belongsToSelectedComponent = this.portBelongsToComponent(port, selectedComponent);
        if (orientation != null) {
            if (this.isEastOriented(orientation)) {
                return "";
            }
            if (this.isWestOriented(orientation)) {
                return "";
            }
            if (this.isNorthOriented(orientation) ? this.automaticLabelLayout && !belongsToSelectedComponent : this.isSouthOriented(orientation) && this.automaticLabelLayout && !belongsToSelectedComponent) {
                return "writing-mode: lr-tb";
            }
        }
        return "";
    }

    private Point getPortLabelPosition(Object port, boolean isRootLevel, Object selectedComponent) {
        Point point = this.getLayoutPortPosition(port, isRootLevel);
        if (isRootLevel) {
            if (this.automaticLabelLayout) {
                point.x = this.isOnLeftSideOfConnection(port, selectedComponent) ? (int)(point.getX() - 10.0) : (this.isOnRightSideOfConnection(port, selectedComponent) ? (int)(point.getX() + 10.0) : (int)(point.getX() + 10.0));
            }
        } else {
            EOrientation orientation = this.graphicalModel.getGraphicalPortOffsetOrientation(port);
            boolean belongsToSelectedComponent = this.portBelongsToComponent(port, selectedComponent);
            if (orientation != null) {
                if (this.isEastOriented(orientation)) {
                    point.y = (int)(point.getY() + 4.0);
                    point.x = this.automaticLabelLayout && !belongsToSelectedComponent ? (int)(point.getX() - 10.0) : (int)(point.getX() + 10.0);
                } else if (this.isWestOriented(orientation)) {
                    point.y = (int)(point.getY() + 4.0);
                    point.x = this.automaticLabelLayout && !belongsToSelectedComponent ? (int)(point.getX() + 10.0) : (int)(point.getX() - 10.0);
                } else if (this.isNorthOriented(orientation)) {
                    point.x = (int)point.getX();
                    point.y = this.automaticLabelLayout && !belongsToSelectedComponent ? (int)(point.getY() + 10.0) : (int)(point.getY() - 10.0);
                } else if (this.isSouthOriented(orientation)) {
                    point.x = (int)point.getX();
                    point.y = this.automaticLabelLayout && !belongsToSelectedComponent ? (int)(point.getY() + 10.0) : (int)(point.getY() + 10.0);
                }
            } else {
                point.y = (int)(point.getY() + 4.0);
                point.x = this.automaticLabelLayout && !belongsToSelectedComponent ? (int)(point.getX() - 10.0) : (int)(point.getX() + 10.0);
            }
        }
        this.maxWidth = (int)Math.max((double)this.maxWidth, point.getX() + (double)(this.graphicalModel.getGraphicalPortName(port).length() * 8));
        return point;
    }

    private boolean isOnLeftSideOfConnection(Object port, Object selectedComponent) {
        int xPortPosition;
        if (this.graphicalModel.getGraphicalSubComponents(this.graphicalModel.getGraphicalPortOwner(port)).isEmpty()) {
            return false;
        }
        if (this.graphicalModel.getPortOutgoingChannels(port) != null) {
            for (Object channel : this.graphicalModel.getPortOutgoingChannels(port)) {
                Object targetPort;
                int xTargetPortPosition;
                if (!this.channelBelongsToSelectedComponent(channel, selectedComponent) || (xTargetPortPosition = (int)this.getLayoutPortPosition(targetPort = this.graphicalModel.getChannelTargetPort(channel), this.portBelongsToComponent(targetPort, selectedComponent)).getX()) <= (xPortPosition = (int)this.getLayoutPortPosition(port, this.portBelongsToComponent(port, selectedComponent)).getX())) continue;
                return true;
            }
        }
        if (this.graphicalModel.getPortIncomingChannels(port) != null) {
            for (Object channel : this.graphicalModel.getPortIncomingChannels(port)) {
                Object sourcePort;
                int xSourcePortPosition;
                if (!this.channelBelongsToSelectedComponent(channel, selectedComponent) || (xSourcePortPosition = (int)this.getLayoutPortPosition(sourcePort = this.graphicalModel.getChannelSourcePort(channel), this.portBelongsToComponent(sourcePort, selectedComponent)).getX()) <= (xPortPosition = (int)this.getLayoutPortPosition(port, this.portBelongsToComponent(port, selectedComponent)).getX())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOnRightSideOfConnection(Object port, Object selectedComponent) {
        int xPortPosition;
        if (this.graphicalModel.getGraphicalSubComponents(this.graphicalModel.getGraphicalPortOwner(port)).isEmpty()) {
            return false;
        }
        if (this.graphicalModel.getPortOutgoingChannels(port) != null) {
            for (Object channel : this.graphicalModel.getPortOutgoingChannels(port)) {
                Object targetPort;
                int xTargetPortPosition;
                if (!this.channelBelongsToSelectedComponent(channel, selectedComponent) || (xTargetPortPosition = (int)this.getLayoutPortPosition(targetPort = this.graphicalModel.getChannelTargetPort(channel), this.portBelongsToComponent(targetPort, selectedComponent)).getX()) >= (xPortPosition = (int)this.getLayoutPortPosition(port, this.portBelongsToComponent(port, selectedComponent)).getX())) continue;
                return true;
            }
        }
        if (this.graphicalModel.getPortIncomingChannels(port) != null) {
            for (Object channel : this.graphicalModel.getPortIncomingChannels(port)) {
                Object sourcePort;
                int xSourcePortPosition;
                if (!this.channelBelongsToSelectedComponent(channel, selectedComponent) || (xSourcePortPosition = (int)this.getLayoutPortPosition(sourcePort = this.graphicalModel.getChannelSourcePort(channel), this.portBelongsToComponent(sourcePort, selectedComponent)).getX()) >= (xPortPosition = (int)this.getLayoutPortPosition(port, this.portBelongsToComponent(port, selectedComponent)).getX())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean portBelongsToComponent(Object port, Object parentComponent) {
        return this.graphicalModel.getGraphicalComponentId(parentComponent) == this.graphicalModel.getGraphicalComponentId(this.graphicalModel.getGraphicalPortOwner(port));
    }

    private Point getLayoutPortPosition(Object port, boolean isRootLevel) {
        Point portPoint = this.graphicalModel.getGraphicalPortPosition(port);
        Point translatedPortPoint = this.translatePortPoint(portPoint);
        this.computeDiagramBoundaries(translatedPortPoint.x, translatedPortPoint.y);
        return translatedPortPoint;
    }

    private Point translatePortPoint(Point portPoint) {
        portPoint.x = (int)((double)this.xTranslation + portPoint.getX() + (double)this.connector_border);
        portPoint.y = (int)((double)this.yTranslation + portPoint.getY() + (double)this.connector_border);
        return portPoint;
    }

    private void computeDiagramBoundaries(int width, int height) {
        this.maxWidth = Math.max(this.maxWidth, width);
        this.maxHeight = Math.max(this.maxHeight, height);
    }

    private boolean channelBelongsToSelectedComponent(Object channel, Object selectedComponent) {
        return this.graphicalModel.getGraphicalComponentId(this.graphicalModel.getChannelOwner(channel)) == this.graphicalModel.getGraphicalComponentId(selectedComponent);
    }

    private boolean isEastOriented(EOrientation orientation) {
        return orientation.getOrientation() == EOrientation.Orientation.EAST_VALUE;
    }

    private boolean isWestOriented(EOrientation orientation) {
        return orientation.getOrientation() == EOrientation.Orientation.WEST_VALUE;
    }

    private boolean isNorthOriented(EOrientation orientation) {
        return orientation.getOrientation() == EOrientation.Orientation.NORTH_VALUE;
    }

    private boolean isSouthOriented(EOrientation orientation) {
        return orientation.getOrientation() == EOrientation.Orientation.SOUTH_VALUE;
    }

    private Point translateComponentPoint(Point componentPoint) {
        Point point = new Point(componentPoint);
        point.x = (int)((double)this.xTranslation + point.getX() + (double)this.component_border);
        point.y = (int)((double)this.yTranslation + point.getY() + (double)this.component_border);
        return point;
    }

    private Dimension getComponentDimension(Object component) {
        Dimension currentDimension = this.graphicalModel.getGraphicalComponentDimension(component);
        Dimension dimension = new Dimension(currentDimension);
        dimension.width = (int)(dimension.getWidth() - (double)(2 * this.component_border));
        dimension.height = (int)(dimension.getHeight() - (double)(2 * this.component_border));
        return dimension;
    }

    private String getPortLabelTransform(Object port, Object selectedComponent) {
        EOrientation orientation = this.graphicalModel.getGraphicalPortOffsetOrientation(port);
        boolean belongsToSelectedComponent = this.portBelongsToComponent(port, selectedComponent);
        if (orientation != null) {
            if (this.isEastOriented(orientation)) {
                return "";
            }
            if (this.isWestOriented(orientation)) {
                return "";
            }
            if (this.isNorthOriented(orientation)) {
                if (this.automaticLabelLayout && !belongsToSelectedComponent) {
                    Point position = this.getLayoutPortPosition(port, false);
                    return String.format("rotate(90 %s,%s)", position.getX(), position.getY() + 8.0);
                }
            } else if (this.isSouthOriented(orientation) && this.automaticLabelLayout && !belongsToSelectedComponent) {
                Point position = this.getLayoutPortPosition(port, false);
                return String.format("rotate(90 %s,%s)", position.getX() + 8.0, position.getY());
            }
        }
        return "";
    }

    private Point getComponentPoint(Object component, boolean isRootComponent) {
        Point componentPoint = this.graphicalModel.getGraphicalComponentPosition(component);
        Point translatedComponentPoint = this.translateComponentPoint(componentPoint);
        return translatedComponentPoint;
    }

    private List<Point> getConnectionPoints(Object channel) {
        ArrayList<Point> translatedConnPoints = new ArrayList<Point>();
        for (Point connectionPoint : this.graphicalModel.getLayoutChannelPoints(channel)) {
            translatedConnPoints.add(this.translateConnection(connectionPoint));
        }
        return translatedConnPoints;
    }

    private SVGBasicObject createInputPort(Document doc, Object port, Point portPoint, Dimension portDimension) {
        if (this.drawPortsAsCircle) {
            return this.createInputPort_asCircle(doc, port, portPoint);
        }
        return this.createInputPort_asSquare(doc, port, portPoint, portDimension);
    }

    private SVGBasicObject createOutputPort(Document doc, Object port, Point portPoint, Dimension portDimension) {
        if (this.drawPortsAsCircle) {
            return this.createOutputPort_asCircle(doc, port, portPoint);
        }
        return this.createOutputPort_asSquare(doc, port, portPoint, portDimension);
    }

    private SVGInputConnector_circle createInputPort_asCircle(Document doc, Object port, Point portPoint) {
        return new SVGInputConnector_circle(doc, this.graphicalModel.getGraphicalPortName(port), (int)portPoint.getX(), (int)portPoint.getY());
    }

    private SVGOutputConnector_circle createOutputPort_asCircle(Document doc, Object port, Point portPoint) {
        return new SVGOutputConnector_circle(doc, this.graphicalModel.getGraphicalPortName(port), (int)portPoint.getX(), (int)portPoint.getY());
    }

    private SVGInputConnector_square createInputPort_asSquare(Document doc, Object port, Point portPoint, Dimension portDimension) {
        return new SVGInputConnector_square(doc, this.graphicalModel.getGraphicalPortName(port), (int)portPoint.getX(), (int)portPoint.getY(), portDimension.width, portDimension.height);
    }

    private SVGOutputConnector_square createOutputPort_asSquare(Document doc, Object port, Point portPoint, Dimension portDimension) {
        return new SVGOutputConnector_square(doc, this.graphicalModel.getGraphicalPortName(port), (int)portPoint.getX(), (int)portPoint.getY(), portDimension.width, portDimension.height);
    }
}

