/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.diagram.ui.wizard;

import eu.fbk.eclipse.standardtools.diagram.DocumentGenerator;
import eu.fbk.eclipse.standardtools.diagram.ui.wizard.SecondWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class FirstWizardPage
extends WizardPage {
    private Composite container;
    private Combo comboFormat;
    private Button btnShowDiagrams;
    private Button btnShowLeafComponents;
    private Button btnShowCheckResults;
    private Button btnShowModelElements;

    public FirstWizardPage() {
        super("General settings");
        this.setTitle("General Settings");
        this.setDescription("Specify the general aspects of the report");
    }

    public void onEnterPage() {
        this.getShell().layout(true, true);
    }

    public IWizardPage getNextPage() {
        this.getShell().layout(true, true);
        SecondWizardPage nextPage = (SecondWizardPage)super.getNextPage();
        nextPage.onEnterPage();
        return nextPage;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 2;
        Label lblOutputFormat = new Label(this.container, 0);
        lblOutputFormat.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblOutputFormat.setText("Select the document format");
        this.comboFormat = new Combo(this.container, 8);
        this.comboFormat.setItems(DocumentGenerator.DocumentType.getValuesAsStringArray());
        this.comboFormat.select(0);
        this.btnShowDiagrams = new Button(this.container, 32);
        this.btnShowDiagrams.setSelection(true);
        this.btnShowDiagrams.setAlignment(131072);
        this.btnShowDiagrams.setText("Show diagrams (BDDs, IBDs, STMs)");
        this.btnShowDiagrams.setToolTipText("Show diagrams in the document");
        this.btnShowDiagrams.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnShowLeafComponents = new Button(this.container, 32);
        this.btnShowLeafComponents.setSelection(true);
        this.btnShowLeafComponents.setAlignment(131072);
        this.btnShowLeafComponents.setText("Show sub components");
        this.btnShowLeafComponents.setToolTipText("Show all the components of the model");
        this.btnShowLeafComponents.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnShowCheckResults = new Button(this.container, 32);
        this.btnShowCheckResults.setSelection(true);
        this.btnShowCheckResults.setAlignment(131072);
        this.btnShowCheckResults.setText("Show Validation and Verification  results");
        this.btnShowCheckResults.setToolTipText("Show the results of analyses");
        this.btnShowCheckResults.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnShowModelElements = new Button(this.container, 32);
        this.btnShowModelElements.setSelection(true);
        this.btnShowModelElements.setAlignment(131072);
        this.btnShowModelElements.setText("Show specific model elements");
        this.btnShowModelElements.setToolTipText("Show details of the elements");
        this.btnShowModelElements.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnShowModelElements.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                FirstWizardPage.this.getShell().layout(true, true);
                if (button.getSelection()) {
                    FirstWizardPage.this.setPageComplete(true);
                } else {
                    FirstWizardPage.this.setPageComplete(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)this.container);
        this.setPageComplete(true);
    }

    public String getDocumentFormat() {
        if (this.comboFormat.getSelectionIndex() != -1) {
            return this.comboFormat.getItems()[this.comboFormat.getSelectionIndex()];
        }
        return null;
    }

    public boolean getShowDiagrams() {
        return this.btnShowDiagrams.getSelection();
    }

    public boolean getShowLeafComponents() {
        return this.btnShowLeafComponents.getSelection();
    }

    public boolean getShowCheckResults() {
        return this.btnShowCheckResults.getSelection();
    }

    public boolean getShowModelElements() {
        return this.btnShowModelElements.getSelection();
    }
}

