/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.utils.ui.utils;

import eu.fbk.eclipse.standardtools.utils.ui.utils.DirectoryUtil;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class OCRADirectoryUtil {
    private static final Logger logger = Logger.getLogger(OCRADirectoryUtil.class);
    private final String OCRA_DIR_PATH = String.valueOf(File.separator) + "NuSMV3-OCRA";
    private final String OCRA_OSS_DIR_PATH = String.valueOf(this.OCRA_DIR_PATH) + File.separator + "Files";
    private final String OCRA_RESULTS_DIR_PATH = String.valueOf(this.OCRA_DIR_PATH) + File.separator + "Results";
    private static OCRADirectoryUtil OCRAdirectoryUtilInstance;
    private DirectoryUtil directoryUtil = DirectoryUtil.getInstance();

    public static OCRADirectoryUtil getInstance() {
        if (OCRAdirectoryUtilInstance == null) {
            OCRAdirectoryUtilInstance = new OCRADirectoryUtil();
        }
        return OCRAdirectoryUtilInstance;
    }

    public String getOSSDirPath() throws Exception {
        String ossDirPath = String.valueOf(this.directoryUtil.getCurrentProjectDir()) + this.OCRA_OSS_DIR_PATH;
        logger.debug((Object)("ossDirPath: " + ossDirPath));
        return ossDirPath;
    }

    public String getOSSDirPath(String projectPath) throws Exception {
        String ossDirPath = String.valueOf(projectPath) + this.OCRA_OSS_DIR_PATH;
        logger.debug((Object)("ossDirPath: " + ossDirPath));
        return ossDirPath;
    }

    private String getOcraResultsDirPath(String baseDir) {
        String ocraResultsDirPath = String.valueOf(baseDir) + this.OCRA_RESULTS_DIR_PATH;
        logger.debug((Object)("ocraResultsFilePath: " + ocraResultsDirPath));
        return ocraResultsDirPath;
    }

    private String createOcraResultsFileDir(String baseDir) {
        String dirPath = this.getOcraResultsDirPath(baseDir);
        File theDirectory = new File(dirPath);
        theDirectory.mkdirs();
        return dirPath;
    }

    private String getOcraResultFilePath(String ossFileName, String baseDir, String commandType, String extension) {
        logger.debug((Object)("ossFileName: " + ossFileName));
        String ocraResultsFileDir = this.createOcraResultsFileDir(baseDir);
        String filePath = String.valueOf(ocraResultsFileDir) + File.separator + ossFileName.replace(".", "_") + "_" + commandType + "." + extension;
        return filePath;
    }

    public String getOcraResultsErrorsFilePath(String ossFileName, String baseDir) {
        String ocraResultsErrorsFilePath = String.valueOf(this.getOcraResultsDirPath(baseDir)) + File.separator + ossFileName.replace(".", "_") + "_refinement_error.txt";
        logger.debug((Object)("ocraResultsErrorsFilePath: " + ocraResultsErrorsFilePath));
        return ocraResultsErrorsFilePath;
    }

    public String getCommandCheckRefinementResultPath(String selectedComponentName) throws Exception {
        return this.getOcraResultFilePath("output_" + selectedComponentName, this.directoryUtil.getCurrentProjectDir(), "refinement_result", "xml");
    }

    public String getCommandFaultTreeGenResultPath(String selectedComponentName) throws Exception {
        return this.getOcraResultFilePath("output_" + selectedComponentName, this.directoryUtil.getCurrentProjectDir(), "faultTree_result", "xml");
    }

    public String getCommandCheckImplementationResultPath(String selectedComponentName) throws Exception {
        return this.getOcraResultFilePath("output_" + selectedComponentName, this.directoryUtil.getCurrentProjectDir(), "implementation_result", "xml");
    }

    public String getCommandCheckPropertyResultPath(String selectedComponentName) throws Exception {
        return this.getOcraResultFilePath("output_" + selectedComponentName, this.directoryUtil.getCurrentProjectDir(), "property_result", "xml");
    }

    public String getCommandInstantiateParamArchResultPath(String ossFileName, int numInstantiation) throws Exception {
        logger.debug((Object)("getCommandInstantiateParamArchResultPath: ossFileName-" + ossFileName));
        return this.getOcraResultFilePath(ossFileName, this.directoryUtil.getCurrentProjectDir(), "instance_" + numInstantiation, "oss");
    }

    public String getParametersResultFilePath(String ossFileName) throws Exception {
        logger.debug((Object)("getParametersResultFilePath: ossFileName-" + ossFileName));
        return this.getOcraResultFilePath(FilenameUtils.removeExtension((String)ossFileName), this.directoryUtil.getCurrentProjectDir(), "paramList", "csv");
    }

    public String getInputParametersFilePath(String ossFileName) throws Exception {
        logger.debug((Object)("getInputParametersFilePath: ossFileName-" + ossFileName));
        return String.valueOf(this.getOSSDirPath()) + File.separator + FilenameUtils.removeExtension((String)ossFileName) + "_assignedParams.csv";
    }
}

