/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.chessmlprofile.Dependability.DependableComponent;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Analysis implements Enumerator
{
    FMEA_ANALYSIS(0, "FMEA_ANALYSIS", "FMEA_ANALYSIS"),
    FTA_ANALYSIS(1, "FTA_ANALYSIS", "FTA_ANALYSIS"),
    CONTRACT_BASED_FTA_ANALYSIS(2, "CONTRACT_BASED_FTA_ANALYSIS", "CONTRACT_BASED_FTA_ANALYSIS"),
    CONTRACT_REFINEMENT_ANALYSIS(3, "CONTRACT_REFINEMENT_ANALYSIS", "CONTRACT_REFINEMENT_ANALYSIS"),
    CONTRACT_IMPLEMENTATION_ANALYSIS(4, "CONTRACT_IMPLEMENTATION_ANALYSIS", "CONTRACT_IMPLEMENTATION_ANALYSIS"),
    PROPERTY_VALIDATION_ANALYSIS(5, "PROPERTY_VALIDATION_ANALYSIS", "PROPERTY_VALIDATION_ANALYSIS"),
    CONTRACT_PROPERTY_VALIDATION_ANALYSIS(6, "CONTRACT_PROPERTY_VALIDATION_ANALYSIS", "CONTRACT_PROPERTY_VALIDATION_ANALYSIS"),
    MODEL_CHECKING_ANALYSIS(7, "MODEL_CHECKING_ANALYSIS", "MODEL_CHECKING_ANALYSIS"),
    CONTRACT_COMPOSITE_IMPLEMENTATION_ANALYSIS(8, "CONTRACT_COMPOSITE_IMPLEMENTATION_ANALYSIS", "CONTRACT_COMPOSITE_IMPLEMENTATION_ANALYSIS");

    public static final int FMEA_ANALYSIS_VALUE = 0;
    public static final int FTA_ANALYSIS_VALUE = 1;
    public static final int CONTRACT_BASED_FTA_ANALYSIS_VALUE = 2;
    public static final int CONTRACT_REFINEMENT_ANALYSIS_VALUE = 3;
    public static final int CONTRACT_IMPLEMENTATION_ANALYSIS_VALUE = 4;
    public static final int PROPERTY_VALIDATION_ANALYSIS_VALUE = 5;
    public static final int CONTRACT_PROPERTY_VALIDATION_ANALYSIS_VALUE = 6;
    public static final int MODEL_CHECKING_ANALYSIS_VALUE = 7;
    public static final int CONTRACT_COMPOSITE_IMPLEMENTATION_ANALYSIS_VALUE = 8;
    private static final Analysis[] VALUES_ARRAY;
    public static final List<Analysis> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Analysis[]{FMEA_ANALYSIS, FTA_ANALYSIS, CONTRACT_BASED_FTA_ANALYSIS, CONTRACT_REFINEMENT_ANALYSIS, CONTRACT_IMPLEMENTATION_ANALYSIS, PROPERTY_VALIDATION_ANALYSIS, CONTRACT_PROPERTY_VALIDATION_ANALYSIS, MODEL_CHECKING_ANALYSIS, CONTRACT_COMPOSITE_IMPLEMENTATION_ANALYSIS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Analysis get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Analysis result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Analysis getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Analysis result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Analysis get(int value) {
        switch (value) {
            case 0: {
                return FMEA_ANALYSIS;
            }
            case 1: {
                return FTA_ANALYSIS;
            }
            case 2: {
                return CONTRACT_BASED_FTA_ANALYSIS;
            }
            case 3: {
                return CONTRACT_REFINEMENT_ANALYSIS;
            }
            case 4: {
                return CONTRACT_IMPLEMENTATION_ANALYSIS;
            }
            case 5: {
                return PROPERTY_VALIDATION_ANALYSIS;
            }
            case 6: {
                return CONTRACT_PROPERTY_VALIDATION_ANALYSIS;
            }
            case 7: {
                return MODEL_CHECKING_ANALYSIS;
            }
            case 8: {
                return CONTRACT_COMPOSITE_IMPLEMENTATION_ANALYSIS;
            }
        }
        return null;
    }

    private Analysis(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

