/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.uml.profile.drafter.Activator;
import org.eclipse.papyrus.uml.profile.drafter.ProfileCatalog;
import org.eclipse.papyrus.uml.profile.drafter.ui.contentassist.PossibleStereotypeContentProposalProvider;
import org.eclipse.papyrus.uml.profile.drafter.ui.contentassist.StereotypeContentProposalProvider;
import org.eclipse.papyrus.uml.profile.drafter.ui.dialog.IStereotypeUpdateArgs;
import org.eclipse.papyrus.uml.profile.drafter.ui.dialog.MultipleValueSelectorWidget;
import org.eclipse.papyrus.uml.profile.drafter.ui.dialog.PropertiesEditorWidget;
import org.eclipse.papyrus.uml.profile.drafter.ui.dialog.StereotypeUpdateArgs;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.MetaclassesModel;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.StereoptypeModel;
import org.eclipse.papyrus.uml.tools.providers.UMLMetaclassContentProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeUpdateDialog
extends Dialog {
    private Binding stereotypeNameBinding;
    private Binding profileNameBinding;
    private Binding stereotypeBinding;
    private DataBindingContext m_bindingContext;
    private Binding profileBinding;
    private Text quickSetText;
    private Text stereotypeText;
    private Text profileText;
    private String title;
    private StereotypeUpdateArgs value;
    private MultipleValueSelectorWidget extendedMetaclassSelector;
    private PropertiesEditorWidget propertiesEditorWidget;
    private Element anyUmlElement;
    private List<Class> selectedMetaclasses;
    private StereoptypeModel stereotypeModel;
    private ProfileCatalog profileCatalog;
    private Label quickSetLabel;
    private Label profileNameLabel;

    public StereotypeUpdateDialog(Shell parentShell, String title, Element selectedElement, List<Class> metaclassesToSelect) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = title;
        this.anyUmlElement = selectedElement;
        this.selectedMetaclasses = metaclassesToSelect;
        this.profileCatalog = new ProfileCatalog(selectedElement);
        this.stereotypeModel = new StereoptypeModel(this.profileCatalog, selectedElement);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite namesContainer = new Composite(container, 0);
        namesContainer.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        namesContainer.setLayout((Layout)new GridLayout(2, false));
        this.quickSetLabel = new Label(namesContainer, 0);
        this.quickSetLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.quickSetLabel.setText("Qualified Name");
        this.quickSetText = new Text(namesContainer, 2048);
        this.quickSetText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.installContentAssistantProvider(this.quickSetText, new PossibleStereotypeContentProposalProvider(this.anyUmlElement));
        this.profileNameLabel = new Label(namesContainer, 0);
        this.profileNameLabel.setSize(43, 20);
        this.profileNameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.profileNameLabel.setText("Profile");
        this.profileText = new Text(namesContainer, 2048);
        this.profileText.setSize(201, 26);
        this.profileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label stereotypeNameLabel = new Label(namesContainer, 0);
        stereotypeNameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        stereotypeNameLabel.setText("Stereotype");
        this.stereotypeText = new Text(namesContainer, 2048);
        this.stereotypeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.installContentAssistantProvider(this.stereotypeText, new StereotypeContentProposalProvider((List<Stereotype>)this.anyUmlElement.getApplicableStereotypes()));
        this.createExtendedMetaclassArea(container);
        Composite extendedStereotypeContainer = new Composite(container, 0);
        extendedStereotypeContainer.setLayout((Layout)new GridLayout(1, false));
        extendedStereotypeContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite taggedValuesContainer = new Composite(container, 0);
        taggedValuesContainer.setLayout((Layout)new GridLayout(1, false));
        taggedValuesContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.propertiesEditorWidget = new PropertiesEditorWidget(taggedValuesContainer, this.stereotypeModel.getProperties(), (NamedElement)this.anyUmlElement);
        return container;
    }

    protected void installContentAssistantProvider(Text control, IContentProposalProvider contentProposalProvider) {
        KeyStroke keyStroke = null;
        char[] autoActivationCharacters = null;
        int autoActivationDelay = 500;
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)control, (IControlContentAdapter)new TextContentAdapter(), contentProposalProvider, keyStroke, autoActivationCharacters);
        adapter.setAutoActivationDelay(autoActivationDelay);
        adapter.setFilterStyle(1);
        adapter.setProposalAcceptanceStyle(2);
    }

    private void createExtendedMetaclassArea(Composite parent) {
        ReferenceSelector selector = new ReferenceSelector(true);
        selector.setContentProvider((IStaticContentProvider)new UMLMetaclassContentProvider(this.anyUmlElement));
        LabelProviderService serv = null;
        try {
            serv = (LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)this.anyUmlElement);
        }
        catch (ServiceException e) {
            Activator.log.error("Can't get LabelProviderService.", (Throwable)e);
        }
        ILabelProvider labelProvider = serv.getLabelProvider();
        selector.setLabelProvider(labelProvider);
        this.extendedMetaclassSelector = new MultipleValueSelectorWidget(parent, (IElementSelector)selector);
        this.extendedMetaclassSelector.setLabelProvider(labelProvider);
        this.extendedMetaclassSelector.setInitialElementSelections(this.selectedMetaclasses);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.m_bindingContext = this.initDataBindings();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Point getInitialSize() {
        return new Point(900, 900);
    }

    protected void okPressed() {
        this.collectInput();
        super.okPressed();
    }

    private void collectInput() {
        this.value = new StereotypeUpdateArgs();
        this.value.setProfileName(this.profileText.getText());
        this.value.setStereotypeName(this.stereotypeText.getText());
        ArrayList<Class> result = new ArrayList<Class>();
        Object[] objectArray = this.extendedMetaclassSelector.getResult();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            result.add((Class)obj);
            ++n2;
        }
        this.value.setExtendedMetaclasses(result);
        MetaclassesModel metaclassesModel = this.stereotypeModel.getMetaclassesCollection();
        Object[] objectArray2 = this.extendedMetaclassSelector.getResult();
        int n3 = objectArray2.length;
        n = 0;
        while (n < n3) {
            Object obj = objectArray2[n];
            metaclassesModel.getSelectedMetaclasses().add((Class)obj);
            ++n;
        }
    }

    public IStereotypeUpdateArgs getUpdateArgs() {
        return this.value;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextQuickSetTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.quickSetText);
        IObservableValue qualifiedNameStereotypeModelObserveValue = BeanProperties.value((String)"qualifiedName").observe((Object)this.stereotypeModel);
        bindingContext.bindValue((IObservableValue)observeTextQuickSetTextObserveWidget, qualifiedNameStereotypeModelObserveValue, null, null);
        ISWTObservableValue observeTextProfileTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.profileText);
        IObservableValue profileNameStereotypeModelObserveValue = BeanProperties.value((String)"profileName").observe((Object)this.stereotypeModel);
        bindingContext.bindValue((IObservableValue)observeTextProfileTextObserveWidget, profileNameStereotypeModelObserveValue, null, null);
        ISWTObservableValue observeTextStereotypeTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.stereotypeText);
        IObservableValue stereotypeNameStereotypeModelObserveValue = BeanProperties.value((String)"stereotypeName").observe((Object)this.stereotypeModel);
        bindingContext.bindValue((IObservableValue)observeTextStereotypeTextObserveWidget, stereotypeNameStereotypeModelObserveValue, null, null);
        return bindingContext;
    }

    public StereoptypeModel getStereotypeModel() {
        return this.stereotypeModel;
    }
}

