/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.propertyEditor.propertyTab;

import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.xtextService.core.utils.XtextElementsUtil;
import eu.fbk.eclipse.standardtools.xtextService.ui.utils.XTextEditorViewer;
import eu.fbk.eclipse.standardtools.xtextService.ui.utils.XTextEditorViewer_formalProperty;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class PropertyEditorTab
extends AbstractPropertySection {
    private static final Logger logger = Logger.getLogger(PropertyEditorTab.class);
    private Object formalProperty;
    private XTextEditorViewer_formalProperty xTextEditorViewer;
    private ISelectionChangedListener postTextChangedListener;
    private Text propertyNameLabel;
    private AbstractSystemModel systemModel = this.getSystemModel();
    private XtextElementsUtil xtextElementsUtil = XtextElementsUtil.getInstance((AbstractSystemModel)this.systemModel);
    private static final String staticPorts = "STATIC_PORTS";
    private static final String nonStaticPorts = "NON_STATIC_PORTS";
    private static final String unintFuncts = "UNINTERPRETED_FUNCTIONS";

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        Composite composite = this.createGUI(parent, aTabbedPropertySheetPage.getSite().getPage());
        this.xTextEditorViewer = new XTextEditorViewer_formalProperty(composite, 4);
        this.initEditorListener();
    }

    public void setInput(IWorkbenchPart part, ISelection sel) {
        logger.debug((Object)"setInput");
        XTextEditorViewer_formalProperty.setBooleanCheck((boolean)false);
        XTextEditorViewer.enableCheckOnVariables();
        this.cleanEditorView();
        Object formalProperty = this.returnProperty(sel);
        if (formalProperty != null) {
            this.formalProperty = formalProperty;
            this.propertyNameLabel.setText(this.systemModel.getAssertionQualifiedName(formalProperty));
            String strProperty = this.getStrFromProperty(formalProperty);
            if (strProperty != null) {
                this.xTextEditorViewer.setEditorText(this.getStrFromProperty(formalProperty));
            } else {
                this.xTextEditorViewer.setEditorText("");
            }
            Object component = this.systemModel.getNearestOwnerComponent(formalProperty);
            if (this.systemModel.isInterfaceAssertion(formalProperty)) {
                this.updateInterfaceAssertionPorts(component);
            } else if (this.systemModel.isRefinementAssertion(formalProperty)) {
                this.updateRefinementAssertionPorts(component);
            } else if (this.systemModel.isParameterAssumptions(formalProperty)) {
                this.updateParameterAssumptionsPorts(component);
            } else if (this.systemModel.isDefine(formalProperty)) {
                this.updateDefinePorts(component);
            }
        }
    }

    public abstract AbstractSystemModel getSystemModel();

    public abstract String getStrFromProperty(Object var1);

    public abstract Object returnProperty(ISelection var1);

    public abstract Resource getResourceFromProperty(Object var1);

    public abstract void propertyEditorchanged(Object var1, String var2);

    private void initEditorListener() {
        if (this.postTextChangedListener == null) {
            this.postTextChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (PropertyEditorTab.this.xTextEditorViewer.isEditorEditable()) {
                        String textChanged = PropertyEditorTab.this.xTextEditorViewer.getEditorText();
                        PropertyEditorTab.this.propertyEditorchanged(PropertyEditorTab.this.formalProperty, textChanged);
                        try {
                            PropertyEditorTab.this.xTextEditorViewer.showRuntimeErrors(textChanged, PropertyEditorTab.this.formalProperty, PropertyEditorTab.this.getResourceFromProperty(PropertyEditorTab.this.formalProperty));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
        }
        this.xTextEditorViewer.assignPostTextChangedListener(this.postTextChangedListener);
    }

    private void cleanEditorView() {
        this.propertyNameLabel.setText("no Constraint selected");
        this.xTextEditorViewer.cleanEditor();
    }

    private Composite createGUI(Composite parent, IWorkbenchPage page) {
        GridData gd;
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(4, false);
        composite.setLayout((Layout)compositeLayout);
        composite.setBackgroundMode(2);
        composite.setBackground(Display.getCurrent().getSystemColor(1));
        Object layoutData = parent.getLayoutData();
        if (layoutData != null && layoutData instanceof GridData) {
            gd = (GridData)layoutData;
            gd.grabExcessVerticalSpace = true;
            gd.verticalAlignment = 4;
        }
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 3;
        this.propertyNameLabel = new Text(composite, 0);
        this.propertyNameLabel.setText("no Property selected");
        this.propertyNameLabel.setEditable(false);
        this.propertyNameLabel.setLayoutData((Object)gd);
        gd = new GridData(4, 4, false, false);
        Label selectedPropertyLabel = new Label(composite, 0);
        selectedPropertyLabel.setText("Selected Property");
        selectedPropertyLabel.setLayoutData((Object)gd);
        selectedPropertyLabel.setBackground(Display.getCurrent().getSystemColor(1));
        return composite;
    }

    private void updateInterfaceAssertionPorts(Object component) {
        this.cleanAndUpdateComponentPortsAndParameters(component);
        this.cleanAndUpdateComponentEnums(component);
        this.cleanAndUpdateComponentDefines(component);
    }

    private void updateParameterAssumptionsPorts(Object component) {
        this.cleanAndUpdateComponentPortsAndParameters(component);
        this.cleanAndUpdateComponentEnums(component);
        this.cleanAndUpdateComponentDefines(component);
    }

    private void updateRefinementAssertionPorts(Object component) {
        this.cleanAndUpdateComponentPortsAndParameters(component);
        this.updateSubComponentsPortsAndParameters(component);
        this.cleanAndUpdateComponentAndSubComponentsEnums(component);
        this.cleanAndUpdateComponentDefines(component);
    }

    private void updateDefinePorts(Object component) {
        this.cleanAndUpdateComponentPortsAndParameters(component);
        this.cleanAndUpdateComponentEnums(component);
        this.cleanAndUpdateComponentDefines(component);
    }

    private void cleanAndUpdateComponentEnums(Object component) {
        XTextEditorViewer_formalProperty.cleanEnumValues();
        EList enumValues = this.systemModel.getEnumValuesFromAttributes(component);
        if (enumValues != null) {
            XTextEditorViewer_formalProperty.addEnumValues((String[])((String[])enumValues.toArray((Object[])new String[0])));
        }
    }

    private void cleanAndUpdateComponentDefines(Object component) {
        XTextEditorViewer_formalProperty.cleanDefines();
        XTextEditorViewer_formalProperty.addDefines((String[])((String[])this.xtextElementsUtil.getXTextDefinesNamesFromComponent(component).toArray((Object[])new String[0])));
    }

    private void cleanAndUpdateComponentAndSubComponentsEnums(Object component) {
        XTextEditorViewer_formalProperty.cleanEnumValues();
        EList enumValues = this.systemModel.getEnumValuesFromAttributes(component);
        HashSet<String> componentsAndsubComponentsEnumValues = new HashSet<String>((Collection<String>)enumValues);
        EList subComponentInstances = this.systemModel.getSubComponentsInstances(component);
        for (Object subComponentInstance : subComponentInstances) {
            this.compileDescendanceEnumValues(subComponentInstance, componentsAndsubComponentsEnumValues);
        }
        if (componentsAndsubComponentsEnumValues != null) {
            XTextEditorViewer_formalProperty.addEnumValues((String[])componentsAndsubComponentsEnumValues.toArray(new String[0]));
        }
    }

    private void compileDescendanceEnumValues(Object componentInstance, Set<String> subComponentEnumValues) {
        EList componentEnumValues = this.systemModel.getEnumValues(componentInstance);
        subComponentEnumValues.addAll((Collection<String>)componentEnumValues);
        EList subComponentInstances = this.systemModel.getSubComponentsInstances(componentInstance);
        for (Object subComponentInstance : subComponentInstances) {
            this.compileDescendanceEnumValues(subComponentInstance, subComponentEnumValues);
        }
    }

    private void cleanAndUpdateComponentPortsAndParameters(Object component) {
        XTextEditorViewer.cleanPorts();
        XTextEditorViewer.addPorts((EList)this.xtextElementsUtil.getXTextPortsFromComponent(component));
        XTextEditorViewer.cleanParameters();
        XTextEditorViewer.addParameters((EList)this.xtextElementsUtil.getXTextParametersFromComponent(component));
    }

    private void updateSubComponentsPortsAndParameters(Object component) {
        EList subComponentInstances = this.systemModel.getSubComponentsInstances(component);
        HashMap mapComponentInstance_NameNonStaticPorts = new HashMap();
        for (Object subComponentInstance : subComponentInstances) {
            this.compileDescendanceNamesAndNonStaticPorts(subComponentInstance, null, mapComponentInstance_NameNonStaticPorts);
        }
        logger.debug((Object)("mapComponentInstance_NamePorts.entrySet(): " + mapComponentInstance_NameNonStaticPorts.entrySet().size()));
        for (Map.Entry<Map.Entry<String, String>, EList<?>> entryComponentInstance_NamePorts : mapComponentInstance_NameNonStaticPorts.entrySet()) {
            Map.Entry<String, String> componentNamePortType = entryComponentInstance_NamePorts.getKey();
            EList<?> ports = entryComponentInstance_NamePorts.getValue();
            String componentName = componentNamePortType.getKey();
            String portType = componentNamePortType.getValue();
            if (portType.compareTo(nonStaticPorts) == 0) {
                XTextEditorViewer_formalProperty.addPorts((String)componentName, (EList)this.xtextElementsUtil.getXTextPorts(ports));
                continue;
            }
            if (portType.compareTo(staticPorts) == 0) {
                XTextEditorViewer_formalProperty.addParameters((String)componentName, (EList)this.xtextElementsUtil.getXTextParametersFromStaticPorts(ports));
                continue;
            }
            if (portType.compareTo(unintFuncts) != 0) continue;
            XTextEditorViewer_formalProperty.addParameters((String)componentName, (EList)this.xtextElementsUtil.getXTextParametersFromUninterpretedFunctions(ports));
        }
    }

    private void compileDescendanceNamesAndNonStaticPorts(Object componentInstance, String prefixOwnerComponentInstanceName, HashMap<Map.Entry<String, String>, EList<?>> mapComponentInstance_NamePorts) {
        EList componentUnintFuncts;
        EList componentStaticPorts;
        String componentInstanceName = this.systemModel.getComponentInstanceName(componentInstance);
        String fullComponentInstanceName = prefixOwnerComponentInstanceName != null ? String.valueOf(prefixOwnerComponentInstanceName) + "." + componentInstanceName : componentInstanceName;
        EList componentNonStaticPorts = this.systemModel.getNonStaticPorts(componentInstance);
        if (componentNonStaticPorts != null && componentNonStaticPorts.size() != 0) {
            AbstractMap.SimpleEntry<String, String> componentNameNonStaticPort = new AbstractMap.SimpleEntry<String, String>(fullComponentInstanceName, nonStaticPorts);
            mapComponentInstance_NamePorts.put(componentNameNonStaticPort, componentNonStaticPorts);
        }
        if ((componentStaticPorts = this.systemModel.getStaticPorts(componentInstance)) != null && componentStaticPorts.size() != 0) {
            AbstractMap.SimpleEntry<String, String> componentNameStaticPort = new AbstractMap.SimpleEntry<String, String>(fullComponentInstanceName, staticPorts);
            mapComponentInstance_NamePorts.put(componentNameStaticPort, componentStaticPorts);
        }
        if ((componentUnintFuncts = this.systemModel.getUninterpretedFunctions(componentInstance)) != null && componentUnintFuncts.size() != 0) {
            AbstractMap.SimpleEntry<String, String> componentNameUnintFuncts = new AbstractMap.SimpleEntry<String, String>(fullComponentInstanceName, unintFuncts);
            mapComponentInstance_NamePorts.put(componentNameUnintFuncts, componentUnintFuncts);
        }
        for (Object subComponent : this.systemModel.getSubComponentsInstances(componentInstance)) {
            this.compileDescendanceNamesAndNonStaticPorts(subComponent, fullComponentInstanceName, mapComponentInstance_NamePorts);
        }
    }
}

