/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.transformations.commands;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.services.markerlistener.util.MarkerListenerUtils;
import org.eclipse.papyrus.infra.services.validation.ValidationTool;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.uml2.uml.Model;
import org.polarsys.chess.contracts.transformations.commands.CommandsCommon;
import org.polarsys.chess.contracts.transformations.dialogs.SelectOcraAnalysisCtxDialog;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.validator.command.ChessGenericValidateCommand;

public class CHESSContractValidateAndRefineCommand
extends ChessGenericValidateCommand {
    private String systemQN;
    private Shell activeShell;
    private Boolean checkWeakContracts;
    private PapyrusMultiDiagramEditor editor;

    public CHESSContractValidateAndRefineCommand(String label, String pluginId, EObject selectedElement) {
        super(label, pluginId, selectedElement);
    }

    public void setEditor(PapyrusMultiDiagramEditor editor) {
        this.editor = editor;
    }

    public void setActiveShell(Shell activeShell) {
        this.activeShell = activeShell;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleDiagnostic(IProgressMonitor monitor, Diagnostic diagnostic, EObject validateElement, Shell shell) {
        Resource resource = this.getValidationResource();
        if (resource == null) return;
        if (this.selectedElement != null) {
            ValidationTool vt = new ValidationTool(this.selectedElement);
            vt.deleteSubMarkers();
        }
        boolean marker = false;
        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
            if (!this.pluginIds.contains(childDiagnostic.getSource())) continue;
            MarkerListenerUtils.eclipseResourcesUtil.createMarkers(resource, childDiagnostic);
            marker = true;
        }
        boolean go = false;
        if (marker) {
            go = MessageDialog.openQuestion((Shell)this.activeShell, (String)"Validation Problems", (String)"Errors found while validating the Model. Check Refinement Analysis won't be performed correctly. Do you still want to continue?");
            if (!go) return;
            this.performRefinement();
            return;
        } else {
            this.performRefinement();
        }
    }

    private void performRefinement() {
        String modelname;
        block4: {
            try {
                Resource res = ResourceUtils.getUMLResource((ServicesRegistry)this.editor.getServicesRegistry());
                Model model = ResourceUtils.getModel((Resource)res);
                modelname = model.getName();
                SelectOcraAnalysisCtxDialog dialog = new SelectOcraAnalysisCtxDialog(this.activeShell, model);
                dialog.create();
                if (dialog.open() == 0) {
                    this.systemQN = dialog.getSystem();
                    this.checkWeakContracts = dialog.getCheckWeakContracts();
                    if (this.systemQN == null || this.systemQN.isEmpty()) {
                        return;
                    }
                    break block4;
                }
                return;
            }
            catch (ServiceException e) {
                e.printStackTrace();
                return;
            }
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.systemQN);
        String systemName = this.systemQN.substring(this.systemQN.lastIndexOf("::") + 2);
        args.add(systemName);
        args.add(modelname);
        args.add(this.checkWeakContracts.toString());
        CommandsCommon.TransformationJob(this.activeShell, (IEditorPart)this.editor, args, CommandsCommon.CommandEnum.REFINEMENT, null, null);
    }
}

