/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.transformations.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StateMachine;

public class SelectImplementationDialog
extends Dialog {
    private org.eclipse.swt.widgets.List blockList;
    private Class startingSystem;
    private String block;
    private List<Class> leafsList;

    public SelectImplementationDialog(Shell parentShell, Class sysClass) {
        super(parentShell);
        this.startingSystem = sysClass;
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        layout.marginBottom = 5;
        layout.marginTop = 5;
        parent.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        this.blockList = new org.eclipse.swt.widgets.List(parent, 2560);
        this.leafsList = this.getLeafs(this.startingSystem, new ArrayList<Class>());
        for (Class leaf : this.leafsList) {
            this.blockList.add(leaf.getQualifiedName());
        }
        this.blockList.setLayoutData((Object)gridData);
        new Label(parent, 0).setText("");
        return parent;
    }

    private List<Class> getLeafs(Class block, List<Class> result) {
        List<Class> children = this.getChildren(block);
        if (children.size() > 0) {
            for (Class cl : children) {
                this.getLeafs(cl, result);
            }
        } else {
            boolean test = false;
            for (Behavior behavior : block.getOwnedBehaviors()) {
                if (!(behavior instanceof StateMachine)) continue;
                test = true;
            }
            if (test) {
                result.add(block);
            }
        }
        return result;
    }

    private List<Class> getChildren(Class block) {
        ArrayList<Class> result = new ArrayList<Class>();
        for (Element elem : block.allOwnedElements()) {
            Class cl;
            Property prop;
            if (!(elem instanceof Property) || elem instanceof Port || !(prop = (Property)elem).getAggregation().toString().equals("composite") || result.contains(cl = (Class)prop.getType())) continue;
            result.add(cl);
        }
        return result;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Select the Block or Component to be Analyzed");
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        if (this.blockList.getSelectionCount() == 1) {
            this.setBlock(this.blockList.getSelection()[0]);
        }
        super.okPressed();
    }

    public String getBlock() {
        return this.block;
    }

    public void setBlock(String block) {
        this.block = block;
    }
}

