/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.dnd.strategy;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.dnd.Activator;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.AbstractDropStrategy;

public abstract class TransactionalDropStrategy
extends AbstractDropStrategy {
    public Command getCommand(Request request, EditPart targetEditPart) {
        final Command command = this.doGetCommand(request, targetEditPart);
        if (command == null) {
            return null;
        }
        String label = command.getLabel();
        if (label == null || "".equals(label)) {
            label = this.getLabel();
        }
        AbstractTransactionalCommand transactionalCommand = new AbstractTransactionalCommand(this.getTransactionalEditingDomain(targetEditPart), label, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                try {
                    command.execute();
                    return CommandResult.newOKCommandResult();
                }
                catch (Exception ex) {
                    Activator.log.error((Throwable)ex);
                    return CommandResult.newErrorCommandResult((Throwable)ex);
                }
            }
        };
        return new ICommandProxy((ICommand)transactionalCommand);
    }

    protected boolean isTransactional(EditPart targetEditPart) {
        return this.getTransactionalEditingDomain(targetEditPart) != null;
    }

    protected TransactionalEditingDomain getTransactionalEditingDomain(EditPart targetEditPart) {
        EditingDomain domain = this.getEditingDomain(targetEditPart);
        if (domain instanceof TransactionalEditingDomain) {
            return (TransactionalEditingDomain)domain;
        }
        return null;
    }

    protected EditingDomain getEditingDomain(EditPart targetEditPart) {
        return EMFHelper.resolveEditingDomain((Object)targetEditPart);
    }

    protected abstract Command doGetCommand(Request var1, EditPart var2);
}

