/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction0;
import org.eclipse.collections.api.block.function.primitive.ShortShortToShortFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToShortFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortShortPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.factory.primitive.ShortShortMaps;
import org.eclipse.collections.api.iterator.MutableShortIterator;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.map.primitive.ImmutableShortShortMap;
import org.eclipse.collections.api.map.primitive.MutableShortShortMap;
import org.eclipse.collections.api.map.primitive.ShortShortMap;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.set.primitive.ShortSet;
import org.eclipse.collections.api.tuple.primitive.ShortShortPair;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.iterator.UnmodifiableShortIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyShortIterable;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableShortKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableShortValuesMap;
import org.eclipse.collections.impl.map.mutable.primitive.ImmutableShortShortMapKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.MutableShortKeysMap;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedShortShortMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableShortShortMap;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class ShortShortHashMap
extends AbstractMutableShortValuesMap
implements MutableShortShortMap,
Externalizable,
MutableShortKeysMap {
    private static final short EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final short EMPTY_KEY = 0;
    private static final short REMOVED_KEY = 1;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 2;
    private static final int INITIAL_LINEAR_PROBE = 16;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private short[] keysValues;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableShortValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public ShortShortHashMap() {
        this.allocateTable(16);
    }

    public ShortShortHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public ShortShortHashMap(ShortShortMap map) {
        if (map instanceof ShortShortHashMap && ((ShortShortHashMap)map).occupiedWithSentinels == 0) {
            ShortShortHashMap hashMap = (ShortShortHashMap)map;
            this.occupiedWithData = hashMap.occupiedWithData;
            if (hashMap.sentinelValues != null) {
                this.sentinelValues = hashMap.sentinelValues.copy();
            }
            this.keysValues = Arrays.copyOf(hashMap.keysValues, hashMap.keysValues.length);
        } else {
            int capacity = this.smallestPowerOfTwoGreaterThan(Math.max(map.size(), 8) << 1);
            this.allocateTable(capacity);
            this.putAll(map);
        }
    }

    public static ShortShortHashMap newWithKeysValues(short key1, short value1) {
        return new ShortShortHashMap(1).withKeyValue(key1, value1);
    }

    public static ShortShortHashMap newWithKeysValues(short key1, short value1, short key2, short value2) {
        return new ShortShortHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static ShortShortHashMap newWithKeysValues(short key1, short value1, short key2, short value2, short key3, short value3) {
        return new ShortShortHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static ShortShortHashMap newWithKeysValues(short key1, short value1, short key2, short value2, short key3, short value3, short key4, short value4) {
        return new ShortShortHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableShortValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected short getEmptyValue() {
        return 0;
    }

    @Override
    protected int getTableSize() {
        return this.keysValues.length / 2;
    }

    @Override
    protected short getValueAtIndex(int index) {
        return this.keysValues[index * 2 + 1];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShortShortMap)) {
            return false;
        }
        ShortShortMap other = (ShortShortMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey((short)0) || other.containsKey((short)1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey((short)0) || this.sentinelValues.zeroValue != other.getOrThrow((short)0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey((short)1) || this.sentinelValues.oneValue != other.getOrThrow((short)1))) {
                return false;
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            short key = this.keysValues[i];
            if (!ShortShortHashMap.isNonSentinel(key) || other.containsKey(key) && this.keysValues[i + 1] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ShortShortHashMap.isNonSentinel(this.keysValues[i])) continue;
            result += this.keysValues[i] ^ this.keysValues[i + 1];
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            short key = this.keysValues[i];
            if (!ShortShortHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.keysValues[i + 1]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public MutableShortIterator shortIterator() {
        return new InternalShortIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectShortToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ShortShortHashMap.isNonSentinel(this.keysValues[i])) continue;
            result = function.valueOf(result, this.keysValues[i + 1]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keysValues, (short)0);
    }

    public void put(short key, short value) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        short keyAtIndex = this.keysValues[index];
        if (keyAtIndex == key) {
            this.keysValues[index + 1] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(short value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(short value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    public void putAll(ShortShortMap map) {
        map.forEachKeyValue(this::put);
    }

    public void updateValues(ShortShortToShortFunction function) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ShortShortHashMap.isNonSentinel(this.keysValues[i])) continue;
            this.keysValues[i + 1] = function.valueOf(this.keysValues[i], this.keysValues[i + 1]);
        }
    }

    @Override
    public void removeKey(short key) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            this.removeKeyAtIndex(index);
        }
    }

    public void remove(short key) {
        this.removeKey(key);
    }

    public short removeKeyIfAbsent(short key, short value) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            short oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            short oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            short oldValue = this.keysValues[index + 1];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    public short getIfAbsentPut(short key, short value) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short getAndPut(short key, short putValue, short defaultValue) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
            } else if (this.sentinelValues.containsZeroKey) {
                short existingValue = this.sentinelValues.zeroValue;
                this.sentinelValues.zeroValue = putValue;
                return existingValue;
            }
            this.addEmptyKeyValue(putValue);
            return defaultValue;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
            } else if (this.sentinelValues.containsOneKey) {
                short existingValue = this.sentinelValues.oneValue;
                this.sentinelValues.oneValue = putValue;
                return existingValue;
            }
            this.addRemovedKeyValue(putValue);
            return defaultValue;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            short existingValue = this.keysValues[index + 1];
            this.keysValues[index + 1] = putValue;
            return existingValue;
        }
        this.addKeyValueAtIndex(key, putValue, index);
        return defaultValue;
    }

    public short getIfAbsentPut(short key, ShortFunction0 function) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.value();
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.value();
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        short value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> short getIfAbsentPutWith(short key, ShortFunction<? super P> function, P parameter) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.shortValueOf(parameter);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.shortValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.shortValueOf(parameter);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.shortValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        short value = function.shortValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short getIfAbsentPutWithKey(short key, ShortToShortFunction function) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        short value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short addToValue(short key, short toBeAdded) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = (short)(this.sentinelValues.zeroValue + toBeAdded);
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = (short)(this.sentinelValues.oneValue + toBeAdded);
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            int n = index + 1;
            this.keysValues[n] = (short)(this.keysValues[n] + toBeAdded);
            return this.keysValues[index + 1];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    private void addKeyValueAtIndex(short key, short value, int index) {
        if (this.keysValues[index] == 1) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keysValues[index] = key;
        this.keysValues[index + 1] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keysValues[index] = 1;
        this.keysValues[index + 1] = 0;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        short[] copy = new short[this.keysValues.length];
        System.arraycopy(this.keysValues, 0, copy, 0, this.keysValues.length);
        this.keysValues = copy;
        this.copyKeysOnWrite = false;
    }

    public short updateValue(short key, short initialValueIfAbsent, ShortToShortFunction function) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            this.keysValues[index + 1] = function.valueOf(this.keysValues[index + 1]);
            return this.keysValues[index + 1];
        }
        short value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public ShortShortHashMap withKeyValue(short key1, short value1) {
        this.put(key1, value1);
        return this;
    }

    public ShortShortHashMap withKeysValues(short key1, short value1, short key2, short value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ShortShortHashMap withKeysValues(short key1, short value1, short key2, short value2, short key3, short value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ShortShortHashMap withKeysValues(short key1, short value1, short key2, short value2, short key3, short value3, short key4, short value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public ShortShortHashMap withoutKey(short key) {
        this.removeKey(key);
        return this;
    }

    public ShortShortHashMap withoutAllKeys(ShortIterable keys) {
        keys.forEach(this::removeKey);
        return this;
    }

    public MutableShortShortMap asUnmodifiable() {
        return new UnmodifiableShortShortMap(this);
    }

    public MutableShortShortMap asSynchronized() {
        return new SynchronizedShortShortMap(this);
    }

    public ImmutableShortShortMap toImmutable() {
        return ShortShortMaps.immutable.ofAll((ShortShortMap)this);
    }

    public short get(short key) {
        return this.getIfAbsent(key, (short)0);
    }

    public short getIfAbsent(short key, short ifAbsent) {
        if (ShortShortHashMap.isEmptyKey(key) || ShortShortHashMap.isRemovedKey(key)) {
            return this.getForSentinel(key, ifAbsent);
        }
        if (this.occupiedWithSentinels == 0) {
            return this.fastGetIfAbsent(key, ifAbsent);
        }
        return this.slowGetIfAbsent(key, ifAbsent);
    }

    private short getForSentinel(short key, short ifAbsent) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
            return ifAbsent;
        }
        return this.sentinelValues.oneValue;
    }

    private short slowGetIfAbsent(short key, short ifAbsent) {
        int index = this.probe(key);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        return ifAbsent;
    }

    private short fastGetIfAbsent(short key, short ifAbsent) {
        int index = this.mask(key) << 1;
        for (int i = 0; i < 16; i += 2) {
            short keyAtIndex = this.keysValues[index];
            if (keyAtIndex == key) {
                return this.keysValues[index + 1];
            }
            if (keyAtIndex == 0) {
                return ifAbsent;
            }
            index = index + 2 & this.keysValues.length - 1;
        }
        return this.slowGetIfAbsentTwo(key, ifAbsent);
    }

    private short slowGetIfAbsentTwo(short key, short ifAbsent) {
        int index = this.probeTwo(key, -1);
        if (this.keysValues[index] == key) {
            return this.keysValues[index + 1];
        }
        return ifAbsent;
    }

    public short getOrThrow(short key) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (ShortShortHashMap.isNonSentinel(this.keysValues[index])) {
            return this.keysValues[index + 1];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(short key) {
        if (ShortShortHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (ShortShortHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keysValues[this.probe(key)] == key;
    }

    @Override
    public void forEachKey(ShortProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((short)0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((short)1);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ShortShortHashMap.isNonSentinel(this.keysValues[i])) continue;
            procedure.value(this.keysValues[i]);
        }
    }

    public void forEachKeyValue(ShortShortProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ShortShortHashMap.isNonSentinel(this.keysValues[i])) continue;
            procedure.value(this.keysValues[i], this.keysValues[i + 1]);
        }
    }

    public boolean allSatisfyKeyValue(ShortShortPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept((short)0, this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept((short)1, this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ShortShortHashMap.isNonSentinel(this.keysValues[i]) || predicate.accept(this.keysValues[i], this.keysValues[i + 1])) continue;
            return false;
        }
        return true;
    }

    public LazyShortIterable keysView() {
        return new KeysView();
    }

    public RichIterable<ShortShortPair> keyValuesView() {
        return new KeyValuesView();
    }

    public MutableShortShortMap flipUniqueValues() {
        MutableShortShortMap result = ShortShortMaps.mutable.empty();
        this.forEachKeyValue((ShortShortProcedure & Serializable)(key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result;
    }

    public ShortShortHashMap select(ShortShortPredicate predicate) {
        ShortShortHashMap result = new ShortShortHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept((short)0, this.sentinelValues.zeroValue)) {
                result.put((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept((short)1, this.sentinelValues.oneValue)) {
                result.put((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ShortShortHashMap.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i], this.keysValues[i + 1])) continue;
            result.put(this.keysValues[i], this.keysValues[i + 1]);
        }
        return result;
    }

    public ShortShortHashMap reject(ShortShortPredicate predicate) {
        ShortShortHashMap result = new ShortShortHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept((short)0, this.sentinelValues.zeroValue)) {
                result.put((short)0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept((short)1, this.sentinelValues.oneValue)) {
                result.put((short)1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ShortShortHashMap.isNonSentinel(this.keysValues[i]) || predicate.accept(this.keysValues[i], this.keysValues[i + 1])) continue;
            result.put(this.keysValues[i], this.keysValues[i + 1]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeShort(0);
                out.writeShort(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeShort(1);
                out.writeShort(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ShortShortHashMap.isNonSentinel(this.keysValues[i])) continue;
            out.writeShort(this.keysValues[i]);
            out.writeShort(this.keysValues[i + 1]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readShort(), in.readShort());
        }
    }

    public boolean trimToSize() {
        int newCapacity = this.smallestPowerOfTwoGreaterThan(this.size());
        if (this.keysValues.length > newCapacity) {
            this.rehash(newCapacity);
            return true;
        }
        return false;
    }

    @Deprecated
    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max = this.maxOccupiedWithData();
        int newCapacity = Math.max(max, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max >> 1) + (max >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keysValues.length;
        short[] old = this.keysValues;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; i += 2) {
            if (!ShortShortHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], old[i + 1]);
        }
    }

    int probe(short element) {
        int index = this.mask(element) << 1;
        short keyAtIndex = this.keysValues[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        for (int i = 2; i < 16; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            keyAtIndex = this.keysValues[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(short element, int removedIndex) {
        int index = this.spreadTwoAndMask(element) << 1;
        for (int i = 0; i < 16; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            short keyAtIndex = this.keysValues[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(short element, int removedIndex) {
        int nextIndex = SpreadFunctions.shortSpreadOne(element) << 1;
        int spreadTwo = Integer.reverse(SpreadFunctions.shortSpreadTwo(element)) | 1;
        short keyAtIndex;
        while ((keyAtIndex = this.keysValues[nextIndex = this.mask((nextIndex >> 1) + spreadTwo) << 1]) != element) {
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(short element) {
        int code = SpreadFunctions.shortSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(short element) {
        int code = SpreadFunctions.shortSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & (this.keysValues.length >> 1) - 1;
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keysValues = new short[sizeToAllocate << 1];
    }

    private static boolean isEmptyKey(short key) {
        return key == 0;
    }

    private static boolean isRemovedKey(short key) {
        return key == 1;
    }

    private static boolean isNonSentinel(short key) {
        return !ShortShortHashMap.isEmptyKey(key) && !ShortShortHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !ShortShortHashMap.isEmptyKey(this.keysValues[index * 2]) && !ShortShortHashMap.isRemovedKey(this.keysValues[index * 2]);
    }

    private int maxOccupiedWithData() {
        return this.keysValues.length >> 2;
    }

    public MutableShortSet keySet() {
        return new KeySet();
    }

    public MutableShortCollection values() {
        return new ValuesCollection();
    }

    private class KeyValuesView
    extends AbstractLazyIterable<ShortShortPair> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super ShortShortPair> procedure) {
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair((short)0, ShortShortHashMap.this.sentinelValues.zeroValue));
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair((short)1, ShortShortHashMap.this.sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < ShortShortHashMap.this.keysValues.length; i += 2) {
                if (!ShortShortHashMap.isNonSentinel(ShortShortHashMap.this.keysValues[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(ShortShortHashMap.this.keysValues[i], ShortShortHashMap.this.keysValues[i + 1]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ShortShortPair> objectIntProcedure) {
            int index = 0;
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair((short)0, ShortShortHashMap.this.sentinelValues.zeroValue), index);
                    ++index;
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair((short)1, ShortShortHashMap.this.sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < ShortShortHashMap.this.keysValues.length; i += 2) {
                if (!ShortShortHashMap.isNonSentinel(ShortShortHashMap.this.keysValues[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(ShortShortHashMap.this.keysValues[i], ShortShortHashMap.this.keysValues[i + 1]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ShortShortPair, ? super P> procedure, P parameter) {
            if (ShortShortHashMap.this.sentinelValues != null) {
                if (ShortShortHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair((short)0, ShortShortHashMap.this.sentinelValues.zeroValue), parameter);
                }
                if (ShortShortHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair((short)1, ShortShortHashMap.this.sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < ShortShortHashMap.this.keysValues.length; i += 2) {
                if (!ShortShortHashMap.isNonSentinel(ShortShortHashMap.this.keysValues[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(ShortShortHashMap.this.keysValues[i], ShortShortHashMap.this.keysValues[i + 1]), parameter);
            }
        }

        public Iterator<ShortShortPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<ShortShortPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public ShortShortPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (ShortShortHashMap.this.containsKey((short)0)) {
                        return PrimitiveTuples.pair((short)0, ShortShortHashMap.this.sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (ShortShortHashMap.this.containsKey((short)1)) {
                        return PrimitiveTuples.pair((short)1, ShortShortHashMap.this.sentinelValues.oneValue);
                    }
                }
                short[] keys = ShortShortHashMap.this.keysValues;
                while (!ShortShortHashMap.isNonSentinel(keys[this.position])) {
                    this.position += 2;
                }
                ShortShortPair result = PrimitiveTuples.pair(keys[this.position], ShortShortHashMap.this.keysValues[this.position + 1]);
                this.position += 2;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ShortShortHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    extends AbstractMutableShortValuesMap.AbstractShortValuesCollection {
        private ValuesCollection() {
        }

        public MutableShortIterator shortIterator() {
            return ShortShortHashMap.this.shortIterator();
        }

        public boolean remove(short item) {
            int oldSize = ShortShortHashMap.this.size();
            if (ShortShortHashMap.this.sentinelValues != null && ShortShortHashMap.this.sentinelValues.containsZeroKey && item == ShortShortHashMap.this.sentinelValues.zeroValue) {
                ShortShortHashMap.this.removeKey((short)0);
            }
            if (ShortShortHashMap.this.sentinelValues != null && ShortShortHashMap.this.sentinelValues.containsOneKey && item == ShortShortHashMap.this.sentinelValues.oneValue) {
                ShortShortHashMap.this.removeKey((short)1);
            }
            for (int i = 0; i < ShortShortHashMap.this.keysValues.length; i += 2) {
                if (!ShortShortHashMap.isNonSentinel(ShortShortHashMap.this.keysValues[i]) || item != ShortShortHashMap.this.keysValues[i + 1]) continue;
                ShortShortHashMap.this.removeKey(ShortShortHashMap.this.keysValues[i]);
            }
            return oldSize != ShortShortHashMap.this.size();
        }

        public boolean retainAll(ShortIterable source) {
            int oldSize = ShortShortHashMap.this.size();
            Object sourceSet = source instanceof ShortSet ? (ShortSet)source : source.toSet();
            ShortShortHashMap retained = ShortShortHashMap.this.select((arg_0, arg_1) -> ValuesCollection.lambda$retainAll$ffe259f6$1((ShortSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                ShortShortHashMap.this.keysValues = retained.keysValues;
                ShortShortHashMap.this.sentinelValues = retained.sentinelValues;
                ShortShortHashMap.this.occupiedWithData = retained.occupiedWithData;
                ShortShortHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public MutableShortCollection newEmpty() {
            return new ShortHashBag();
        }

        private static /* synthetic */ boolean lambda$retainAll$ffe259f6$1(ShortSet sourceSet, short key, short value) {
            return sourceSet.contains(value);
        }
    }

    private class KeySet
    extends AbstractMutableShortKeySet {
        private KeySet() {
        }

        @Override
        protected MutableShortKeysMap getOuter() {
            return ShortShortHashMap.this;
        }

        @Override
        protected AbstractMutableShortValuesMap.SentinelValues getSentinelValues() {
            return ShortShortHashMap.this.sentinelValues;
        }

        @Override
        protected short getKeyAtIndex(int index) {
            return ShortShortHashMap.this.keysValues[index * 2];
        }

        @Override
        protected int getTableSize() {
            return ShortShortHashMap.this.keysValues.length / 2;
        }

        public MutableShortIterator shortIterator() {
            return new KeySetIterator();
        }

        public boolean retainAll(ShortIterable source) {
            int oldSize = ShortShortHashMap.this.size();
            Object sourceSet = source instanceof ShortSet ? (ShortSet)source : source.toSet();
            ShortShortHashMap retained = ShortShortHashMap.this.select((arg_0, arg_1) -> KeySet.lambda$retainAll$ffe259f6$1((ShortSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                ShortShortHashMap.this.keysValues = retained.keysValues;
                ShortShortHashMap.this.sentinelValues = retained.sentinelValues;
                ShortShortHashMap.this.occupiedWithData = retained.occupiedWithData;
                ShortShortHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(short ... source) {
            return this.retainAll(ShortHashSet.newSetWith(source));
        }

        public ShortSet freeze() {
            ShortShortHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (ShortShortHashMap.this.sentinelValues != null) {
                containsZeroKey = ShortShortHashMap.this.sentinelValues.containsZeroKey;
                containsOneKey = ShortShortHashMap.this.sentinelValues.containsOneKey;
            }
            return new ImmutableShortShortMapKeySet(ShortShortHashMap.this.keysValues, ShortShortHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }

        public MutableShortSet newEmpty() {
            return new ShortHashSet();
        }

        private static /* synthetic */ boolean lambda$retainAll$ffe259f6$1(ShortSet sourceSet, short key, short value) {
            return sourceSet.contains(key);
        }
    }

    private class KeySetIterator
    implements MutableShortIterator {
        private int count;
        private int position;
        private short lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < ShortShortHashMap.this.size();
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ShortShortHashMap.this.containsKey((short)0)) {
                    this.lastKey = 0;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ShortShortHashMap.this.containsKey((short)1)) {
                    this.lastKey = 1;
                    return this.lastKey;
                }
            }
            short[] keys = ShortShortHashMap.this.keysValues;
            while (!ShortShortHashMap.isNonSentinel(keys[this.position])) {
                this.position += 2;
            }
            this.lastKey = keys[this.position];
            this.position += 2;
            return this.lastKey;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            ShortShortHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyShortIterable {
        private KeysView() {
        }

        public ShortIterator shortIterator() {
            return new UnmodifiableShortIterator((ShortIterator)new KeySetIterator());
        }

        public void each(ShortProcedure procedure) {
            ShortShortHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalShortIterator
    implements MutableShortIterator {
        private int count;
        private int position;
        private short lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalShortIterator() {
        }

        public boolean hasNext() {
            return this.count < ShortShortHashMap.this.size();
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ShortShortHashMap.this.containsKey((short)0)) {
                    this.lastKey = 0;
                    return ShortShortHashMap.this.get((short)0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ShortShortHashMap.this.containsKey((short)1)) {
                    this.lastKey = 1;
                    return ShortShortHashMap.this.get((short)1);
                }
            }
            short[] keys = ShortShortHashMap.this.keysValues;
            while (!ShortShortHashMap.isNonSentinel(keys[this.position])) {
                this.position += 2;
            }
            this.lastKey = keys[this.position];
            short result = ShortShortHashMap.this.keysValues[this.position + 1];
            this.position += 2;
            return result;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            ShortShortHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

