/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.RandomAccess;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.impl.list.mutable.AbstractMutableList;
import org.eclipse.collections.impl.utility.Iterate;

public class BoxedMutableFloatList
extends AbstractMutableList<Float>
implements MutableList<Float>,
RandomAccess {
    private final MutableFloatList delegate;

    public BoxedMutableFloatList(MutableFloatList delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean add(Float item) {
        return this.delegate.add(item.floatValue());
    }

    public boolean addAll(int index, Collection<? extends Float> c) {
        float[] target = new float[c.size()];
        Iterate.forEachWithIndex(c, (ObjectIntProcedure & Serializable)(each, parameter) -> {
            target[parameter] = each.floatValue();
        });
        return this.delegate.addAllAtIndex(index, target);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    public Float get(int index) {
        return Float.valueOf(this.delegate.get(index));
    }

    public Float set(int index, Float element) {
        return Float.valueOf(this.delegate.set(index, element.floatValue()));
    }

    public void add(int index, Float element) {
        this.delegate.addAtIndex(index, element.floatValue());
    }

    public Float remove(int index) {
        return Float.valueOf(this.delegate.removeAtIndex(index));
    }

    @Override
    public int indexOf(Object o) {
        return o instanceof Float ? this.delegate.indexOf(((Float)o).floatValue()) : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return o instanceof Float ? this.delegate.lastIndexOf(((Float)o).floatValue()) : -1;
    }

    @Override
    public MutableList<Float> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex).boxed();
    }
}

