/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.Function3;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.partition.list.PartitionMutableList;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.Twin;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.block.factory.HashingStrategies;
import org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.list.FastListMultimap;
import org.eclipse.collections.impl.partition.list.PartitionFastList;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.strategy.mutable.UnifiedSetWithHashingStrategy;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.ListIterate;
import org.eclipse.collections.impl.utility.internal.InternalArrayIterate;
import org.eclipse.collections.impl.utility.internal.RandomAccessListIterate;

public final class ArrayListIterate {
    private static final Field ELEMENT_DATA_FIELD;
    private static final Field SIZE_FIELD;
    private static final int MIN_DIRECT_ARRAY_ACCESS_SIZE = 100;

    private ArrayListIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> ArrayList<T> select(ArrayList<T> list, Predicate<? super T> predicate) {
        return ArrayListIterate.select(list, predicate, new ArrayList());
    }

    public static <T, IV> ArrayList<T> selectWith(ArrayList<T> list, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        return ArrayListIterate.selectWith(list, predicate, injectedValue, new ArrayList());
    }

    public static <T, R extends Collection<T>> R select(ArrayList<T> list, Predicate<? super T> predicate, R targetCollection) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i])) continue;
                targetCollection.add(elements[i]);
            }
            return targetCollection;
        }
        return RandomAccessListIterate.select(list, predicate, targetCollection);
    }

    public static <T, P, R extends Collection<T>> R selectWith(ArrayList<T> list, Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i], parameter)) continue;
                targetCollection.add(elements[i]);
            }
            return targetCollection;
        }
        return RandomAccessListIterate.selectWith(list, predicate, parameter, targetCollection);
    }

    public static <T> MutableList<T> selectInstancesOf(ArrayList<?> list, Class<T> clazz) {
        int size = list.size();
        FastList result = FastList.newList(size);
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            ?[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                Object element = elements[i];
                if (!clazz.isInstance(element)) continue;
                result.add(element);
            }
            result.trimToSize();
            return result;
        }
        return RandomAccessListIterate.selectInstancesOf(list, clazz);
    }

    public static <T> int count(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            int count = 0;
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i])) continue;
                ++count;
            }
            return count;
        }
        return RandomAccessListIterate.count(list, predicate);
    }

    public static <T, P> int countWith(ArrayList<T> list, Predicate2<? super T, ? super P> predicate, P parameter) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            int count = 0;
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i], parameter)) continue;
                ++count;
            }
            return count;
        }
        return RandomAccessListIterate.countWith(list, predicate, parameter);
    }

    public static <T, A> ArrayList<A> collectIf(ArrayList<T> list, Predicate<? super T> predicate, Function<? super T, ? extends A> function) {
        return ArrayListIterate.collectIf(list, predicate, function, new ArrayList());
    }

    public static <T, A, R extends Collection<A>> R collectIf(ArrayList<T> list, Predicate<? super T> predicate, Function<? super T, ? extends A> function, R targetCollection) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i])) continue;
                targetCollection.add(function.valueOf(elements[i]));
            }
            return targetCollection;
        }
        return RandomAccessListIterate.collectIf(list, predicate, function, targetCollection);
    }

    public static <T> ArrayList<T> reject(ArrayList<T> list, Predicate<? super T> predicate) {
        return ArrayListIterate.reject(list, predicate, new ArrayList());
    }

    public static <T, IV> ArrayList<T> rejectWith(ArrayList<T> list, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        return ArrayListIterate.rejectWith(list, predicate, injectedValue, new ArrayList());
    }

    public static <T, R extends Collection<T>> R reject(ArrayList<T> list, Predicate<? super T> predicate, R targetCollection) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (predicate.accept(elements[i])) continue;
                targetCollection.add(elements[i]);
            }
            return targetCollection;
        }
        return RandomAccessListIterate.reject(list, predicate, targetCollection);
    }

    public static <T, P, R extends Collection<T>> R rejectWith(ArrayList<T> list, Predicate2<? super T, ? super P> predicate, P injectedValue, R targetCollection) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (predicate.accept(elements[i], injectedValue)) continue;
                targetCollection.add(elements[i]);
            }
            return targetCollection;
        }
        return RandomAccessListIterate.rejectWith(list, predicate, injectedValue, targetCollection);
    }

    public static <T, A> ArrayList<A> collect(ArrayList<T> list, Function<? super T, ? extends A> function) {
        return ArrayListIterate.collect(list, function, new ArrayList(list.size()));
    }

    public static <T> MutableBooleanList collectBoolean(ArrayList<T> list, BooleanFunction<? super T> booleanFunction) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            BooleanArrayList result = new BooleanArrayList(size);
            return ArrayListIterate.collectBooleanFromInternalArray(list, booleanFunction, size, result);
        }
        return RandomAccessListIterate.collectBoolean(list, booleanFunction);
    }

    public static <T, R extends MutableBooleanCollection> R collectBoolean(ArrayList<T> list, BooleanFunction<? super T> booleanFunction, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            return ArrayListIterate.collectBooleanFromInternalArray(list, booleanFunction, size, target);
        }
        return RandomAccessListIterate.collectBoolean(list, booleanFunction, target);
    }

    private static <T, R extends MutableBooleanCollection> R collectBooleanFromInternalArray(ArrayList<T> source, BooleanFunction<? super T> booleanFunction, int elementsToCollect, R target) {
        T[] elements = ArrayListIterate.getInternalArray(source);
        for (int i = 0; i < elementsToCollect; ++i) {
            target.add(booleanFunction.booleanValueOf(elements[i]));
        }
        return target;
    }

    public static <T> MutableByteList collectByte(ArrayList<T> list, ByteFunction<? super T> byteFunction) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            ByteArrayList result = new ByteArrayList(size);
            return ArrayListIterate.collectByteFromInternalArray(list, byteFunction, size, result);
        }
        return RandomAccessListIterate.collectByte(list, byteFunction);
    }

    public static <T, R extends MutableByteCollection> R collectByte(ArrayList<T> list, ByteFunction<? super T> byteFunction, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            return ArrayListIterate.collectByteFromInternalArray(list, byteFunction, size, target);
        }
        return RandomAccessListIterate.collectByte(list, byteFunction, target);
    }

    private static <T, R extends MutableByteCollection> R collectByteFromInternalArray(ArrayList<T> source, ByteFunction<? super T> byteFunction, int elementsToCollect, R target) {
        T[] elements = ArrayListIterate.getInternalArray(source);
        for (int i = 0; i < elementsToCollect; ++i) {
            target.add(byteFunction.byteValueOf(elements[i]));
        }
        return target;
    }

    public static <T> MutableCharList collectChar(ArrayList<T> list, CharFunction<? super T> charFunction) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            CharArrayList result = new CharArrayList(size);
            return ArrayListIterate.collectCharFromInternalArray(list, charFunction, size, result);
        }
        return RandomAccessListIterate.collectChar(list, charFunction);
    }

    public static <T, R extends MutableCharCollection> R collectChar(ArrayList<T> list, CharFunction<? super T> charFunction, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            return ArrayListIterate.collectCharFromInternalArray(list, charFunction, size, target);
        }
        return RandomAccessListIterate.collectChar(list, charFunction, target);
    }

    private static <T, R extends MutableCharCollection> R collectCharFromInternalArray(ArrayList<T> source, CharFunction<? super T> charFunction, int elementsToCollect, R target) {
        T[] elements = ArrayListIterate.getInternalArray(source);
        for (int i = 0; i < elementsToCollect; ++i) {
            target.add(charFunction.charValueOf(elements[i]));
        }
        return target;
    }

    public static <T> MutableDoubleList collectDouble(ArrayList<T> list, DoubleFunction<? super T> doubleFunction) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            DoubleArrayList result = new DoubleArrayList(size);
            return ArrayListIterate.collectDoubleFromInternalArray(list, doubleFunction, size, result);
        }
        return RandomAccessListIterate.collectDouble(list, doubleFunction);
    }

    public static <T, R extends MutableDoubleCollection> R collectDouble(ArrayList<T> list, DoubleFunction<? super T> doubleFunction, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            return ArrayListIterate.collectDoubleFromInternalArray(list, doubleFunction, size, target);
        }
        return RandomAccessListIterate.collectDouble(list, doubleFunction, target);
    }

    private static <T, R extends MutableDoubleCollection> R collectDoubleFromInternalArray(ArrayList<T> source, DoubleFunction<? super T> doubleFunction, int elementsToCollect, R target) {
        T[] elements = ArrayListIterate.getInternalArray(source);
        for (int i = 0; i < elementsToCollect; ++i) {
            target.add(doubleFunction.doubleValueOf(elements[i]));
        }
        return target;
    }

    public static <T> MutableFloatList collectFloat(ArrayList<T> list, FloatFunction<? super T> floatFunction) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            FloatArrayList result = new FloatArrayList(size);
            return ArrayListIterate.collectFloatFromInternalArray(list, floatFunction, size, result);
        }
        return RandomAccessListIterate.collectFloat(list, floatFunction);
    }

    public static <T, R extends MutableFloatCollection> R collectFloat(ArrayList<T> list, FloatFunction<? super T> floatFunction, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            return ArrayListIterate.collectFloatFromInternalArray(list, floatFunction, size, target);
        }
        return RandomAccessListIterate.collectFloat(list, floatFunction, target);
    }

    private static <T, R extends MutableFloatCollection> R collectFloatFromInternalArray(ArrayList<T> source, FloatFunction<? super T> floatFunction, int elementsToCollect, R target) {
        T[] elements = ArrayListIterate.getInternalArray(source);
        for (int i = 0; i < elementsToCollect; ++i) {
            target.add(floatFunction.floatValueOf(elements[i]));
        }
        return target;
    }

    public static <T> MutableIntList collectInt(ArrayList<T> list, IntFunction<? super T> intFunction) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            IntArrayList result = new IntArrayList(size);
            return ArrayListIterate.collectIntFromInternalArray(list, intFunction, size, result);
        }
        return RandomAccessListIterate.collectInt(list, intFunction);
    }

    public static <T, R extends MutableIntCollection> R collectInt(ArrayList<T> list, IntFunction<? super T> intFunction, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            return ArrayListIterate.collectIntFromInternalArray(list, intFunction, size, target);
        }
        return RandomAccessListIterate.collectInt(list, intFunction, target);
    }

    private static <T, R extends MutableIntCollection> R collectIntFromInternalArray(ArrayList<T> source, IntFunction<? super T> intFunction, int elementsToCollect, R target) {
        T[] elements = ArrayListIterate.getInternalArray(source);
        for (int i = 0; i < elementsToCollect; ++i) {
            target.add(intFunction.intValueOf(elements[i]));
        }
        return target;
    }

    public static <T> MutableLongList collectLong(ArrayList<T> list, LongFunction<? super T> longFunction) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            LongArrayList result = new LongArrayList(size);
            return ArrayListIterate.collectLongFromInternalArray(list, longFunction, size, result);
        }
        return RandomAccessListIterate.collectLong(list, longFunction);
    }

    public static <T, R extends MutableLongCollection> R collectLong(ArrayList<T> list, LongFunction<? super T> longFunction, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            return ArrayListIterate.collectLongFromInternalArray(list, longFunction, size, target);
        }
        return RandomAccessListIterate.collectLong(list, longFunction, target);
    }

    private static <T, R extends MutableLongCollection> R collectLongFromInternalArray(ArrayList<T> source, LongFunction<? super T> longFunction, int elementsToCollect, R target) {
        T[] elements = ArrayListIterate.getInternalArray(source);
        for (int i = 0; i < elementsToCollect; ++i) {
            target.add(longFunction.longValueOf(elements[i]));
        }
        return target;
    }

    public static <T> MutableShortList collectShort(ArrayList<T> list, ShortFunction<? super T> shortFunction) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            ShortArrayList result = new ShortArrayList(size);
            return ArrayListIterate.collectShortFromInternalArray(list, shortFunction, size, result);
        }
        return RandomAccessListIterate.collectShort(list, shortFunction);
    }

    public static <T, R extends MutableShortCollection> R collectShort(ArrayList<T> list, ShortFunction<? super T> shortFunction, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            return ArrayListIterate.collectShortFromInternalArray(list, shortFunction, size, target);
        }
        return RandomAccessListIterate.collectShort(list, shortFunction, target);
    }

    private static <T, R extends MutableShortCollection> R collectShortFromInternalArray(ArrayList<T> source, ShortFunction<? super T> shortFunction, int elementsToCollect, R target) {
        T[] elements = ArrayListIterate.getInternalArray(source);
        for (int i = 0; i < elementsToCollect; ++i) {
            target.add(shortFunction.shortValueOf(elements[i]));
        }
        return target;
    }

    public static <T, A, R extends Collection<A>> R collect(ArrayList<T> list, Function<? super T, ? extends A> function, R targetCollection) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                targetCollection.add(function.valueOf(elements[i]));
            }
            return targetCollection;
        }
        return RandomAccessListIterate.collect(list, function, targetCollection);
    }

    public static <T, A> ArrayList<A> flatCollect(ArrayList<T> list, Function<? super T, ? extends Iterable<A>> function) {
        return ArrayListIterate.flatCollect(list, function, new ArrayList(list.size()));
    }

    public static <T, A, R extends Collection<A>> R flatCollect(ArrayList<T> list, Function<? super T, ? extends Iterable<A>> function, R targetCollection) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                Iterate.addAllTo(function.valueOf(elements[i]), targetCollection);
            }
            return targetCollection;
        }
        return RandomAccessListIterate.flatCollect(list, function, targetCollection);
    }

    public static <T> void forEach(ArrayList<T> list, Procedure<? super T> procedure) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                procedure.value(elements[i]);
            }
        } else {
            RandomAccessListIterate.forEach(list, procedure);
        }
    }

    public static <T> void reverseForEach(ArrayList<T> list, Procedure<? super T> procedure) {
        if (!list.isEmpty()) {
            ArrayListIterate.forEach(list, list.size() - 1, 0, procedure);
        }
    }

    public static <T> void reverseForEachWithIndex(ArrayList<T> list, ObjectIntProcedure<? super T> procedure) {
        if (!list.isEmpty()) {
            ArrayListIterate.forEachWithIndex(list, list.size() - 1, 0, procedure);
        }
    }

    public static <T> void forEach(ArrayList<T> list, int from, int to, Procedure<? super T> procedure) {
        ListIterate.rangeCheck(from, to, list.size());
        if (ArrayListIterate.isOptimizableArrayList(list, to - from + 1)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            InternalArrayIterate.forEachWithoutChecks(elements, from, to, procedure);
        } else {
            RandomAccessListIterate.forEach(list, from, to, procedure);
        }
    }

    public static <T> void forEachWithIndex(ArrayList<T> list, int from, int to, ObjectIntProcedure<? super T> objectIntProcedure) {
        ListIterate.rangeCheck(from, to, list.size());
        if (ArrayListIterate.isOptimizableArrayList(list, to - from + 1)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            InternalArrayIterate.forEachWithIndexWithoutChecks(elements, from, to, objectIntProcedure);
        } else {
            RandomAccessListIterate.forEachWithIndex(list, from, to, objectIntProcedure);
        }
    }

    public static <T1, T2> void forEachInBoth(ArrayList<T1> list1, ArrayList<T2> list2, Procedure2<? super T1, ? super T2> procedure) {
        RandomAccessListIterate.forEachInBoth(list1, list2, procedure);
    }

    public static <T> void forEachWithIndex(ArrayList<T> list, ObjectIntProcedure<? super T> objectIntProcedure) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                objectIntProcedure.value(elements[i], i);
            }
        } else {
            RandomAccessListIterate.forEachWithIndex(list, objectIntProcedure);
        }
    }

    public static <T> T detect(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                T item = elements[i];
                if (!predicate.accept(item)) continue;
                return item;
            }
            return null;
        }
        return RandomAccessListIterate.detect(list, predicate);
    }

    public static <T, P> T detectWith(ArrayList<T> list, Predicate2<? super T, ? super P> predicate, P parameter) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                T item = elements[i];
                if (!predicate.accept(item, parameter)) continue;
                return item;
            }
            return null;
        }
        return RandomAccessListIterate.detectWith(list, predicate, parameter);
    }

    public static <T> Optional<T> detectOptional(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                T item = elements[i];
                if (!predicate.accept(item)) continue;
                return Optional.of(item);
            }
            return Optional.empty();
        }
        return RandomAccessListIterate.detectOptional(list, predicate);
    }

    public static <T, P> Optional<T> detectWithOptional(ArrayList<T> list, Predicate2<? super T, ? super P> predicate, P parameter) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                T item = elements[i];
                if (!predicate.accept(item, parameter)) continue;
                return Optional.of(item);
            }
            return Optional.empty();
        }
        return RandomAccessListIterate.detectWithOptional(list, predicate, parameter);
    }

    public static <T> T detectIfNone(ArrayList<T> list, Predicate<? super T> predicate, T ifNone) {
        T result = ArrayListIterate.detect(list, predicate);
        return result == null ? ifNone : result;
    }

    public static <T, IV> T detectWithIfNone(ArrayList<T> list, Predicate2<? super T, ? super IV> predicate, IV injectedValue, T ifNone) {
        T result = ArrayListIterate.detectWith(list, predicate, injectedValue);
        return result == null ? ifNone : result;
    }

    public static <T, IV> IV injectInto(IV injectValue, ArrayList<T> list, Function2<? super IV, ? super T, ? extends IV> function) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            IV result = injectValue;
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                result = function.value(result, elements[i]);
            }
            return result;
        }
        return RandomAccessListIterate.injectInto(injectValue, list, function);
    }

    public static <T> int injectInto(int injectValue, ArrayList<T> list, IntObjectToIntFunction<? super T> function) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            int result = injectValue;
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                result = function.intValueOf(result, elements[i]);
            }
            return result;
        }
        return RandomAccessListIterate.injectInto(injectValue, list, function);
    }

    public static <T> long injectInto(long injectValue, ArrayList<T> list, LongObjectToLongFunction<? super T> function) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            long result = injectValue;
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                result = function.longValueOf(result, elements[i]);
            }
            return result;
        }
        return RandomAccessListIterate.injectInto(injectValue, list, function);
    }

    public static <T> double injectInto(double injectValue, ArrayList<T> list, DoubleObjectToDoubleFunction<? super T> function) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            double result = injectValue;
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                result = function.doubleValueOf(result, elements[i]);
            }
            return result;
        }
        return RandomAccessListIterate.injectInto(injectValue, list, function);
    }

    public static <T> float injectInto(float injectValue, ArrayList<T> list, FloatObjectToFloatFunction<? super T> function) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            float result = injectValue;
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                result = function.floatValueOf(result, elements[i]);
            }
            return result;
        }
        return RandomAccessListIterate.injectInto(injectValue, list, function);
    }

    public static <T> boolean anySatisfy(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i])) continue;
                return true;
            }
            return false;
        }
        return RandomAccessListIterate.anySatisfy(list, predicate);
    }

    public static <T, P> boolean anySatisfyWith(ArrayList<T> list, Predicate2<? super T, ? super P> predicate, P parameter) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i], parameter)) continue;
                return true;
            }
            return false;
        }
        return RandomAccessListIterate.anySatisfyWith(list, predicate, parameter);
    }

    public static <T> boolean allSatisfy(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (predicate.accept(elements[i])) continue;
                return false;
            }
            return true;
        }
        return RandomAccessListIterate.allSatisfy(list, predicate);
    }

    public static <T, IV> boolean allSatisfyWith(ArrayList<T> list, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (predicate.accept(elements[i], injectedValue)) continue;
                return false;
            }
            return true;
        }
        return RandomAccessListIterate.allSatisfyWith(list, predicate, injectedValue);
    }

    public static <T> boolean noneSatisfy(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i])) continue;
                return false;
            }
            return true;
        }
        return RandomAccessListIterate.noneSatisfy(list, predicate);
    }

    public static <T, IV> boolean noneSatisfyWith(ArrayList<T> list, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i], injectedValue)) continue;
                return false;
            }
            return true;
        }
        return RandomAccessListIterate.noneSatisfyWith(list, predicate, injectedValue);
    }

    public static <T, P> Twin<MutableList<T>> selectAndRejectWith(ArrayList<T> list, Predicate2<? super T, ? super P> predicate, P parameter) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            MutableList positiveResult = Lists.mutable.empty();
            MutableList negativeResult = Lists.mutable.empty();
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                (predicate.accept(elements[i], parameter) ? positiveResult : negativeResult).add(elements[i]);
            }
            return Tuples.twin(positiveResult, negativeResult);
        }
        return RandomAccessListIterate.selectAndRejectWith(list, predicate, parameter);
    }

    public static <T> PartitionMutableList<T> partition(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            PartitionFastList partitionFastList = new PartitionFastList();
            MutableCollection selected = partitionFastList.getSelected();
            MutableCollection rejected = partitionFastList.getRejected();
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                T each = elements[i];
                MutableCollection bucket = predicate.accept(each) ? selected : rejected;
                bucket.add(each);
            }
            return partitionFastList;
        }
        return RandomAccessListIterate.partition(list, predicate);
    }

    public static <T, P> PartitionMutableList<T> partitionWith(ArrayList<T> list, Predicate2<? super T, ? super P> predicate, P parameter) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            PartitionFastList partitionFastList = new PartitionFastList();
            MutableCollection selected = partitionFastList.getSelected();
            MutableCollection rejected = partitionFastList.getRejected();
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                T each = elements[i];
                MutableCollection bucket = predicate.accept(each, parameter) ? selected : rejected;
                bucket.add(each);
            }
            return partitionFastList;
        }
        return RandomAccessListIterate.partitionWith(list, predicate, parameter);
    }

    public static <T> int detectIndex(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i])) continue;
                return i;
            }
            return -1;
        }
        return RandomAccessListIterate.detectIndex(list, predicate);
    }

    public static <T, P> int detectIndexWith(ArrayList<T> list, Predicate2<? super T, ? super P> predicate, P parameter) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!predicate.accept(elements[i], parameter)) continue;
                return i;
            }
            return -1;
        }
        return RandomAccessListIterate.detectIndexWith(list, predicate, parameter);
    }

    public static <T> int detectLastIndex(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = size - 1; i >= 0; --i) {
                if (!predicate.accept(elements[i])) continue;
                return i;
            }
            return -1;
        }
        return RandomAccessListIterate.detectLastIndex(list, predicate);
    }

    public static <T, IV, P> IV injectIntoWith(IV injectedValue, ArrayList<T> list, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            IV result = injectedValue;
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                result = function.value(result, elements[i], parameter);
            }
            return result;
        }
        return RandomAccessListIterate.injectIntoWith(injectedValue, list, function, parameter);
    }

    public static <T, P> void forEachWith(ArrayList<T> list, Procedure2<? super T, ? super P> procedure, P parameter) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                procedure.value(elements[i], parameter);
            }
        } else {
            RandomAccessListIterate.forEachWith(list, procedure, parameter);
        }
    }

    public static <T, P, A> ArrayList<A> collectWith(ArrayList<T> list, Function2<? super T, ? super P, ? extends A> function, P parameter) {
        return ArrayListIterate.collectWith(list, function, parameter, new ArrayList(list.size()));
    }

    public static <T, P, A, R extends Collection<A>> R collectWith(ArrayList<T> list, Function2<? super T, ? super P, ? extends A> function, P parameter, R targetCollection) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                targetCollection.add(function.value(elements[i], parameter));
            }
            return targetCollection;
        }
        return RandomAccessListIterate.collectWith(list, function, parameter, targetCollection);
    }

    public static <T> boolean removeIf(ArrayList<T> list, Predicate<? super T> predicate) {
        T[] elements;
        int size;
        int currentFilledIndex;
        if (list.getClass() == ArrayList.class && SIZE_FIELD != null) {
            currentFilledIndex = 0;
            size = list.size();
            elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (predicate.accept(elements[i])) continue;
                if (currentFilledIndex != i) {
                    elements[currentFilledIndex] = elements[i];
                }
                ++currentFilledIndex;
            }
        } else {
            return RandomAccessListIterate.removeIf(list, predicate);
        }
        boolean changed = currentFilledIndex < size;
        ArrayListIterate.wipeAndResetTheEnd(currentFilledIndex, size, elements, list);
        return changed;
    }

    public static <T, P> boolean removeIfWith(ArrayList<T> list, Predicate2<? super T, ? super P> predicate, P parameter) {
        T[] elements;
        int size;
        int currentFilledIndex;
        if (list.getClass() == ArrayList.class && SIZE_FIELD != null) {
            currentFilledIndex = 0;
            size = list.size();
            elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (predicate.accept(elements[i], parameter)) continue;
                if (currentFilledIndex != i) {
                    elements[currentFilledIndex] = elements[i];
                }
                ++currentFilledIndex;
            }
        } else {
            return RandomAccessListIterate.removeIfWith(list, predicate, parameter);
        }
        boolean changed = currentFilledIndex < size;
        ArrayListIterate.wipeAndResetTheEnd(currentFilledIndex, size, elements, list);
        return changed;
    }

    public static <T> ArrayList<T> distinct(ArrayList<T> list) {
        return ArrayListIterate.distinct(list, new ArrayList());
    }

    @Deprecated
    public static <T, R extends List<T>> R distinct(ArrayList<T> list, R targetList) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            UnifiedSet seenSoFar = UnifiedSet.newSet();
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!seenSoFar.add(elements[i])) continue;
                targetList.add(elements[i]);
            }
            return targetList;
        }
        return RandomAccessListIterate.distinct(list, targetList);
    }

    public static <T> ArrayList<T> distinct(ArrayList<T> list, HashingStrategy<? super T> hashingStrategy) {
        int size = list.size();
        UnifiedSetWithHashingStrategy<T> seenSoFar = UnifiedSetWithHashingStrategy.newSet(hashingStrategy);
        ArrayList<T> result = new ArrayList<T>();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                if (!seenSoFar.add(elements[i])) continue;
                result.add(elements[i]);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                T item = list.get(i);
                if (!seenSoFar.add(item)) continue;
                result.add(item);
            }
        }
        return result;
    }

    public static <T, V> ArrayList<T> distinctBy(ArrayList<T> list, Function<? super T, ? extends V> function) {
        return ArrayListIterate.distinct(list, HashingStrategies.fromFunction(function));
    }

    private static <T> void wipeAndResetTheEnd(int newCurrentFilledIndex, int newSize, T[] newElements, ArrayList<T> list) {
        for (int i = newCurrentFilledIndex; i < newSize; ++i) {
            newElements[i] = null;
        }
        try {
            SIZE_FIELD.setInt(list, newCurrentFilledIndex);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Something really bad happened on the way to pounding size into the ArrayList reflectively", e);
        }
    }

    public static <T extends Comparable<? super T>> ArrayList<T> sortThis(ArrayList<T> list) {
        return ArrayListIterate.sortThis(list, Comparators.naturalOrder());
    }

    public static <T> ArrayList<T> sortThis(ArrayList<T> list, Comparator<? super T> comparator) {
        int size = list.size();
        if (ArrayListIterate.canAccessInternalArray(list)) {
            Arrays.sort(ArrayListIterate.getInternalArray(list), 0, size, comparator);
        } else {
            Collections.sort(list, comparator);
        }
        return list;
    }

    public static <T> void toArray(ArrayList<T> list, T[] target, int startIndex, int sourceSize) {
        if (ArrayListIterate.canAccessInternalArray(list)) {
            System.arraycopy(ArrayListIterate.getInternalArray(list), 0, target, startIndex, sourceSize);
        } else {
            RandomAccessListIterate.toArray(list, target, startIndex, sourceSize);
        }
    }

    public static <T> ArrayList<T> take(ArrayList<T> list, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        return ArrayListIterate.take(list, count, new ArrayList(Math.min(list.size(), count)));
    }

    public static <T, R extends Collection<T>> R take(ArrayList<T> list, int count, R targetList) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            int end = Math.min(size, count);
            for (int i = 0; i < end; ++i) {
                targetList.add(elements[i]);
            }
            return targetList;
        }
        return RandomAccessListIterate.take(list, count, targetList);
    }

    public static <T> ArrayList<T> drop(ArrayList<T> list, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        return ArrayListIterate.drop(list, count, new ArrayList(list.size() - Math.min(list.size(), count)));
    }

    public static <T, R extends Collection<T>> R drop(ArrayList<T> list, int count, R targetList) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count);
        }
        int size = list.size();
        if (count >= size) {
            return targetList;
        }
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = count; i < size; ++i) {
                targetList.add(elements[i]);
            }
            return targetList;
        }
        return RandomAccessListIterate.drop(list, count, targetList);
    }

    public static <T, V> FastListMultimap<V, T> groupBy(ArrayList<T> list, Function<? super T, ? extends V> function) {
        return ArrayListIterate.groupBy(list, function, FastListMultimap.newMultimap());
    }

    public static <T, V, R extends MutableMultimap<V, T>> R groupBy(ArrayList<T> list, Function<? super T, ? extends V> function, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                target.put(function.valueOf(elements[i]), elements[i]);
            }
            return target;
        }
        return RandomAccessListIterate.groupBy(list, function, target);
    }

    public static <T, V> FastListMultimap<V, T> groupByEach(ArrayList<T> list, Function<? super T, ? extends Iterable<V>> function) {
        return ArrayListIterate.groupByEach(list, function, FastListMultimap.newMultimap());
    }

    public static <T, V, R extends MutableMultimap<V, T>> R groupByEach(ArrayList<T> list, Function<? super T, ? extends Iterable<V>> function, R target) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                Iterable<V> iterable = function.valueOf(elements[i]);
                for (V key : iterable) {
                    target.put(key, elements[i]);
                }
            }
            return target;
        }
        return RandomAccessListIterate.groupByEach(list, function, target);
    }

    public static <T, V> MutableMap<V, T> groupByUniqueKey(ArrayList<T> list, Function<? super T, ? extends V> function) {
        return ArrayListIterate.groupByUniqueKey(list, function, UnifiedMap.newMap());
    }

    public static <T, V, R extends MutableMap<V, T>> R groupByUniqueKey(ArrayList<T> list, Function<? super T, ? extends V> function, R target) {
        if (list == null) {
            throw new IllegalArgumentException("Cannot perform a groupByUniqueKey on null");
        }
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                V key = function.valueOf(elements[i]);
                if (target.put(key, elements[i]) == null) continue;
                throw new IllegalStateException("Key " + key + " already exists in map!");
            }
            return target;
        }
        return RandomAccessListIterate.groupByUniqueKey(list, function, target);
    }

    public static <X, Y> MutableList<Pair<X, Y>> zip(ArrayList<X> xs, Iterable<Y> ys) {
        return ArrayListIterate.zip(xs, ys, FastList.newList());
    }

    public static <X, Y, R extends Collection<Pair<X, Y>>> R zip(ArrayList<X> xs, Iterable<Y> ys, R targetCollection) {
        int size = xs.size();
        if (ArrayListIterate.isOptimizableArrayList(xs, size)) {
            Iterator<Y> yIterator = ys.iterator();
            X[] elements = ArrayListIterate.getInternalArray(xs);
            for (int i = 0; i < size && yIterator.hasNext(); ++i) {
                targetCollection.add(Tuples.pair(elements[i], yIterator.next()));
            }
            return targetCollection;
        }
        return RandomAccessListIterate.zip(xs, ys, targetCollection);
    }

    public static <T> MutableList<Pair<T, Integer>> zipWithIndex(ArrayList<T> list) {
        return ArrayListIterate.zipWithIndex(list, FastList.newList());
    }

    public static <T, R extends Collection<Pair<T, Integer>>> R zipWithIndex(ArrayList<T> list, R targetCollection) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                targetCollection.add(Tuples.pair(elements[i], i));
            }
            return targetCollection;
        }
        return RandomAccessListIterate.zipWithIndex(list, targetCollection);
    }

    public static <T> MutableList<T> takeWhile(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            FastList<T> result = FastList.newList();
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                T element = elements[i];
                if (!predicate.accept(element)) {
                    return result;
                }
                result.add(element);
            }
            return result;
        }
        return RandomAccessListIterate.takeWhile(list, predicate);
    }

    public static <T> MutableList<T> dropWhile(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            FastList<T> result = FastList.newList();
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                T element = elements[i];
                if (predicate.accept(element)) continue;
                result.add(element);
                for (int j = i + 1; j < size; ++j) {
                    T eachNotDropped = elements[j];
                    result.add(eachNotDropped);
                }
                return result;
            }
            return result;
        }
        return RandomAccessListIterate.dropWhile(list, predicate);
    }

    public static <T> PartitionMutableList<T> partitionWhile(ArrayList<T> list, Predicate<? super T> predicate) {
        int size = list.size();
        if (ArrayListIterate.isOptimizableArrayList(list, size)) {
            PartitionFastList result = new PartitionFastList();
            MutableCollection selected = result.getSelected();
            T[] elements = ArrayListIterate.getInternalArray(list);
            for (int i = 0; i < size; ++i) {
                T each = elements[i];
                if (!predicate.accept(each)) {
                    MutableCollection rejected = result.getRejected();
                    rejected.add(each);
                    for (int j = i + 1; j < size; ++j) {
                        rejected.add(elements[j]);
                    }
                    return result;
                }
                selected.add(each);
            }
            return result;
        }
        return RandomAccessListIterate.partitionWhile(list, predicate);
    }

    private static boolean canAccessInternalArray(ArrayList<?> list) {
        return ELEMENT_DATA_FIELD != null && list.getClass() == ArrayList.class;
    }

    private static boolean isOptimizableArrayList(ArrayList<?> list, int newSize) {
        return newSize > 100 && ELEMENT_DATA_FIELD != null && list.getClass() == ArrayList.class;
    }

    private static <T> T[] getInternalArray(ArrayList<T> list) {
        try {
            return (Object[])ELEMENT_DATA_FIELD.get(list);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, K, V> MutableMap<K, V> aggregateInPlaceBy(ArrayList<T> list, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        ArrayListIterate.forEach(list, new MutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    public static <T, K, V> MutableMap<K, V> aggregateBy(ArrayList<T> list, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        ArrayListIterate.forEach(list, new NonMutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map;
    }

    static {
        Field data = null;
        Field size = null;
        try {
            data = ArrayList.class.getDeclaredField("elementData");
            size = ArrayList.class.getDeclaredField("size");
            data.setAccessible(true);
            size.setAccessible(true);
        }
        catch (Exception ignored) {
            data = null;
            size = null;
        }
        ELEMENT_DATA_FIELD = data;
        SIZE_FIELD = size;
    }
}

