/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.FloatList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.FloatStack;
import org.eclipse.collections.api.stack.primitive.ImmutableFloatStack;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.FloatStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableFloatIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.stack.mutable.primitive.FloatArrayStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableFloatSingletonStack
implements ImmutableFloatStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final float element1;

    ImmutableFloatSingletonStack(float element) {
        this.element1 = element;
    }

    public FloatIterator floatIterator() {
        return new UnmodifiableFloatIterator(FloatArrayStack.newStackWith(this.element1).floatIterator());
    }

    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    public void each(FloatProcedure procedure) {
        procedure.value(this.element1);
    }

    public int count(FloatPredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return !predicate.accept(this.element1);
    }

    public float peek() {
        return this.element1;
    }

    public FloatList peek(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return new FloatArrayList(0);
        }
        if (count == 1) {
            return FloatArrayList.newListWith(this.element1);
        }
        throw new IllegalArgumentException("Count must be less than or equal to size: Count = " + count + " Size = 1");
    }

    public float peekAt(int index) {
        this.checkNegativeCount(index);
        if (index == 0) {
            return this.element1;
        }
        throw new IllegalArgumentException("Index must be less than size: Index = " + index + " Size = 1");
    }

    public ImmutableFloatStack select(FloatPredicate predicate) {
        return predicate.accept(this.element1) ? FloatStacks.immutable.with(this.element1) : FloatStacks.immutable.with();
    }

    public ImmutableFloatStack reject(FloatPredicate predicate) {
        return predicate.accept(this.element1) ? FloatStacks.immutable.with() : FloatStacks.immutable.with(this.element1);
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public <V> ImmutableStack<V> collect(FloatToObjectFunction<? extends V> function) {
        return Stacks.immutable.with(function.valueOf(this.element1));
    }

    public double sum() {
        return this.element1;
    }

    public float max() {
        return this.element1;
    }

    public float maxIfEmpty(float defaultValue) {
        return this.element1;
    }

    public float min() {
        return this.element1;
    }

    public float minIfEmpty(float defaultValue) {
        return this.element1;
    }

    public double average() {
        return this.element1;
    }

    public double median() {
        return this.element1;
    }

    public float[] toSortedArray() {
        return new float[]{this.element1};
    }

    public MutableFloatList toSortedList() {
        return FloatArrayList.newListWith(this.element1);
    }

    public float[] toArray() {
        return new float[]{this.element1};
    }

    public boolean contains(float value) {
        return Float.compare(this.element1, value) == 0;
    }

    public boolean containsAll(float ... source) {
        for (float value : source) {
            if (Float.compare(this.element1, value) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            if (Float.compare(this.element1, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    public MutableFloatList toList() {
        return FloatArrayList.newListWith(this.element1);
    }

    public MutableFloatSet toSet() {
        return FloatHashSet.newSetWith(this.element1);
    }

    public MutableFloatBag toBag() {
        return FloatHashBag.newBagWith(this.element1);
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    public ImmutableFloatStack toImmutable() {
        return this;
    }

    public ImmutableFloatStack push(float element) {
        return FloatStacks.immutable.with(new float[]{this.element1, element});
    }

    public ImmutableFloatStack pop() {
        return FloatStacks.immutable.with();
    }

    public ImmutableFloatStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        if (count == 1) {
            return FloatStacks.immutable.with();
        }
        throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = 1");
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element1);
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof FloatStack)) {
            return false;
        }
        FloatStack stack = (FloatStack)otherStack;
        if (stack.size() != 1) {
            return false;
        }
        return Float.compare(this.element1, stack.peek()) == 0;
    }

    public int hashCode() {
        return 31 + Float.floatToIntBits(this.element1);
    }

    public String toString() {
        return "[" + this.element1 + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

