/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.team.core.synchronize.ISyncInfoTreeChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.synchronize.AbstractSynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProviderDescriptor;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelProvider;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public class FlatModelProvider
extends SynchronizeModelProvider {
    private static final FlatModelProviderDescriptor flatDescriptor = new FlatModelProviderDescriptor();
    private static final String P_LAST_RESOURCESORT = "org.eclipse.team.ui.P_LAST_RESOURCE_SORT";
    private int sortCriteria = 2;

    public FlatModelProvider(ISynchronizePageConfiguration configuration, SyncInfoSet set) {
        super(configuration, set);
        this.initialize(configuration);
    }

    public FlatModelProvider(AbstractSynchronizeModelProvider parentProvider, ISynchronizeModelElement modelRoot, ISynchronizePageConfiguration configuration, SyncInfoSet set) {
        super(parentProvider, modelRoot, configuration, set);
        this.initialize(configuration);
    }

    private void initialize(ISynchronizePageConfiguration configuration) {
        try {
            IDialogSettings pageSettings = this.getConfiguration().getSite().getPageSettings();
            if (pageSettings != null) {
                this.sortCriteria = pageSettings.getInt(P_LAST_RESOURCESORT);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        switch (this.sortCriteria) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                this.sortCriteria = 2;
            }
        }
    }

    @Override
    protected SynchronizePageActionGroup createActionGroup() {
        return new FlatActionGroup();
    }

    @Override
    public ViewerSorter getViewerSorter() {
        return new FlatSorter(this.sortCriteria);
    }

    @Override
    protected IDiffElement[] buildModelObjects(ISynchronizeModelElement node) {
        if (node == this.getModelRoot()) {
            // empty if block
        }
        SyncInfo[] infos = this.getSyncInfoSet().getSyncInfos();
        ArrayList<ISynchronizeModelElement> result = new ArrayList<ISynchronizeModelElement>();
        SyncInfo[] syncInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            SyncInfo info = syncInfoArray[n2];
            result.add(this.createModelObject(node, info));
            ++n2;
        }
        return result.toArray(new IDiffElement[result.size()]);
    }

    @Override
    protected void handleResourceAdditions(ISyncInfoTreeChangeEvent event) {
        this.addResources(event.getAddedResources());
    }

    @Override
    protected void handleResourceRemovals(ISyncInfoTreeChangeEvent event) {
        IResource[] resources = event.getRemovedResources();
        this.removeFromViewer(resources);
    }

    @Override
    public ISynchronizeModelProviderDescriptor getDescriptor() {
        return flatDescriptor;
    }

    @Override
    protected void addResource(SyncInfo info) {
        ISynchronizeModelElement node = this.getModelObject(info.getLocal());
        if (node != null) {
            this.removeFromViewer(info.getLocal());
        }
        this.createModelObject(this.getModelRoot(), info);
    }

    @Override
    protected ISynchronizeModelElement createModelObject(ISynchronizeModelElement parent, SyncInfo info) {
        FullPathSyncInfoElement newNode = new FullPathSyncInfoElement(parent, info);
        this.addToViewer(newNode);
        return newNode;
    }

    public class FlatActionGroup
    extends SynchronizePageActionGroup {
        private MenuManager sortByResource;

        @Override
        public void initialize(ISynchronizePageConfiguration configuration) {
            super.initialize(configuration);
            this.sortByResource = new MenuManager(TeamUIMessages.FlatModelProvider_6);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "sort", (IContributionItem)this.sortByResource);
            FlatModelProvider.this.initialize(configuration);
            this.sortByResource.add((IAction)new ToggleSortOrderAction(TeamUIMessages.FlatModelProvider_8, 2));
            this.sortByResource.add((IAction)new ToggleSortOrderAction(TeamUIMessages.FlatModelProvider_7, 1));
            this.sortByResource.add((IAction)new ToggleSortOrderAction(TeamUIMessages.FlatModelProvider_9, 3));
        }

        @Override
        public void dispose() {
            this.sortByResource.dispose();
            this.sortByResource.removeAll();
            super.dispose();
        }
    }

    public static class FlatModelProviderDescriptor
    implements ISynchronizeModelProviderDescriptor {
        public static final String ID = "org.eclipse.team.ui.modelprovider_flat";

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public String getName() {
            return TeamUIMessages.FlatModelProvider_0;
        }

        @Override
        public ImageDescriptor getImageDescriptor() {
            return TeamImages.getImageDescriptor("elcl16/flatLayout.png");
        }
    }

    public class FlatSorter
    extends ViewerSorter {
        private int resourceCriteria;
        public static final int NAME = 1;
        public static final int PATH = 2;
        public static final int PARENT_NAME = 3;

        public FlatSorter(int resourceCriteria) {
            this.resourceCriteria = resourceCriteria;
        }

        protected int classComparison(Object element) {
            if (element instanceof FullPathSyncInfoElement) {
                return 0;
            }
            return 1;
        }

        protected int compareClass(Object element1, Object element2) {
            return this.classComparison(element1) - this.classComparison(element2);
        }

        protected int compareNames(String s1, String s2) {
            return this.collator.compare(s1, s2);
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            if (o1 instanceof FullPathSyncInfoElement && o2 instanceof FullPathSyncInfoElement) {
                IResource r1 = ((FullPathSyncInfoElement)o1).getResource();
                IResource r2 = ((FullPathSyncInfoElement)o2).getResource();
                if (this.resourceCriteria == 1) {
                    return this.compareNames(r1.getName(), r2.getName());
                }
                if (this.resourceCriteria == 2) {
                    return this.compareNames(r1.getFullPath().toString(), r2.getFullPath().toString());
                }
                if (this.resourceCriteria == 3) {
                    return this.compareNames(r1.getParent().getName(), r2.getParent().getName());
                }
                return 0;
            }
            if (o1 instanceof ISynchronizeModelElement) {
                return 1;
            }
            if (o2 instanceof ISynchronizeModelElement) {
                return -1;
            }
            return 0;
        }

        public int getResourceCriteria() {
            return this.resourceCriteria;
        }
    }

    public static class FullPathSyncInfoElement
    extends SyncInfoModelElement {
        public FullPathSyncInfoElement(IDiffContainer parent, SyncInfo info) {
            super(parent, info);
        }

        @Override
        public String getName() {
            IResource resource = this.getResource();
            return String.valueOf(resource.getName()) + " - " + resource.getFullPath().toString();
        }
    }

    private class ToggleSortOrderAction
    extends Action {
        private int criteria;

        protected ToggleSortOrderAction(String name, int criteria) {
            super(name, 8);
            this.criteria = criteria;
            this.update();
        }

        public void run() {
            if (this.isChecked() && FlatModelProvider.this.sortCriteria != this.criteria) {
                FlatModelProvider.this.sortCriteria = this.criteria;
                String key = this.getSettingsKey();
                IDialogSettings pageSettings = FlatModelProvider.this.getConfiguration().getSite().getPageSettings();
                if (pageSettings != null) {
                    pageSettings.put(key, this.criteria);
                }
                this.update();
                FlatModelProvider.this.firePropertyChange("org.eclipse.team.ui.P_VIEWER_SORTER", null, null);
            }
        }

        public void update() {
            this.setChecked(FlatModelProvider.this.sortCriteria == this.criteria);
        }

        protected String getSettingsKey() {
            return FlatModelProvider.P_LAST_RESOURCESORT;
        }
    }
}

