/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.comma.java.JArtifactInfo;
import org.eclipse.comma.java.JArtifactInfoBuilder;
import org.eclipse.comma.java.JDependencyInfo;
import org.eclipse.comma.java.JDependencyInfos;
import org.eclipse.comma.java.JSourceInfo;
import org.eclipse.comma.java.impl.JSourceInfoImpl;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.project.generatortasks.GeneratorTask;
import org.eclipse.comma.project.generatortasks.OutputLocator;
import org.eclipse.comma.project.project.ComponentReference;
import org.eclipse.comma.project.project.ExecutableSource;
import org.eclipse.comma.project.project.SimulatorGenerationTask;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SimulatorGeneratorTask
extends GeneratorTask {
    protected final SimulatorGenerationTask task;
    protected final IScopeProvider scopeProvider;
    protected final IFileSystemAccess2 fsa;
    protected CommaFileSystemAccess libFileSystemAccess;
    private final List<String> exportExtensions = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{".interface", ".signature", ".types", ".params", ".component"}));

    public SimulatorGeneratorTask(SimulatorGenerationTask task, IScopeProvider scopeProvider, OutputLocator outputLocator, IFileSystemAccess2 fsa) {
        super(task, scopeProvider, outputLocator, fsa);
        this.task = task;
        this.scopeProvider = scopeProvider;
        this.fsa = fsa;
    }

    public void serializeResources(ResourceSet rs, JsonObject json) {
        EList _resources = rs.getResources();
        for (Resource resource : _resources) {
            final String path = resource.getURI().path();
            Predicate<String> _function = new Predicate<String>(){

                @Override
                public boolean test(String e) {
                    return path.endsWith(e);
                }
            };
            boolean _anyMatch = this.exportExtensions.stream().anyMatch(_function);
            if (!_anyMatch) continue;
            ISerializer serializer = ((XtextResource)resource).getSerializer();
            String serialized = serializer.serialize((EObject)resource.getContents().get(0));
            json.getAsJsonObject("resources").addProperty(path, serialized);
        }
    }

    @Override
    protected void doGenerate() {
        try {
            boolean _tripleNotEquals;
            final JsonObject json = new JsonObject();
            JsonObject _jsonObject = new JsonObject();
            json.add("resources", (JsonElement)_jsonObject);
            JsonArray _jsonArray = new JsonArray();
            json.add("parameters", (JsonElement)_jsonArray);
            ExecutableSource target = this.task.getTarget();
            if (target instanceof ComponentReference) {
                this.serializeResources(((ComponentReference)target).getComponent().eResource().getResourceSet(), json);
                json.addProperty("model", ((ComponentReference)target).getComponent().eResource().getURI().path());
            } else {
                this.serializeResources(this.getInterface(target).eResource().getResourceSet(), json);
                json.addProperty("model", this.getInterface(target).eResource().getURI().path());
            }
            EList<String> _params = this.task.getParams();
            boolean bl = _tripleNotEquals = _params != null;
            if (_tripleNotEquals) {
                Consumer<String> _function = new Consumer<String>(){

                    @Override
                    public void accept(String p) {
                        EObject _head = (EObject)IterableExtensions.head((Iterable)EcoreUtil2.getResource((Resource)SimulatorGeneratorTask.this.task.eResource(), (String)p).getContents());
                        Parameters parameters = (Parameters)_head;
                        SimulatorGeneratorTask.this.serializeResources(parameters.eResource().getResourceSet(), json);
                        json.getAsJsonArray("parameters").add(parameters.eResource().getURI().path());
                    }
                };
                this.task.getParams().forEach((Consumer)_function);
            }
            File modelFile = File.createTempFile("model", "json");
            FileWriter writer = new FileWriter(modelFile);
            writer.write(new GsonBuilder().create().toJson((JsonElement)json));
            writer.close();
            HashSet<JDependencyInfo> dependencies = null;
            boolean _isRunning = Platform.isRunning();
            if (_isRunning) {
                dependencies = JDependencyInfos.getDependencyFromBundleIdWithTransitiveDependencies((String)"org.eclipse.comma.simulator");
                final List removeDependencies = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"com.ibm.icu", "org.eclipse.jdt.core"}));
                Predicate<JDependencyInfo> _function_1 = new Predicate<JDependencyInfo>(){

                    @Override
                    public boolean test(final JDependencyInfo d) {
                        Predicate<String> _function = new Predicate<String>(){

                            @Override
                            public boolean test(String r) {
                                return d.getLocation().getPath().contains(r);
                            }
                        };
                        return removeDependencies.stream().anyMatch(_function);
                    }
                };
                dependencies.removeIf(_function_1);
            } else {
                HashSet<JDependencyInfo> _hashSet;
                URI _uRI = SimulatorGeneratorTask.class.getProtectionDomain().getCodeSource().getLocation().toURI();
                File jar = new File(_uRI);
                dependencies = _hashSet = new HashSet<JDependencyInfo>();
                dependencies.add(JDependencyInfos.create((File)jar));
            }
            JSourceInfoImpl resource = new JSourceInfoImpl(modelFile, "resource/model.json");
            JArtifactInfo artifact = new JArtifactInfoBuilder().withDependencyInfos(dependencies).withMainClass("org.eclipse.comma.simulator.Window").withIncludeDependencies().withResources(new JSourceInfo[]{resource}).build();
            byte[] _bytes = artifact.getBytes();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(_bytes);
            String _name = this.task.getName();
            String _plus = "simulator/" + _name;
            String _plus_1 = String.valueOf(_plus) + ".jar";
            this.fsa.generateFile(_plus_1, (InputStream)inputStream);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

