/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.java;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.eclipse.comma.java.JArtifactInfo;
import org.eclipse.comma.java.JClassInfo;
import org.eclipse.comma.java.JClassInfos;
import org.eclipse.comma.java.JDependencyInfo;
import org.eclipse.comma.java.JDependencyInfos;
import org.eclipse.comma.java.JSourceInfo;
import org.eclipse.comma.java.JSourceInfos;
import org.eclipse.comma.java.impl.JArtifactInfoImpl;

public class JArtifactInfoBuilder {
    private File archiveFile;
    private List<JClassInfo> classInfos = new ArrayList<JClassInfo>();
    private List<JDependencyInfo> dependencyInfos = new ArrayList<JDependencyInfo>();
    private List<JSourceInfo> resources = new ArrayList<JSourceInfo>();
    private String mainClass;
    private Manifest manifest;
    private boolean includeDependencies = false;

    public JArtifactInfoBuilder withArchiveFile(File archiveFile) {
        this.archiveFile = Objects.requireNonNull(archiveFile, "archiveFile must not be null");
        return this;
    }

    public JArtifactInfoBuilder withIncludeDependencies() {
        this.includeDependencies = true;
        return this;
    }

    public JArtifactInfoBuilder withClassInfos(JClassInfo ... classInfos) {
        JClassInfo[] jClassInfoArray = classInfos;
        int n = classInfos.length;
        int n2 = 0;
        while (n2 < n) {
            JClassInfo cInfo = jClassInfoArray[n2];
            this.classInfos.add(Objects.requireNonNull(cInfo, "classInfo must not be null"));
            ++n2;
        }
        return this;
    }

    public JArtifactInfoBuilder withClassInfos(Collection<JClassInfo> classInfos) {
        classInfos.forEach(ci -> {
            JArtifactInfoBuilder jArtifactInfoBuilder = this.withClassInfos((JClassInfo)ci);
        });
        return this;
    }

    public JArtifactInfoBuilder withDependencyInfos(JDependencyInfo ... dependencyInfos) {
        JDependencyInfo[] jDependencyInfoArray = dependencyInfos;
        int n = dependencyInfos.length;
        int n2 = 0;
        while (n2 < n) {
            JDependencyInfo dInfos = jDependencyInfoArray[n2];
            this.dependencyInfos.add(Objects.requireNonNull(dInfos, "dependencyInfo must not be null"));
            ++n2;
        }
        return this;
    }

    public JArtifactInfoBuilder withDependencyInfos(Collection<JDependencyInfo> dependencyInfos) {
        dependencyInfos.forEach(di -> {
            JArtifactInfoBuilder jArtifactInfoBuilder = this.withDependencyInfos((JDependencyInfo)di);
        });
        return this;
    }

    public JArtifactInfoBuilder withResources(JSourceInfo ... resources) {
        JSourceInfo[] jSourceInfoArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            JSourceInfo rInfo = jSourceInfoArray[n2];
            if (!JSourceInfos.isResource(rInfo)) {
                throw new IllegalArgumentException("Resource '" + rInfo + "' is not a resource");
            }
            this.resources.add(rInfo);
            ++n2;
        }
        return this;
    }

    public JArtifactInfoBuilder withResources(Collection<JSourceInfo> resources) {
        resources.forEach(r -> {
            JArtifactInfoBuilder jArtifactInfoBuilder = this.withResources((JSourceInfo)r);
        });
        return this;
    }

    public JArtifactInfoBuilder withMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public JArtifactInfoBuilder withManifest(Manifest manifest) {
        this.manifest = manifest;
        return this;
    }

    public JArtifactInfo build() throws IOException {
        byte[] bytes = this.makeArchive();
        return new JArtifactInfoImpl(bytes, this.archiveFile, this.dependencyInfos, this.getMainClass(), this.includeDependencies);
    }

    private byte[] makeArchive() throws IOException {
        if (this.archiveFile != null) {
            this.archiveFile.delete();
            this.archiveFile.getParentFile().mkdirs();
        }
        this.prepareManifest();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var3_5 = null;
        try (JarOutputStream out = new JarOutputStream((OutputStream)stream, this.manifest);){
            FileInputStream in;
            Iterator<Map.Entry<JarEntry, InputStream>> iterator;
            Throwable throwable2;
            JarEntry jarEntry;
            for (JClassInfo classInfo : this.classInfos) {
                jarEntry = JClassInfos.toJarEntry(classInfo);
                throwable2 = null;
                iterator = null;
                try {
                    in = new FileInputStream(classInfo.getLocation());
                    try {
                        this.addJarEntryToJar(out, jarEntry, in, false);
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            for (JSourceInfo resource : this.resources) {
                jarEntry = JSourceInfos.toJarEntry(resource);
                throwable2 = null;
                iterator = null;
                try {
                    in = new FileInputStream(resource.getLocation());
                    try {
                        this.addJarEntryToJar(out, jarEntry, in, false);
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
            }
            if (this.includeDependencies) {
                List<String> ignoreFiles = Arrays.asList("META-INF/ECLIPSE_.SF");
                for (JDependencyInfo dependencyInfo : this.dependencyInfos) {
                    for (Map.Entry<JarEntry, InputStream> entry : JDependencyInfos.toJarEntries(dependencyInfo).entrySet()) {
                        if (ignoreFiles.contains(entry.getKey().getName())) continue;
                        this.addJarEntryToJar(out, entry.getKey(), entry.getValue(), true);
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
        if (this.archiveFile != null) {
            throwable = null;
            var3_5 = null;
            try (FileOutputStream outputStream = new FileOutputStream(this.archiveFile);){
                stream.writeTo(outputStream);
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        return stream.toByteArray();
    }

    private void addJarEntryToJar(JarOutputStream out, JarEntry jarEntry, InputStream in, boolean ignoreErrors) throws IOException {
        block3: {
            try {
                int nRead;
                out.putNextEntry(jarEntry);
                byte[] buffer = new byte[10240];
                while ((nRead = in.read(buffer)) > 0) {
                    out.write(buffer, 0, nRead);
                }
                in.close();
                out.closeEntry();
            }
            catch (ZipException exception) {
                if (ignoreErrors) break block3;
                throw exception;
            }
        }
    }

    private void prepareManifest() {
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        if (!this.manifest.getMainAttributes().containsKey(Attributes.Name.MANIFEST_VERSION)) {
            this.manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        if (this.mainClass != null) {
            this.manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, this.mainClass);
        }
    }

    private String getMainClass() {
        return (String)this.manifest.getMainAttributes().get(Attributes.Name.MAIN_CLASS);
    }
}

