/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.spy.preferences.handler;

import java.net.URL;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.pde.spy.preferences.handler.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.prefs.BackingStoreException;

public class TogglePreferenceTraceControl {
    @Inject
    Logger LOG;
    private ToolItem toolItem;
    private ResourceManager resourceManager;

    @Inject
    public void tracePreferenceChanged(@Preference(value="tracepreferences") boolean tracePreferences) {
        if (this.toolItem != null && !this.toolItem.isDisposed()) {
            this.toolItem.setSelection(tracePreferences);
        }
    }

    @PostConstruct
    public void createGui(Composite parent, final @Preference IEclipsePreferences preferences, @Preference(value="tracepreferences") boolean tracePreferences) {
        ToolBar toolBar = new ToolBar(parent, 0);
        this.toolItem = new ToolItem(toolBar, 32);
        this.toolItem.setSelection(tracePreferences);
        this.toolItem.setToolTipText(Messages.TogglePreferenceTraceControl_Toggle_Preference_Trace);
        this.toolItem.setImage(this.getResourceManager().createImage(this.getImageDescriptor()));
        this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object source = event.getSource();
                if (source instanceof ToolItem) {
                    preferences.putBoolean("tracepreferences", ((ToolItem)source).getSelection());
                    try {
                        preferences.flush();
                    }
                    catch (BackingStoreException e) {
                        TogglePreferenceTraceControl.this.LOG.error((Throwable)e);
                    }
                }
            }
        });
    }

    @PreDestroy
    public void dispose() {
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
        }
    }

    protected ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resourceManager;
    }

    protected ImageDescriptor getImageDescriptor() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("$nl$/icons/trace_preferences.png"), null);
        return ImageDescriptor.createFromURL((URL)url);
    }
}

