/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.record.emf;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.poi.hemf.draw.HemfDrawProperties;
import org.apache.poi.hemf.draw.HemfGraphics;
import org.apache.poi.hemf.record.emf.HemfDraw;
import org.apache.poi.hemf.record.emf.HemfFill;
import org.apache.poi.hemf.record.emf.HemfHeader;
import org.apache.poi.hemf.record.emf.HemfPenStyle;
import org.apache.poi.hemf.record.emf.HemfRecord;
import org.apache.poi.hemf.record.emf.HemfRecordType;
import org.apache.poi.hwmf.draw.HwmfDrawProperties;
import org.apache.poi.hwmf.draw.HwmfGraphics;
import org.apache.poi.hwmf.record.HwmfBinaryRasterOp;
import org.apache.poi.hwmf.record.HwmfBitmapDib;
import org.apache.poi.hwmf.record.HwmfBrushStyle;
import org.apache.poi.hwmf.record.HwmfColorRef;
import org.apache.poi.hwmf.record.HwmfFill;
import org.apache.poi.hwmf.record.HwmfHatchStyle;
import org.apache.poi.hwmf.record.HwmfMapMode;
import org.apache.poi.hwmf.record.HwmfMisc;
import org.apache.poi.hwmf.record.HwmfObjectTableEntry;
import org.apache.poi.hwmf.record.HwmfPalette;
import org.apache.poi.hwmf.record.HwmfPenStyle;
import org.apache.poi.util.LittleEndianInputStream;

public class HemfMisc {

    public static class EmfCreateMonoBrush
    implements HemfRecord,
    HwmfObjectTableEntry {
        protected int penIndex;
        protected HwmfFill.ColorUsage colorUsage;
        protected final HwmfBitmapDib bitmap = new HwmfBitmapDib();

        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.createMonoBrush;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            int startIdx = leis.getReadIndex();
            this.penIndex = (int)leis.readUInt();
            this.colorUsage = HwmfFill.ColorUsage.valueOf((int)leis.readUInt());
            int offBmi = (int)leis.readUInt();
            int cbBmi = (int)leis.readUInt();
            int offBits = (int)leis.readUInt();
            int cbBits = (int)leis.readUInt();
            int size = 24;
            size = (int)((long)size + HemfFill.readBitmap(leis, this.bitmap, startIdx, offBmi, cbBmi, offBits, cbBits));
            return size;
        }

        @Override
        public void draw(HemfGraphics ctx) {
            ctx.addObjectTableEntry(this, this.penIndex);
        }

        @Override
        public void applyObject(HwmfGraphics ctx) {
            if (!this.bitmap.isValid()) {
                return;
            }
            HwmfDrawProperties props = ctx.getProperties();
            props.setBrushStyle(HwmfBrushStyle.BS_PATTERN);
            BufferedImage bmp = this.bitmap.getImage();
            props.setBrushBitmap(bmp);
        }

        public String toString() {
            return "{ penIndex: " + this.penIndex + ", colorUsage: " + (Object)((Object)this.colorUsage) + ", bitmap: " + this.bitmap + "}";
        }
    }

    public static class EmfModifyWorldTransform
    implements HemfRecord {
        protected final AffineTransform xForm = new AffineTransform();
        protected HemfModifyWorldTransformMode modifyWorldTransformMode;
        protected HemfHeader header;

        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.modifyWorldTransform;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            int size = HemfFill.readXForm(leis, this.xForm);
            this.modifyWorldTransformMode = HemfModifyWorldTransformMode.valueOf((int)leis.readUInt());
            return size + 4;
        }

        @Override
        public void setHeader(HemfHeader header) {
            this.header = header;
        }

        @Override
        public void draw(HemfGraphics ctx) {
            AffineTransform tx;
            if (this.modifyWorldTransformMode == null) {
                return;
            }
            HemfDrawProperties prop = ctx.getProperties();
            switch (this.modifyWorldTransformMode) {
                case MWT_LEFTMULTIPLY: {
                    AffineTransform wsTrans;
                    boolean noSetWindowExYet;
                    Rectangle2D win = prop.getWindow();
                    boolean bl = noSetWindowExYet = win.getWidth() == 1.0 && win.getHeight() == 1.0;
                    if (noSetWindowExYet) {
                        try {
                            wsTrans = this.xForm.createInverse();
                        }
                        catch (NoninvertibleTransformException e) {
                            wsTrans = new AffineTransform();
                        }
                        Rectangle2D emfBounds = this.header.getBoundsRectangle();
                        if (this.xForm.getShearX() == -1.0 && this.xForm.getShearY() == 1.0) {
                            wsTrans.translate(-emfBounds.getHeight(), emfBounds.getHeight());
                        }
                    } else {
                        wsTrans = this.adaptXForm(ctx.getTransform());
                    }
                    tx = ctx.getTransform();
                    tx.concatenate(wsTrans);
                    break;
                }
                case MWT_RIGHTMULTIPLY: {
                    tx = ctx.getTransform();
                    tx.preConcatenate(this.adaptXForm(tx));
                    break;
                }
                case MWT_IDENTITY: {
                    ctx.updateWindowMapMode();
                    tx = ctx.getTransform();
                    break;
                }
                default: {
                    ctx.updateWindowMapMode();
                    tx = ctx.getTransform();
                    tx.concatenate(this.adaptXForm(tx));
                }
            }
            ctx.setTransform(tx);
        }

        private AffineTransform adaptXForm(AffineTransform other) {
            Function<Double, Double> nn = d -> d == 0.0 ? 0.0 : d;
            double yDiff = Math.signum(nn.apply(this.xForm.getTranslateY())) == Math.signum(nn.apply(other.getTranslateY())) ? 1.0 : -1.0;
            double xDiff = Math.signum(nn.apply(this.xForm.getTranslateX())) == Math.signum(nn.apply(other.getTranslateX())) ? 1.0 : -1.0;
            return new AffineTransform(this.xForm.getScaleX() == 0.0 ? 1.0 : this.xForm.getScaleX(), yDiff * this.xForm.getShearY(), xDiff * this.xForm.getShearX(), this.xForm.getScaleY() == 0.0 ? 1.0 : this.xForm.getScaleY(), this.xForm.getTranslateX(), this.xForm.getTranslateY());
        }

        public String toString() {
            return "{ xForm: { scaleX: " + this.xForm.getScaleX() + ", shearX: " + this.xForm.getShearX() + ", transX: " + this.xForm.getTranslateX() + ", scaleY: " + this.xForm.getScaleY() + ", shearY: " + this.xForm.getShearY() + ", transY: " + this.xForm.getTranslateY() + " }, modifyWorldTransformMode: '" + (Object)((Object)this.modifyWorldTransformMode) + "' }";
        }
    }

    public static class EmfSetWorldTransform
    implements HemfRecord {
        protected final AffineTransform xForm = new AffineTransform();

        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.setWorldTransform;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            return HemfFill.readXForm(leis, this.xForm);
        }

        @Override
        public void draw(HemfGraphics ctx) {
            ctx.updateWindowMapMode();
            AffineTransform tx = ctx.getTransform();
            tx.concatenate(this.xForm);
            ctx.setTransform(tx);
        }

        public String toString() {
            return "{ xForm: { scaleX: " + this.xForm.getScaleX() + ", shearX: " + this.xForm.getShearX() + ", transX: " + this.xForm.getTranslateX() + ", scaleY: " + this.xForm.getScaleY() + ", shearY: " + this.xForm.getShearY() + ", transY: " + this.xForm.getTranslateY() + " } }";
        }
    }

    public static class EmfSetBrushOrgEx
    implements HemfRecord {
        protected final Point2D origin = new Point2D.Double();

        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.setBrushOrgEx;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            return HemfDraw.readPointL(leis, this.origin);
        }

        public String toString() {
            return "{ x: " + this.origin.getX() + ", y: " + this.origin.getY() + " }";
        }
    }

    public static class EmfSetMiterLimit
    implements HemfRecord {
        protected int miterLimit;

        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.setMiterLimit;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            this.miterLimit = (int)leis.readUInt();
            return 4L;
        }

        @Override
        public void draw(HemfGraphics ctx) {
            ctx.getProperties().setPenMiterLimit(this.miterLimit);
        }

        public String toString() {
            return "{ miterLimit: " + this.miterLimit + " }";
        }
    }

    public static class EmfExtCreatePen
    extends EmfCreatePen {
        protected HwmfBrushStyle brushStyle;
        protected HwmfHatchStyle hatchStyle;
        protected final HwmfBitmapDib bitmap = new HwmfBitmapDib();

        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.extCreatePen;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            int startIdx = leis.getReadIndex();
            this.penIndex = (int)leis.readUInt();
            int offBmi = (int)leis.readUInt();
            int cbBmi = (int)leis.readUInt();
            int offBits = (int)leis.readUInt();
            int cbBits = (int)leis.readUInt();
            HemfPenStyle emfPS = HemfPenStyle.valueOf((int)leis.readUInt());
            this.penStyle = emfPS;
            long width = leis.readUInt();
            this.dimension.setSize(width, 0.0);
            int size = 28;
            this.brushStyle = HwmfBrushStyle.valueOf((int)leis.readUInt());
            size += 4;
            size += this.colorRef.init(leis);
            this.hatchStyle = HwmfHatchStyle.valueOf(leis.readInt());
            size += 4;
            int numStyleEntries = (int)leis.readUInt();
            size += 4;
            assert (numStyleEntries == 0 || this.penStyle.getLineDash() == HwmfPenStyle.HwmfLineDash.USERSTYLE);
            float[] dashPattern = new float[numStyleEntries];
            for (int i = 0; i < numStyleEntries; ++i) {
                dashPattern[i] = (int)leis.readUInt();
            }
            if (this.penStyle.getLineDash() == HwmfPenStyle.HwmfLineDash.USERSTYLE) {
                emfPS.setLineDashes(dashPattern);
            }
            size += numStyleEntries * 4;
            size = (int)((long)size + HemfFill.readBitmap(leis, this.bitmap, startIdx, offBmi, cbBmi, offBits, cbBits));
            return size;
        }

        @Override
        public String toString() {
            return "{ brushStyle: '" + (Object)((Object)this.brushStyle) + "', hatchStyle: '" + (Object)((Object)this.hatchStyle) + "', dashPattern: " + Arrays.toString(this.penStyle.getLineDashes()) + ", " + super.toString().substring(1);
        }
    }

    public static class EmfCreatePen
    extends HwmfMisc.WmfCreatePenIndirect
    implements HemfRecord {
        protected int penIndex;

        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.createPen;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            this.penIndex = (int)leis.readUInt();
            this.penStyle = HwmfPenStyle.valueOf((int)leis.readUInt());
            int widthX = leis.readInt();
            int widthY = leis.readInt();
            this.dimension.setSize(widthX, widthY);
            int size = this.colorRef.init(leis);
            return size + 16;
        }

        @Override
        public void draw(HemfGraphics ctx) {
            ctx.addObjectTableEntry(this, this.penIndex);
        }

        @Override
        public String toString() {
            return super.toString().replaceFirst("\\{", "{ penIndex: " + this.penIndex + ", ");
        }
    }

    public static class EmfDeleteObject
    extends HwmfMisc.WmfDeleteObject
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.deleteobject;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            this.objectIndex = (int)leis.readUInt();
            return 4L;
        }
    }

    public static class EmfCreateDibPatternBrushPt
    extends HwmfMisc.WmfDibCreatePatternBrush
    implements HemfRecord {
        protected int brushIdx;

        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.createDibPatternBrushPt;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            int startIdx = leis.getReadIndex();
            this.style = HwmfBrushStyle.BS_DIBPATTERNPT;
            this.brushIdx = (int)leis.readUInt();
            this.colorUsage = HwmfFill.ColorUsage.valueOf((int)leis.readUInt());
            int offBmi = leis.readInt();
            int cbBmi = leis.readInt();
            int offBits = leis.readInt();
            int cbBits = leis.readInt();
            int size = 24;
            this.patternDib = new HwmfBitmapDib();
            size = (int)((long)size + HemfFill.readBitmap(leis, this.patternDib, startIdx, offBmi, cbBmi, offBits, cbBits));
            return size;
        }

        @Override
        public void draw(HemfGraphics ctx) {
            ctx.addObjectTableEntry(this, this.brushIdx);
        }
    }

    public static class EmfCreateBrushIndirect
    extends HwmfMisc.WmfCreateBrushIndirect
    implements HemfRecord {
        private int brushIdx;

        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.createBrushIndirect;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            this.brushIdx = (int)leis.readUInt();
            this.brushStyle = HwmfBrushStyle.valueOf((int)leis.readUInt());
            this.colorRef = new HwmfColorRef();
            int size = this.colorRef.init(leis);
            this.brushHatch = HwmfHatchStyle.valueOf((int)leis.readUInt());
            return size + 12;
        }

        @Override
        public void draw(HemfGraphics ctx) {
            ctx.addObjectTableEntry(this, this.brushIdx);
        }

        @Override
        public String toString() {
            return "{ brushIndex: " + this.brushIdx + ", brushStyle: '" + (Object)((Object)this.brushStyle) + "', colorRef: " + this.colorRef + ", brushHatch: '" + (Object)((Object)this.brushHatch) + "' }";
        }
    }

    public static class EmfSetStretchBltMode
    extends HwmfMisc.WmfSetStretchBltMode
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.setStretchBltMode;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            this.stretchBltMode = HwmfMisc.WmfSetStretchBltMode.StretchBltMode.valueOf((int)leis.readUInt());
            return 4L;
        }
    }

    public static class EmfSetRop2
    extends HwmfMisc.WmfSetRop2
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.setRop2;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            this.drawMode = HwmfBinaryRasterOp.valueOf((int)leis.readUInt());
            return 4L;
        }
    }

    public static class EmfSetMapMode
    extends HwmfMisc.WmfSetMapMode
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.setMapMode;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            this.mapMode = HwmfMapMode.valueOf((int)leis.readUInt());
            return 4L;
        }
    }

    public static class EmfSetMapperFlags
    extends HwmfMisc.WmfSetMapperFlags
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.setMapperFlags;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            return super.init(leis, recordSize, (int)recordId);
        }
    }

    public static class EmfSetBkMode
    extends HwmfMisc.WmfSetBkMode
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.setBkMode;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            this.bkMode = HwmfMisc.WmfSetBkMode.HwmfBkMode.valueOf((int)leis.readUInt());
            return 4L;
        }
    }

    public static class EmfSetBkColor
    extends HwmfMisc.WmfSetBkColor
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.setBkColor;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            return this.colorRef.init(leis);
        }
    }

    public static class EmfRestoreDc
    extends HwmfMisc.WmfRestoreDc
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.restoreDc;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            this.nSavedDC = leis.readInt();
            return 4L;
        }
    }

    public static class EmfSaveDc
    extends HwmfMisc.WmfSaveDc
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.saveDc;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            return 0L;
        }
    }

    public static class EmfEof
    implements HemfRecord {
        protected final List<HwmfPalette.PaletteEntry> palette = new ArrayList<HwmfPalette.PaletteEntry>();

        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.eof;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            int startIdx = leis.getReadIndex();
            int nPalEntries = (int)leis.readUInt();
            int offPalEntries = (int)leis.readUInt();
            int size = 8;
            if (nPalEntries > 0 && offPalEntries > 0) {
                int undefinedSpace1 = offPalEntries - (size + 8);
                assert (undefinedSpace1 >= 0);
                leis.skipFully(undefinedSpace1);
                size += undefinedSpace1;
                for (int i = 0; i < nPalEntries; ++i) {
                    HwmfPalette.PaletteEntry pe = new HwmfPalette.PaletteEntry();
                    size += pe.init(leis);
                }
                int undefinedSpace2 = (int)(recordSize - (long)size - 4L);
                assert (undefinedSpace2 >= 0);
                leis.skipFully(undefinedSpace2);
                size += undefinedSpace2;
            }
            long sizeLast = leis.readUInt();
            assert (recordSize == (long)(size += 4));
            return size;
        }
    }

    public static enum HemfModifyWorldTransformMode {
        MWT_IDENTITY(1),
        MWT_LEFTMULTIPLY(2),
        MWT_RIGHTMULTIPLY(3),
        MWT_SET(4);

        public final int id;

        private HemfModifyWorldTransformMode(int id) {
            this.id = id;
        }

        public static HemfModifyWorldTransformMode valueOf(int id) {
            for (HemfModifyWorldTransformMode wrt : HemfModifyWorldTransformMode.values()) {
                if (wrt.id != id) continue;
                return wrt;
            }
            return null;
        }
    }
}

