/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.Messages;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class CompCSFileValidator
implements ISelectionStatusValidator {
    public IStatus validate(Object[] selection) {
        if (selection.length == 0) {
            return this.errorStatus("");
        }
        if (!(selection[0] instanceof IFile)) {
            return this.errorStatus("");
        }
        IFile file = (IFile)selection[0];
        if (!this.isSimpleCSFile(file)) {
            return this.errorStatus(Messages.CompCSFileValidator_0);
        }
        return this.okStatus("");
    }

    private boolean isSimpleCSFile(IFile file) {
        try {
            IContentDescription description = file.getContentDescription();
            IContentType type = description.getContentType();
            return type.getId().equalsIgnoreCase("org.eclipse.pde.simpleCheatSheet");
        }
        catch (CoreException e) {
            PDEUserAssistanceUIPlugin.logException(e);
            return false;
        }
    }

    private IStatus errorStatus(String message) {
        return new Status(4, "org.eclipse.pde.ua.ui", 4, message, null);
    }

    private IStatus okStatus(String message) {
        return new Status(0, "org.eclipse.pde.ua.ui", 0, message, null);
    }
}

