/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

class CopyTreeSelectionAction
extends Action {
    private Tree fTree;

    public CopyTreeSelectionAction(Tree tree) {
        this.fTree = tree;
        this.setText(PDEUIMessages.EditorActions_copy);
        ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setActionDefinitionId(ActionFactory.COPY.getCommandId());
    }

    public void run() {
        TreeItem[] selection = this.fTree.getSelection();
        if (selection.length == 0) {
            return;
        }
        Collection<TreeItem> itemsToCopy = this.filterDuplicates(selection);
        StringBuilder buffer = new StringBuilder();
        itemsToCopy.forEach(item -> this.appendItem(buffer, (TreeItem)item, 0));
        Clipboard clipboard = new Clipboard(this.fTree.getDisplay());
        try {
            clipboard.setContents(new Object[]{buffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            clipboard.dispose();
        }
    }

    private Collection<TreeItem> filterDuplicates(TreeItem[] items) {
        LinkedHashSet<TreeItem> deduplicated = new LinkedHashSet<TreeItem>();
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            if (!this.containsAnyParent(item, deduplicated)) {
                deduplicated.add(item);
            }
            ++i;
        }
        return deduplicated;
    }

    private boolean containsAnyParent(TreeItem item, Collection<TreeItem> items) {
        TreeItem parent = item.getParentItem();
        while (parent != null) {
            if (items.contains(parent)) {
                return true;
            }
            parent = parent.getParentItem();
        }
        return false;
    }

    private void appendItem(StringBuilder buffer, TreeItem item, int indent) {
        if (buffer.length() > 0) {
            buffer.append(System.lineSeparator());
        }
        int i = 0;
        while (i < indent) {
            buffer.append('\t');
            ++i;
        }
        buffer.append(item.getText());
        if (item.getExpanded()) {
            TreeItem[] children = item.getItems();
            int i2 = 0;
            while (i2 < children.length) {
                this.appendItem(buffer, children[i2], indent + 1);
                ++i2;
            }
        }
    }
}

