/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.util;

import org.eclipse.help.internal.base.util.IErrorUtil;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ErrorUtil
implements IErrorUtil {
    public void displayError(String msg) {
        ErrorUtil.displayErrorDialog(msg);
    }

    public void displayError(String msg, Thread uiThread) {
        try {
            Display.findDisplay((Thread)uiThread).asyncExec(() -> ErrorUtil.displayErrorDialog(msg));
        }
        catch (Exception exception) {}
    }

    public static void displayErrorDialog(String msg) {
        String title = Messages.Help_Error;
        IWorkbenchWindow workbenchWindow = ErrorUtil.getActiveWorkbenchWindow();
        Shell shell = workbenchWindow != null ? workbenchWindow.getShell() : new Shell();
        MessageDialog.openError((Shell)shell, (String)title, (String)msg);
    }

    public static void displayInfoDialog(String msg) {
        String title = Messages.Help_Info;
        IWorkbenchWindow workbenchWindow = ErrorUtil.getActiveWorkbenchWindow();
        Shell shell = workbenchWindow != null ? workbenchWindow.getShell() : new Shell();
        MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
    }

    public static boolean displayQuestionDialog(String msg) {
        String title = Messages.Help_Question;
        IWorkbenchWindow workbenchWindow = ErrorUtil.getActiveWorkbenchWindow();
        Shell shell = workbenchWindow != null ? workbenchWindow.getShell() : new Shell();
        return MessageDialog.openQuestion((Shell)shell, (String)title, (String)msg);
    }

    protected static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }
}

